/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.generic;

import java.util.List;
import java.util.Stack;
import org.antlr.works.ate.syntax.misc.ATEToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATESyntaxParser {
    private List<ATEToken> tokens;
    private Stack<Integer> marks = new Stack();
    private int position;
    private ATEToken t0;
    private ATEToken t1;

    public void close() {
        if (this.tokens != null) {
            this.tokens.clear();
        }
        this.t1 = null;
        this.t0 = null;
    }

    public void parse(List<ATEToken> list) {
        this.tokens = list;
        this.marks.clear();
        this.position = -1;
        this.clearTokenCache();
        this.parseTokens();
    }

    public abstract void parseTokens();

    public List<ATEToken> getTokens() {
        return this.tokens;
    }

    public int getPosition() {
        return this.position;
    }

    public void mark() {
        this.marks.push(this.position);
    }

    public void rewind() {
        this.position = this.marks.pop();
        this.clearTokenCache();
    }

    public boolean previousToken() {
        --this.position;
        this.clearTokenCache();
        return this.position >= 0;
    }

    public boolean nextToken() {
        ++this.position;
        this.clearTokenCache();
        return this.position < this.tokens.size();
    }

    public boolean moreTokens() {
        return this.position < this.tokens.size();
    }

    public boolean skip(int n) {
        if (n == 1) {
            return this.nextToken();
        }
        for (int i = 0; i < n; ++i) {
            if (this.nextToken()) continue;
            return false;
        }
        return true;
    }

    public ATEToken T(int n) {
        if (n == 0) {
            if (this.t0 == null) {
                this.t0 = this.getToken(0);
            }
            return this.t0;
        }
        if (n == 1) {
            if (this.t1 == null) {
                this.t1 = this.getToken(1);
            }
            return this.t1;
        }
        return this.getToken(n);
    }

    public ATEToken getToken(int n) {
        if (this.position + n >= 0 && this.position + n < this.tokens.size()) {
            return this.tokens.get(this.position + n);
        }
        return null;
    }

    private void clearTokenCache() {
        this.t0 = null;
        this.t1 = null;
    }

    public boolean matchSingleComment(int n) {
        if (this.isSingleComment(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean matchComplexComment(int n) {
        if (this.isComplexComment(n)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean isChar(int n, String string) {
        return this.isTokenType(n, 6) && this.T(n).getAttribute().equals(string);
    }

    public boolean isSingleComment(int n) {
        return this.isTokenType(n, 3);
    }

    public boolean isComplexComment(int n) {
        return this.isTokenType(n, 4);
    }

    public boolean isID(int n) {
        return this.isTokenType(n, 5);
    }

    public boolean isID(int n, String string) {
        return this.isTokenType(n, 5) && this.T(n).getAttribute().equals(string);
    }

    public boolean isTokenType(int n, int n2) {
        return this.T(n) != null && this.T((int)n).type == n2;
    }
}

