/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.generic;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.ate.syntax.generic.ATESyntaxLexer;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATESyntaxEngine {
    protected ATESyntaxEngineDelegate delegate;
    protected ATESyntaxLexer lexer = this.createLexer();
    protected ATESyntaxParser parser = this.createParser();
    protected List<ATEToken> tokens;
    protected static int delay = 250;

    public void close() {
        this.parser.close();
        this.parser = null;
        this.lexer.close();
        this.lexer = null;
        this.delegate = null;
    }

    public void setDelegate(ATESyntaxEngineDelegate aTESyntaxEngineDelegate) {
        this.delegate = aTESyntaxEngineDelegate;
    }

    public static void setDelay(int n) {
        delay = n;
    }

    public synchronized List<ATEToken> getTokens() {
        return this.tokens;
    }

    public synchronized List<ATELine> getLines() {
        return this.lexer.getLines();
    }

    public synchronized int getMaxLines() {
        return this.lexer.getLineNumber();
    }

    public ATESyntaxLexer getLexer() {
        return this.lexer;
    }

    public ATESyntaxParser getParser() {
        return this.parser;
    }

    protected synchronized void lexerDidRun(ATESyntaxLexer aTESyntaxLexer) {
    }

    protected synchronized void parserDidRun(ATESyntaxParser aTESyntaxParser) {
    }

    public abstract ATESyntaxLexer createLexer();

    public abstract ATESyntaxParser createParser();

    public abstract AttributeSet getAttributeForToken(ATEToken var1);

    public void refreshColoring() {
    }

    public void processSyntax() {
        this.lexer.tokenize(this.delegate.getText());
        this.tokens = new ArrayList<ATEToken>(this.lexer.getTokens());
        this.lexerDidRun(this.lexer);
        if (this.parser != null) {
            this.parser.parse(this.tokens);
            this.parserDidRun(this.parser);
        }
    }

    public void process() {
        this.delegate.ateEngineWillParse();
        this.processSyntax();
        this.delegate.ateEngineDidParse();
    }
}

