/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngine;
import org.antlr.works.ate.syntax.misc.ATEToken;

public class ATERenderingView
extends PlainView {
    public static final Color BACKGROUND_HIGHLIGHT_COLOR = new Color(1.0f, 1.0f, 0.5f, 0.3f);
    public static Font DEFAULT_FONT;
    protected ATEPanel textEditor;
    protected ATETextPane textPane;
    protected List<ATEToken> tokens;
    protected DisplayOperation displayOp = new DisplayOperation();
    protected ModelToViewOperation modelToViewOp = new ModelToViewOperation();
    protected ViewToModel viewToModelOp = new ViewToModel();
    protected Graphics currentGraphics;
    protected Color savedColor;

    public ATERenderingView(Element element, ATEPanel aTEPanel) {
        super(element);
        this.textEditor = aTEPanel;
        this.textPane = aTEPanel.getTextPane();
    }

    public void close() {
        this.textEditor = null;
        this.textPane = null;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        if (this.textPane.highlightCursorLine()) {
            Element element = this.getElement().getElement(n);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            int n6 = this.textPane.getCaretPosition() + 1;
            if (n6 > n4 && n6 <= n5) {
                this.saveColor(graphics);
                graphics.setColor(BACKGROUND_HIGHLIGHT_COLOR);
                int n7 = this.metrics.getHeight();
                graphics.fillRect(0, n3 - n7 + this.metrics.getDescent(), this.textPane.getWidth(), n7);
                this.restore(graphics);
            }
        }
        super.drawLine(n, graphics, n2, n3);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (this.textEditor == null || !this.textEditor.isSyntaxColoring()) {
            return super.modelToView(n, shape, bias);
        }
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        Rectangle rectangle = this.lineToRect(shape, n2);
        rectangle.x += this.renderText(this.modelToViewOp, this.currentGraphics, 0, 0, n3, n);
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (this.textEditor == null || !this.textEditor.isSyntaxColoring()) {
            return super.viewToModel(f, f2, shape, biasArray);
        }
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        if (f2 < (float)rectangle.y) {
            return this.getStartOffset();
        }
        if (f2 > (float)(rectangle.y + rectangle.height)) {
            return this.getEndOffset() - 1;
        }
        Element element = this.getElement();
        int n = Math.abs(((int)f2 - rectangle.y) / this.metrics.getHeight());
        if (n >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n);
        if (f < (float)rectangle.x) {
            return element2.getStartOffset();
        }
        if (f > (float)(rectangle.x + rectangle.width)) {
            return element2.getEndOffset() - 1;
        }
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            this.viewToModelOp.setParameters((int)f, n2);
            this.renderText(this.viewToModelOp, this.currentGraphics, rectangle.x, (int)f2, n2, n3);
            return this.viewToModelOp.modelPos;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.currentGraphics = graphics;
        return this.renderText(this.displayOp, graphics, n, n2, n3, n4);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.currentGraphics = graphics;
        return this.renderText(this.displayOp, graphics, n, n2, n3, n4);
    }

    protected int renderText(TextOperation textOperation, Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        int n5;
        if (n3 == n4) {
            return n;
        }
        if (!this.textEditor.isSyntaxColoring()) {
            return super.drawUnselectedText(graphics, n, n2, n3, n4);
        }
        Document document = this.getDocument();
        ATESyntaxEngine aTESyntaxEngine = this.textEditor.getParserEngine();
        this.tokens = aTESyntaxEngine.getTokens();
        int n6 = n3;
        for (int i = n5 = this.findStartingTokenIndex(n3, 0, this.tokens.size(), 0); i < this.tokens.size(); ++i) {
            ATEToken aTEToken = this.tokens.get(i);
            AttributeSet attributeSet = aTESyntaxEngine.getAttributeForToken(aTEToken);
            if (aTEToken.start >= n3 && aTEToken.start <= n4) {
                if (aTEToken.start > n6) {
                    n = textOperation.renderTextPortion(graphics, n, n2, n6, aTEToken.start, n4, document, null);
                }
                n = textOperation.renderTextPortion(graphics, n, n2, aTEToken.start, aTEToken.end, n4, document, attributeSet);
                n6 = aTEToken.end;
                continue;
            }
            if (aTEToken.end >= n3 && aTEToken.start < n3) {
                n = textOperation.renderTextPortion(graphics, n, n2, n3, aTEToken.end, n4, document, attributeSet);
                n6 = aTEToken.end;
                continue;
            }
            if (aTEToken.start > n4) break;
        }
        if (n6 < n4) {
            n = textOperation.renderTextPortion(graphics, n, n2, n6, n4, n4, document, null);
        }
        return n;
    }

    private int findStartingTokenIndex(int n, int n2, int n3, int n4) {
        if (Math.abs(n3 - n2) <= 1) {
            return Math.min(n4, n2);
        }
        int n5 = n2 + (n3 - n2) / 2;
        ATEToken aTEToken = this.tokens.get(n5);
        if (n >= aTEToken.startLineIndex && n <= aTEToken.endLineIndex) {
            return this.findStartingTokenIndex(n, n2, n5, n5);
        }
        if (aTEToken.startLineIndex < n) {
            return this.findStartingTokenIndex(n, n5, n3, n4);
        }
        return this.findStartingTokenIndex(n, n2, n5, n4);
    }

    protected void applyAttribute(Graphics graphics, AttributeSet attributeSet) {
        if (attributeSet == null) {
            graphics.setColor(Color.black);
            graphics.setFont(DEFAULT_FONT);
            return;
        }
        graphics.setFont(this.getFontForAttribute(attributeSet));
        Color color = StyleConstants.getForeground(attributeSet);
        if (color == null) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(color);
        }
    }

    protected Font getFontForAttribute(AttributeSet attributeSet) {
        Font font = DEFAULT_FONT;
        if (StyleConstants.isBold(attributeSet)) {
            font = font.deriveFont(1);
        }
        if (StyleConstants.isItalic(attributeSet)) {
            font = font.deriveFont(2);
        }
        return font;
    }

    protected void saveColor(Graphics graphics) {
        this.savedColor = graphics.getColor();
    }

    protected void restore(Graphics graphics) {
        graphics.setColor(this.savedColor);
    }

    public class ViewToModel
    implements TextOperation {
        private int modelPos;
        private int viewX;

        public void setParameters(int n, int n2) {
            this.viewX = n;
            this.modelPos = n2;
        }

        public int renderTextPortion(Graphics graphics, int n, int n2, int n3, int n4, int n5, Document document, AttributeSet attributeSet) throws BadLocationException {
            if (graphics == null) {
                return 0;
            }
            int n6 = n4 - n3;
            if (n3 + n6 > n5) {
                n6 = n5 - n3;
            }
            ATERenderingView.this.saveColor(graphics);
            ATERenderingView.this.applyAttribute(graphics, attributeSet);
            Segment segment = ATERenderingView.this.getLineBuffer();
            document.getText(n3, n6, segment);
            this.modelPos += Utilities.getTabbedTextOffset(segment, graphics.getFontMetrics(), n, this.viewX, ATERenderingView.this, n3);
            n += Utilities.getTabbedTextWidth(segment, graphics.getFontMetrics(), n, (TabExpander)ATERenderingView.this, n3);
            ATERenderingView.this.restore(graphics);
            return n;
        }
    }

    public class ModelToViewOperation
    implements TextOperation {
        public int renderTextPortion(Graphics graphics, int n, int n2, int n3, int n4, int n5, Document document, AttributeSet attributeSet) throws BadLocationException {
            if (graphics == null) {
                return 0;
            }
            int n6 = n4 - n3;
            if (n3 + n6 > n5) {
                n6 = n5 - n3;
            }
            ATERenderingView.this.saveColor(graphics);
            ATERenderingView.this.applyAttribute(graphics, attributeSet);
            Segment segment = ATERenderingView.this.getLineBuffer();
            document.getText(n3, n6, segment);
            n += Utilities.getTabbedTextWidth(segment, graphics.getFontMetrics(), n, (TabExpander)ATERenderingView.this, n3);
            ATERenderingView.this.restore(graphics);
            return n;
        }
    }

    public class DisplayOperation
    implements TextOperation {
        public int renderTextPortion(Graphics graphics, int n, int n2, int n3, int n4, int n5, Document document, AttributeSet attributeSet) throws BadLocationException {
            if (graphics == null) {
                return 0;
            }
            int n6 = n4 - n3;
            if (n3 + n6 > n5) {
                n6 = n5 - n3;
            }
            ATERenderingView.this.saveColor(graphics);
            ATERenderingView.this.applyAttribute(graphics, attributeSet);
            Segment segment = ATERenderingView.this.getLineBuffer();
            document.getText(n3, n6, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)ATERenderingView.this, n3);
            ATERenderingView.this.restore(graphics);
            return n;
        }
    }

    public static interface TextOperation {
        public int renderTextPortion(Graphics var1, int var2, int var3, int var4, int var5, int var6, Document var7, AttributeSet var8) throws BadLocationException;
    }
}

