/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.antlr.works.ate.ATETextPane;
import org.antlr.xjlib.foundation.XJSystem;

public class ATEKeyBindings {
    private ATETextPane textComponent = null;

    public ATEKeyBindings(ATETextPane aTETextPane) {
        this.textComponent = aTETextPane;
        this.textComponent.setKeyBindings(this);
        if (XJSystem.isMacOS()) {
            this.addEmacsKeyBindings();
        }
        this.addStandardKeyBindings();
        this.setEnableWritableActions(false);
    }

    public void close() {
        this.textComponent.getActionMap().clear();
        this.textComponent.getInputMap().clear();
        this.textComponent = null;
    }

    public void setEnableWritableActions(boolean bl) {
        ActionMap actionMap = this.textComponent.getActionMap();
        actionMap.get("paste").setEnabled(bl);
        actionMap.get("paste-from-clipboard").setEnabled(bl);
    }

    public void addStandardKeyBindings() {
        InputMap inputMap = this.textComponent.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(36, 0);
        inputMap.put(keyStroke, "caret-begin-line");
        keyStroke = KeyStroke.getKeyStroke(36, 1);
        inputMap.put(keyStroke, "selection-begin-line");
        keyStroke = KeyStroke.getKeyStroke(35, 0);
        inputMap.put(keyStroke, "caret-end-line");
        keyStroke = KeyStroke.getKeyStroke(35, 1);
        inputMap.put(keyStroke, "selection-end-line");
        this.addKeyBinding("SHIFT_DELETE", KeyStroke.getKeyStroke(127, 1), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                ATEKeyBindings.this.textComponent.getActionMap().get("delete-next").actionPerformed(actionEvent);
            }
        });
    }

    public void addEmacsKeyBindings() {
        InputMap inputMap = this.textComponent.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(keyStroke, "caret-backward");
        keyStroke = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(keyStroke, "caret-forward");
        keyStroke = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(keyStroke, "caret-up");
        keyStroke = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(keyStroke, "caret-down");
        keyStroke = KeyStroke.getKeyStroke(65, 2);
        inputMap.put(keyStroke, "caret-begin-line");
        keyStroke = KeyStroke.getKeyStroke(69, 2);
        inputMap.put(keyStroke, "caret-end-line");
        this.addKeyBinding("CONTROL_D", KeyStroke.getKeyStroke(68, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                ATEKeyBindings.this.textComponent.getActionMap().get("delete-next").actionPerformed(actionEvent);
            }
        });
        this.addKeyBinding("CONTROL_K", KeyStroke.getKeyStroke(75, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string;
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                int n2 = ATEKeyBindings.this.textComponent.getCaretPosition();
                Document document = ATEKeyBindings.this.textComponent.getDocument();
                try {
                    string = document.getText(n2, document.getLength() - n2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
                for (n = 0; n < string.length() && string.charAt(n) != '\n' && string.charAt(n) != '\r'; ++n) {
                }
                try {
                    n = Math.max(1, n);
                    String string2 = document.getText(n2, n);
                    document.remove(n2, n);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(string2), null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        this.addKeyBinding("CONTROL_T", KeyStroke.getKeyStroke(84, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ATEKeyBindings.this.textComponent.isWritable()) {
                    return;
                }
                int n = ATEKeyBindings.this.textComponent.getCaretPosition();
                Document document = ATEKeyBindings.this.textComponent.getDocument();
                if (n < 1 || n >= document.getLength()) {
                    return;
                }
                try {
                    String string = document.getText(n - 1, 1);
                    document.remove(n - 1, 1);
                    document.insertString(n, string, null);
                    ATEKeyBindings.this.textComponent.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    public void addKeyBinding(String string, KeyStroke keyStroke, AbstractAction abstractAction) {
        this.textComponent.getActionMap().put(string, abstractAction);
        this.textComponent.getInputMap().put(keyStroke, string);
    }
}

