/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.swing;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.antlr.works.ate.ATEPanel;

public class ATEAutoIndentation
implements Runnable {
    protected int offset;
    protected int length;
    protected boolean enabled = true;
    protected ATEPanel textEditor;

    public ATEAutoIndentation(ATEPanel aTEPanel) {
        this.textEditor = aTEPanel;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void indent(int n, int n2) {
        this.offset = n;
        this.length = n2;
        if (this.enabled()) {
            SwingUtilities.invokeLater(this);
        }
    }

    public Document getDocument() {
        return this.textEditor.getTextPane().getDocument();
    }

    public boolean autoIndentAfterReturn() throws BadLocationException {
        String string = this.getDocument().getText(this.offset - 1, this.length + 1);
        if (string.length() == 0) {
            return false;
        }
        if (string.length() == 1 || string.charAt(0) != '\n' && string.charAt(1) == '\n') {
            String string2 = this.getDocument().getText(0, this.offset);
            for (int i = this.offset - 2; i >= 0; --i) {
                if (string2.charAt(i) != '\n' && i != 0) continue;
                if (i > 0) {
                    ++i;
                }
                int n = i;
                while (i < this.offset - 1 && (string2.charAt(i) == ' ' || string2.charAt(i) == '\t')) {
                    ++i;
                }
                if (i == this.offset - 1 && (string2.charAt(i) == ' ' || string2.charAt(i) == '\t')) {
                    ++i;
                }
                this.getDocument().insertString(this.offset + 1, string2.substring(n, i), null);
                return true;
            }
        }
        return false;
    }

    public void run() {
        try {
            if (!this.autoIndentAfterReturn()) {
                this.textEditor.ateAutoIndent(this.offset, this.length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

