/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.folding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.folding.ATEFoldingEntityProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATEFoldingManager {
    protected ATEPanel textEditor;
    protected Set<Integer> usedEntityLines = new HashSet<Integer>();
    protected List<ATEFoldingEntity> entities = new ArrayList<ATEFoldingEntity>();

    public ATEFoldingManager(ATEPanel aTEPanel) {
        this.textEditor = aTEPanel;
    }

    public void close() {
        this.textEditor = null;
    }

    public void textPaneWillFold() {
    }

    public void textPaneDidFold() {
        this.textEditor.refresh();
    }

    public abstract ATEFoldingEntityProxy createEntityProxy(ATEFoldingEntity var1);

    public abstract ATEFoldingEntity getEntityForKey(Object var1, int var2);

    public void addEntity(ATEFoldingEntity aTEFoldingEntity) {
        Integer n = aTEFoldingEntity.foldingEntityGetStartLine();
        Integer n2 = aTEFoldingEntity.foldingEntityGetEndLine();
        if (this.usedEntityLines.contains(n) || this.usedEntityLines.contains(n2)) {
            return;
        }
        this.usedEntityLines.add(n);
        this.usedEntityLines.add(n2);
        this.entities.add(aTEFoldingEntity);
    }

    public List<ATEFoldingEntity> getFoldingEntities() {
        this.usedEntityLines.clear();
        this.entities.clear();
        this.provideFoldingEntities();
        return this.entities;
    }

    public abstract void provideFoldingEntities();

    public void toggleFolding(ATEFoldingEntity aTEFoldingEntity) {
    }
}

