/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.analysis;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.analysis.ATEAnalysisColumnOverlay;
import org.antlr.works.ate.analysis.ATEAnalysisItem;
import org.antlr.works.ate.analysis.ATEAnalysisManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATEAnalysisColumn
extends JPanel {
    protected ATEPanel textEditor;
    protected ATEAnalysisColumnOverlay overlay;
    protected ColumnAnalysisBox analysisBox;
    protected int topOffset = 30;
    protected int bottomOffset = 50;
    protected int lineCount;

    public ATEAnalysisColumn(ATEPanel aTEPanel) {
        this.textEditor = aTEPanel;
        this.setFocusable(false);
        this.analysisBox = new ColumnAnalysisBox();
        this.overlay = new ATEAnalysisColumnOverlay(aTEPanel.getParentFrame(), this);
        this.addMouseMotionListener(new ColumnMouseMotionAdapter());
        this.addMouseListener(new ColumnMouseAdapter());
    }

    public void close() {
        this.overlay.close();
        this.overlay = null;
    }

    public ATEAnalysisManager getAnalysisManager() {
        return this.textEditor.getAnalysisManager();
    }

    public Rectangle getDrawingBounds() {
        Rectangle rectangle = this.getBounds();
        rectangle.y = this.topOffset;
        rectangle.height -= this.topOffset + this.bottomOffset;
        return rectangle;
    }

    public Rectangle composeIndicatorRectangle(int n, int n2) {
        Rectangle rectangle = this.getDrawingBounds();
        float f = (float)n / (float)this.lineCount;
        int n3 = (int)((float)rectangle.y + (float)rectangle.height * f);
        return new Rectangle(3, n3 - n2, rectangle.width - 6, 2 + 2 * n2);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        ATEAnalysisManager aTEAnalysisManager = this.getAnalysisManager();
        if (aTEAnalysisManager == null) {
            return;
        }
        this.lineCount = aTEAnalysisManager.getLinesCount();
        Graphics2D graphics2D = (Graphics2D)graphics;
        int[] nArray = aTEAnalysisManager.getAvailableTypes();
        for (int i = 0; i < nArray.length; ++i) {
            this.paintStrips(graphics2D, aTEAnalysisManager.getItemsForType(i));
        }
        this.analysisBox.paint(graphics);
    }

    protected void paintStrips(Graphics2D graphics2D, List<ATEAnalysisItem> list) {
        for (ATEAnalysisItem aTEAnalysisItem : list) {
            graphics2D.setColor(aTEAnalysisItem.color);
            graphics2D.fill(this.composeIndicatorRectangle(aTEAnalysisItem.line, 0));
        }
    }

    protected class ColumnMouseMotionAdapter
    extends MouseMotionAdapter {
        protected ColumnMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ATEAnalysisManager aTEAnalysisManager = ATEAnalysisColumn.this.getAnalysisManager();
            if (aTEAnalysisManager == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (ATEAnalysisColumn.this.analysisBox.r.contains(mouseEvent.getPoint())) {
                stringBuffer.append(aTEAnalysisManager.getAnalysisDescription());
            } else {
                stringBuffer.append(this.getItemDescriptionsAtPoint(mouseEvent.getPoint()));
            }
            if (stringBuffer.length() > 0) {
                ATEAnalysisColumn.this.setCursor(Cursor.getPredefinedCursor(12));
                ATEAnalysisColumn.this.overlay.setLocation(mouseEvent.getPoint());
                ATEAnalysisColumn.this.overlay.setText(stringBuffer.toString());
                ATEAnalysisColumn.this.overlay.display();
            } else {
                ATEAnalysisColumn.this.setCursor(Cursor.getDefaultCursor());
                ATEAnalysisColumn.this.overlay.hide();
            }
        }

        protected String getItemDescriptionsAtPoint(Point point) {
            StringBuffer stringBuffer = new StringBuffer();
            ATEAnalysisManager aTEAnalysisManager = ATEAnalysisColumn.this.getAnalysisManager();
            if (aTEAnalysisManager != null) {
                int[] nArray = aTEAnalysisManager.getAvailableTypes();
                for (int i = 0; i < nArray.length; ++i) {
                    List<ATEAnalysisItem> list = aTEAnalysisManager.getItemsForType(i);
                    for (int j = 0; j < list.size(); ++j) {
                        ATEAnalysisItem aTEAnalysisItem = list.get(j);
                        if (!ATEAnalysisColumn.this.composeIndicatorRectangle(aTEAnalysisItem.line, 2).contains(point)) continue;
                        stringBuffer.append(aTEAnalysisItem.description);
                        stringBuffer.append("\n");
                    }
                }
            }
            return stringBuffer.toString();
        }
    }

    protected class ColumnMouseAdapter
    extends MouseAdapter {
        protected ColumnMouseAdapter() {
        }

        public int getIndexOfFirstErrors(Point point) {
            int[] nArray = ATEAnalysisColumn.this.getAnalysisManager().getAvailableTypes();
            for (int i = 0; i < nArray.length; ++i) {
                List<ATEAnalysisItem> list = ATEAnalysisColumn.this.getAnalysisManager().getItemsForType(i);
                for (int j = 0; j < list.size(); ++j) {
                    ATEAnalysisItem aTEAnalysisItem = list.get(j);
                    if (!ATEAnalysisColumn.this.composeIndicatorRectangle(aTEAnalysisItem.line, 2).contains(point)) continue;
                    return aTEAnalysisItem.index;
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.getIndexOfFirstErrors(mouseEvent.getPoint());
            if (n > -1) {
                ATEAnalysisColumn.this.overlay.hide();
                ATEAnalysisColumn.this.textEditor.setCaretPosition(n);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ATEAnalysisColumn.this.overlay.hide();
        }
    }

    protected class ColumnAnalysisBox {
        protected final Rectangle r = new Rectangle(2, 2, 14, 14);

        public void paint(Graphics graphics) {
            BorderFactory.createEtchedBorder().paintBorder(ATEAnalysisColumn.this, graphics, this.r.x, this.r.y, this.r.width, this.r.height);
            graphics.setColor(ATEAnalysisColumn.this.getAnalysisManager().getAnalysisColor());
            graphics.fillRect(this.r.x + 2, this.r.y + 2, this.r.width - 5, this.r.height - 5);
        }
    }
}

