/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.ATEPanel;

public abstract class ATEUnderlyingManager {
    protected ATEPanel textEditor;
    protected UnderlyingShape underlyingShape;
    protected boolean underlying = true;
    public static final int SHAPE_SAW_TOOTH = 1;
    public static final int SHAPE_LINE = 2;
    public static final int SHAPE_RECT = 3;

    public ATEUnderlyingManager(ATEPanel aTEPanel) {
        this.textEditor = aTEPanel;
        this.underlyingShape = new UnderlyingShape();
    }

    public void close() {
        this.textEditor = null;
    }

    public void setUnderlying(boolean bl) {
        this.underlying = bl;
    }

    public void reset() {
        this.underlyingShape.reset();
    }

    public void paint(Graphics graphics) {
        if (!this.underlying) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.underlyingShape.isReady()) {
            this.underlyingShape.draw(graphics2D);
            return;
        }
        this.underlyingShape.begin();
        this.render(graphics);
        this.underlyingShape.end();
        this.underlyingShape.draw(graphics2D);
    }

    public abstract void render(Graphics var1);

    public void drawUnderlineAtIndexes(Graphics graphics, Color color, int n, int n2, int n3) {
        try {
            Rectangle rectangle = this.textEditor.textPane.modelToView(n);
            Rectangle rectangle2 = this.textEditor.textPane.modelToView(n2);
            graphics.setColor(color);
            switch (n3) {
                case 1: {
                    int n4 = rectangle2.x - rectangle.x;
                    int n5 = 5;
                    for (int i = 0; i < n4 / n5; ++i) {
                        int n6 = rectangle.x + i * n5;
                        int n7 = rectangle.y + rectangle.height - 1;
                        graphics.drawLine(n6, n7, n6 + n5 / 2, n7 - n5 / 2);
                        graphics.drawLine(n6 + n5 / 2, n7 - n5 / 2, n6 + n5, n7);
                        this.underlyingShape.addLine(color, n6, n7, n6 + n5 / 2, n7 - n5 / 2);
                        this.underlyingShape.addLine(color, n6 + n5 / 2, n7 - n5 / 2, n6 + n5, n7);
                    }
                    break;
                }
                case 2: {
                    graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle2.x, rectangle2.y + rectangle2.height);
                    this.underlyingShape.addLine(color, rectangle.x, rectangle.y + rectangle.height, rectangle2.x, rectangle2.y + rectangle2.height);
                    break;
                }
                case 3: {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle2.x + rectangle2.width - rectangle.x, rectangle.height);
                    this.underlyingShape.addRect(color, rectangle.x, rectangle.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static class UnderlyingShape {
        public Map<Color, GeneralPath> shapes = new HashMap<Color, GeneralPath>();
        public boolean ready = false;

        public void addLine(Color color, int n, int n2, int n3, int n4) {
            GeneralPath generalPath = this.shapes.get(color);
            if (generalPath == null) {
                generalPath = new GeneralPath();
                this.shapes.put(color, generalPath);
            }
            generalPath.moveTo(n, n2);
            generalPath.lineTo(n3, n4);
        }

        public void addRect(Color color, int n, int n2, int n3, int n4) {
            GeneralPath generalPath = this.shapes.get(color);
            if (generalPath == null) {
                generalPath = new GeneralPath();
                this.shapes.put(color, generalPath);
            }
            generalPath.moveTo(n, n2);
            generalPath.lineTo(n3, n2);
            generalPath.lineTo(n3, n4);
            generalPath.lineTo(n, n4);
            generalPath.lineTo(n, n2);
        }

        public void draw(Graphics2D graphics2D) {
            for (Color color : this.shapes.keySet()) {
                graphics2D.setColor(color);
                graphics2D.draw(this.shapes.get(color));
            }
        }

        public void begin() {
            this.reset();
        }

        public void end() {
            this.ready = true;
        }

        public boolean isReady() {
            return this.ready;
        }

        public void reset() {
            this.shapes.clear();
            this.ready = false;
        }
    }
}

