/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.swing.ATEEditorKit;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.swing.ATERenderingView;
import org.antlr.xjlib.appkit.undo.XJUndo;

public class ATETextPane
extends JTextPane {
    public static final String ATTRIBUTE_CHARACTER_FOLDING_PROXY = "char_folding_proxy";
    public static final String ATTRIBUTE_PARAGRAPH_FOLDING_PROXY = "para_folding_proxy";
    protected ATEPanel textEditor;
    protected ATEKeyBindings keyBindings;
    private boolean writable = true;
    protected boolean wrap = false;
    protected boolean highlightCursorLine = false;
    private int destinationCursorPosition = -1;

    public ATETextPane(ATEPanel aTEPanel, StyledEditorKit styledEditorKit) {
        super(new DefaultStyledDocument());
        this.setCaret(new ATECaret());
        this.setEditorKit(styledEditorKit == null ? new ATEEditorKit(aTEPanel) : styledEditorKit);
        this.textEditor = aTEPanel;
    }

    public void close() {
        this.setCaret(new DefaultCaret());
        this.textEditor = null;
    }

    public ATEKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public void setKeyBindings(ATEKeyBindings aTEKeyBindings) {
        this.keyBindings = aTEKeyBindings;
    }

    public void setWritable(boolean bl) {
        this.writable = bl;
        if (this.keyBindings != null) {
            this.keyBindings.setEnableWritableActions(bl);
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWordWrap(boolean bl) {
        this.wrap = bl;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public void setHighlightCursorLine(boolean bl) {
        this.highlightCursorLine = bl;
    }

    public boolean highlightCursorLine() {
        return this.highlightCursorLine;
    }

    public void setFont(Font font) {
        super.setFont(font);
        ATERenderingView.DEFAULT_FONT = font;
    }

    public void setTabSize(int n) {
        this.getDocument().putProperty("tabSize", n);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container container = this.getParent();
            return container == null || this.getUI().getPreferredSize((JComponent)this).width < container.getSize().width;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (!this.wrap) {
            Dimension dimension = this.getPreferredSize();
            super.setBounds(n, n2, Math.max(dimension.width, n3), Math.max(dimension.height, n4));
        } else {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintDestinationCursor(graphics);
        this.textEditor.textPaneDidPaint(graphics);
    }

    private void paintDestinationCursor(Graphics graphics) {
        if (this.destinationCursorPosition < 0) {
            return;
        }
        try {
            Rectangle rectangle = this.modelToView(this.destinationCursorPosition);
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void printPaint(Graphics graphics) {
        boolean bl = this.highlightCursorLine();
        this.setHighlightCursorLine(false);
        boolean bl2 = this.getCaret().isVisible();
        this.getCaret().setVisible(false);
        this.paint(graphics);
        this.getCaret().setVisible(bl2);
        this.setHighlightCursorLine(bl);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.writable) {
            if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 401) {
                int n;
                int n2 = this.getSelectionStart();
                if (n2 != (n = this.getSelectionEnd())) {
                    try {
                        this.indentText(n2, n, keyEvent.isShiftDown() ? -1 : 1);
                        keyEvent.consume();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    super.processKeyEvent(keyEvent);
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (keyEvent.isActionKey()) {
            super.processKeyEvent(keyEvent);
        } else if ((keyEvent.getModifiers() & 4) > 0) {
            super.processKeyEvent(keyEvent);
        } else if ((keyEvent.getModifiers() & 2) > 0) {
            super.processKeyEvent(keyEvent);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected void indentText(int n, int n2, int n3) throws BadLocationException {
        String string = this.getText();
        int n4 = this.findBeginningLineBoundary(n);
        int n5 = this.findEndLineBoundary(n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = n;
        int n7 = n2;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = n4; i < n5; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                bl2 = false;
                if (c != ' ' && c != '\t') {
                    bl2 = false;
                }
                if (c == '\t' && n3 == -1) {
                    if (bl3 && i <= n) {
                        --n6;
                    }
                    --n7;
                    bl3 = false;
                    bl = true;
                    continue;
                }
                if (n3 > 0) {
                    if (bl3 && i <= n) {
                        ++n6;
                    }
                    ++n7;
                    bl3 = false;
                    stringBuffer.append('\t');
                    bl = true;
                }
            } else if (c == '\n') {
                bl2 = true;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (!bl) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.replace(n4, n5, stringBuffer.toString());
        this.textEditor.disableUndo();
        XJUndo xJUndo = this.textEditor.getTextPaneUndo();
        xJUndo.addEditEvent(new UndoableRefactoringEdit(string, stringBuffer2.toString()));
        this.setText(stringBuffer2.toString());
        this.textEditor.enableUndo();
        this.getCaret().setDot(n6);
        this.getCaret().moveDot(n7);
    }

    public int findBeginningLineBoundary(int n) {
        int n2;
        String string = this.getText();
        for (n2 = n - 1; n2 >= 0 && string.charAt(n2) != '\n'; --n2) {
        }
        return n2 + 1;
    }

    public int findEndLineBoundary(int n) {
        int n2;
        String string = this.getText();
        for (n2 = n; n2 < string.length() && string.charAt(n2) != '\n'; ++n2) {
        }
        return n2 + 1;
    }

    public int findPrevWordBoundary(int n) {
        int n2;
        String string = this.getText();
        for (n2 = n - 1; n2 >= 0 && this.isWordChar(string.charAt(n2)); --n2) {
        }
        return n2 + 1;
    }

    public int findNextWordBoundary(int n) {
        int n2;
        String string = this.getText();
        for (n2 = n; n2 < string.length() && this.isWordChar(string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    public boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    protected class ATECaret
    extends DefaultCaret {
        public boolean selectingWord = false;
        public boolean selectingLine = false;
        public boolean draggingWord = false;
        public boolean draggingLine = false;
        public boolean startedDragging = false;
        public int mouseDraggingOffset;
        public int selectionMovingLineBegin;
        public int selectionMovingLineEnd;
        public int selectionAnchorLineBegin;
        public int selectionAnchorLineEnd;
        public int selectionStart;
        public int selectionEnd;
        public int dragDropCursorPosition = 0;

        public ATECaret() {
            this.setBlinkRate(500);
        }

        public void paint(Graphics graphics) {
            if (!this.isVisible()) {
                return;
            }
            try {
                Rectangle rectangle = ATETextPane.this.modelToView(this.getDot());
                graphics.setColor(ATETextPane.this.getCaretColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected synchronized void damage(Rectangle rectangle) {
            if (rectangle == null) {
                return;
            }
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = 2;
            this.height = rectangle.height;
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                super.mouseClicked(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!ATETextPane.this.isWritable() || mouseEvent.getButton() != 1) {
                super.mousePressed(mouseEvent);
                return;
            }
            this.draggingWord = false;
            this.draggingLine = false;
            this.selectingWord = false;
            this.selectingLine = false;
            this.startedDragging = false;
            if (mouseEvent.getClickCount() % 2 == 0) {
                this.selectWord();
                this.selectingWord = true;
                this.selectionStart = ATETextPane.this.getSelectionStart();
                this.selectionEnd = ATETextPane.this.getSelectionEnd();
                ATETextPane.this.setDragEnabled(false);
                mouseEvent.consume();
                return;
            }
            if (mouseEvent.getClickCount() % 3 == 0) {
                this.selectLine();
                this.selectingLine = true;
                this.selectionStart = ATETextPane.this.getSelectionStart();
                this.selectionEnd = ATETextPane.this.getSelectionEnd();
                this.selectionMovingLineBegin = this.selectionStart;
                this.selectionAnchorLineBegin = this.selectionStart;
                this.selectionMovingLineEnd = this.selectionEnd;
                this.selectionAnchorLineEnd = this.selectionEnd;
                ATETextPane.this.setDragEnabled(false);
                mouseEvent.consume();
                return;
            }
            this.selectionStart = ATETextPane.this.getSelectionStart();
            this.selectionEnd = ATETextPane.this.getSelectionEnd();
            int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
            if (this.selectionStart != this.selectionEnd && mouseEvent.getClickCount() == 1 && n >= this.selectionStart && n <= this.selectionEnd) {
                String string = ATETextPane.this.getText();
                if ((this.selectionStart == 0 || string.charAt(this.selectionStart - 1) == '\n') && string.charAt(this.selectionEnd - 1) == '\n') {
                    this.draggingLine = true;
                } else {
                    this.draggingWord = true;
                }
                this.mouseDraggingOffset = n - this.selectionStart;
            }
            if (!this.draggingWord && !this.draggingLine) {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ATETextPane.this.isWritable() || mouseEvent.getButton() != 1) {
                super.mouseReleased(mouseEvent);
                return;
            }
            if (this.draggingWord || this.draggingLine) {
                this.endDestinationCursor();
                super.mousePressed(mouseEvent);
            }
            if (this.startedDragging) {
                super.mousePressed(mouseEvent);
            }
            if (this.draggingWord) {
                this.moveSelectionWord(mouseEvent);
            } else if (this.draggingLine) {
                this.moveSelectionLine(mouseEvent);
            }
            super.mouseReleased(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!ATETextPane.this.isWritable() || mouseEvent.getButton() != 1) {
                super.mouseDragged(mouseEvent);
                return;
            }
            if (this.draggingWord || this.draggingLine) {
                this.dragDropCursorPosition = ATETextPane.this.viewToModel(mouseEvent.getPoint());
                if (!this.startedDragging) {
                    this.startedDragging = true;
                    this.beginDestinationCursor();
                }
            }
            if (this.selectingWord) {
                this.extendSelectionWord(mouseEvent);
                ATETextPane.this.repaint();
            } else if (this.selectingLine) {
                this.extendSelectionLine(mouseEvent);
            } else if (this.draggingWord) {
                this.setDestinationCursorPosition(ATETextPane.this.viewToModel(mouseEvent.getPoint()));
            } else if (this.draggingLine) {
                int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
                int n2 = ATETextPane.this.findBeginningLineBoundary(n);
                this.setDestinationCursorPosition(n2);
            } else {
                super.mouseDragged(mouseEvent);
            }
            ATETextPane.this.repaint();
        }

        private void setDestinationCursorPosition(int n) {
            ATETextPane.this.destinationCursorPosition = n;
            if (ATETextPane.this.destinationCursorPosition != -1) {
                try {
                    ATETextPane.this.scrollRectToVisible(ATETextPane.this.modelToView(n));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ATETextPane.this.repaint();
        }

        private void beginDestinationCursor() {
            ATETextPane.this.setDragEnabled(false);
            this.setVisible(false);
        }

        private void endDestinationCursor() {
            ATETextPane.this.setDragEnabled(true);
            this.setVisible(true);
            this.setDestinationCursorPosition(-1);
        }

        private void moveSelectionLine(MouseEvent mouseEvent) {
            int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
            StyledDocument styledDocument = ATETextPane.this.getStyledDocument();
            ATETextPane.this.textEditor.getTextPaneUndo().beginUndoGroup("moveSelectionLine");
            try {
                if (n > this.selectionEnd) {
                    int n2 = ATETextPane.this.findBeginningLineBoundary(n);
                    int n3 = n2 - this.selectionEnd;
                    String string = styledDocument.getText(this.selectionEnd, n3);
                    styledDocument.remove(this.selectionEnd, n3);
                    styledDocument.insertString(this.selectionStart, string, null);
                    this.selectionEnd += n3;
                    this.selectionStart += n3;
                } else if (n < this.selectionStart) {
                    int n4 = Math.max(0, ATETextPane.this.findBeginningLineBoundary(n));
                    int n5 = this.selectionStart - n4;
                    String string = styledDocument.getText(n4, n5);
                    styledDocument.insertString(this.selectionEnd, string, null);
                    styledDocument.remove(n4, n5);
                    this.selectionEnd -= n5;
                    this.selectionStart -= n5;
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
            ATETextPane.this.textEditor.getTextPaneUndo().endUndoGroup();
        }

        private void moveSelectionWord(MouseEvent mouseEvent) {
            int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
            StyledDocument styledDocument = ATETextPane.this.getStyledDocument();
            ATETextPane.this.textEditor.getTextPaneUndo().beginUndoGroup("moveSelectionWord");
            try {
                if (n > this.selectionEnd) {
                    int n2 = n - this.selectionEnd;
                    String string = styledDocument.getText(this.selectionEnd, n2);
                    styledDocument.remove(this.selectionEnd, n2);
                    styledDocument.insertString(this.selectionStart, string, null);
                    this.selectionEnd += n2;
                    this.selectionStart += n2;
                } else if (n < this.selectionStart) {
                    n = Math.max(0, n);
                    int n3 = this.selectionStart - n;
                    String string = styledDocument.getText(n, n3);
                    styledDocument.insertString(this.selectionEnd, string, null);
                    styledDocument.remove(n, n3);
                    this.selectionEnd -= n3;
                    this.selectionStart -= n3;
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
            ATETextPane.this.textEditor.getTextPaneUndo().endUndoGroup();
        }

        public void extendSelectionWord(MouseEvent mouseEvent) {
            int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
            if (n > this.selectionEnd) {
                int n2 = ATETextPane.this.findNextWordBoundary(n);
                if (n2 > this.selectionEnd) {
                    ATETextPane.this.select(this.selectionStart, n2);
                }
            } else if (n < this.selectionStart) {
                int n3 = ATETextPane.this.findPrevWordBoundary(n);
                if (n3 < this.selectionStart) {
                    ATETextPane.this.select(Math.max(0, n3), this.selectionEnd);
                }
            } else {
                ATETextPane.this.select(this.selectionStart, this.selectionEnd);
            }
        }

        public void extendSelectionLine(MouseEvent mouseEvent) {
            int n = ATETextPane.this.viewToModel(mouseEvent.getPoint());
            if (n > this.selectionMovingLineEnd) {
                int n2 = ATETextPane.this.findEndLineBoundary(n);
                if (n2 > this.selectionMovingLineEnd) {
                    this.selectionMovingLineEnd = n2;
                    this.selectionMovingLineBegin = ATETextPane.this.findBeginningLineBoundary(n);
                    this.selectionStart = Math.min(this.selectionMovingLineBegin, this.selectionAnchorLineBegin);
                    this.selectionEnd = Math.max(this.selectionMovingLineEnd, this.selectionAnchorLineEnd);
                    ATETextPane.this.select(this.selectionStart, this.selectionEnd);
                }
            } else if (n < this.selectionMovingLineBegin) {
                int n3 = Math.max(0, ATETextPane.this.findBeginningLineBoundary(n));
                if (n3 < this.selectionMovingLineBegin) {
                    this.selectionMovingLineBegin = n3;
                    this.selectionMovingLineEnd = ATETextPane.this.findEndLineBoundary(n);
                    this.selectionEnd = Math.max(this.selectionMovingLineEnd, this.selectionAnchorLineEnd);
                    this.selectionStart = Math.min(this.selectionMovingLineBegin, this.selectionAnchorLineBegin);
                    ATETextPane.this.select(this.selectionStart, this.selectionEnd);
                }
            } else {
                ATETextPane.this.select(this.selectionStart, this.selectionEnd);
            }
        }

        public void selectWord() {
            int n = ATETextPane.this.getCaretPosition();
            ATETextPane.this.setCaretPosition(ATETextPane.this.findPrevWordBoundary(n));
            ATETextPane.this.moveCaretPosition(ATETextPane.this.findNextWordBoundary(n));
        }

        public void selectLine() {
            int n = ATETextPane.this.getCaretPosition();
            ATETextPane.this.setCaretPosition(ATETextPane.this.findBeginningLineBoundary(n));
            ATETextPane.this.moveCaretPosition(ATETextPane.this.findEndLineBoundary(n));
        }
    }

    protected class UndoableRefactoringEdit
    extends AbstractUndoableEdit {
        public String oldContent;
        public String newContent;

        public UndoableRefactoringEdit(String string, String string2) {
            this.oldContent = string;
            this.newContent = string2;
        }

        public void redo() {
            super.redo();
            this.refactorReplaceEditorText(this.newContent);
        }

        public void undo() {
            super.undo();
            this.refactorReplaceEditorText(this.oldContent);
        }

        private void refactorReplaceEditorText(String string) {
            int n = ATETextPane.this.getCaretPosition();
            ATETextPane.this.textEditor.disableUndo();
            ATETextPane.this.setText(string);
            ATETextPane.this.textEditor.enableUndo();
            ATETextPane.this.setCaretPosition(Math.min(n, string.length()));
        }
    }
}

