/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import org.antlr.works.ate.ATEGutter;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.ATEUnderlyingManager;
import org.antlr.works.ate.analysis.ATEAnalysisColumn;
import org.antlr.works.ate.analysis.ATEAnalysisManager;
import org.antlr.works.ate.breakpoint.ATEBreakpointManager;
import org.antlr.works.ate.folding.ATEFoldingManager;
import org.antlr.works.ate.swing.ATEAutoIndentation;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngine;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJSmoothScrolling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATEPanel
extends JPanel
implements XJSmoothScrolling.ScrollingDelegate,
ATESyntaxEngineDelegate {
    protected XJFrameInterface parentFrame;
    protected XJSmoothScrolling smoothScrolling;
    protected ATEPanelDelegate delegate;
    protected ATETextPane textPane;
    protected ATEKeyBindings keyBindings;
    protected ATEGutter gutter;
    protected ATEAnalysisColumn analysisColumn;
    protected ATEBreakpointManager breakpointManager;
    protected ATEFoldingManager foldingManager;
    protected ATEUnderlyingManager underlyingManager;
    protected ATEAnalysisManager analysisManager;
    protected ATESyntaxEngine engine;
    protected ATEAutoIndentation autoIndent;
    protected TextPaneListener textPaneListener;
    protected boolean syntaxColoring = false;
    protected int caretPosition;
    protected CaretListener cl;
    protected MouseListener ml;
    protected MouseMotionListener mml;
    protected static final String unixEndOfLine = "\n";
    protected static int ANALYSIS_COLUMN_WIDTH = 18;

    public ATEPanel(XJFrameInterface xJFrameInterface) {
        this(xJFrameInterface, null);
    }

    public ATEPanel(XJFrameInterface xJFrameInterface, StyledEditorKit styledEditorKit) {
        super(new BorderLayout());
        this.setParentFrame(xJFrameInterface);
        this.autoIndent = new ATEAutoIndentation(this);
        this.createTextPane(styledEditorKit);
    }

    public XJFrameInterface getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(XJFrameInterface xJFrameInterface) {
        this.parentFrame = xJFrameInterface;
    }

    public void setParserEngine(ATESyntaxEngine aTESyntaxEngine) {
        this.engine = aTESyntaxEngine;
        this.engine.setDelegate(this);
        this.engine.refreshColoring();
    }

    public ATESyntaxEngine getParserEngine() {
        return this.engine;
    }

    public void setDelegate(ATEPanelDelegate aTEPanelDelegate) {
        this.delegate = aTEPanelDelegate;
    }

    public void setBreakpointManager(ATEBreakpointManager aTEBreakpointManager) {
        this.breakpointManager = aTEBreakpointManager;
    }

    public void setFoldingManager(ATEFoldingManager aTEFoldingManager) {
        this.foldingManager = aTEFoldingManager;
    }

    public void setUnderlyingManager(ATEUnderlyingManager aTEUnderlyingManager) {
        this.underlyingManager = aTEUnderlyingManager;
    }

    public void setAnalysisManager(ATEAnalysisManager aTEAnalysisManager) {
        this.analysisManager = aTEAnalysisManager;
    }

    public ATEAnalysisManager getAnalysisManager() {
        return this.analysisManager;
    }

    public void setEditable(boolean bl) {
        this.textPane.setEditable(bl);
        this.textPane.setWritable(bl);
    }

    public void setAutoIndent(boolean bl) {
        this.autoIndent.setEnabled(bl);
    }

    public boolean autoIndent() {
        return this.autoIndent.enabled();
    }

    public void setCaretPosition(int n) {
        this.setCaretPosition(n, true, false);
    }

    public void setCaretPosition(int n, boolean bl, boolean bl2) {
        if (bl) {
            this.scrollCenterToPosition(n, bl2);
        }
        if (!bl2) {
            this.textPane.setCaretPosition(n);
        }
    }

    public int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    public void setHighlightCursorLine(boolean bl) {
        this.textPane.setHighlightCursorLine(bl);
    }

    public void setUnderlying(boolean bl) {
        this.underlyingManager.setUnderlying(bl);
    }

    public boolean isUnderlying() {
        return this.underlyingManager.underlying;
    }

    public void setFoldingEnabled(boolean bl) {
        this.gutter.setFoldingEnabled(bl);
    }

    public void setLineNumberEnabled(boolean bl) {
        this.gutter.setLineNumberEnabled(bl);
    }

    public void setEnableRecordChange(boolean bl) {
        if (bl) {
            this.textPaneListener.enable();
        } else {
            this.textPaneListener.disable();
        }
    }

    public void scrollCenterToPosition(int n, boolean bl) {
        try {
            Rectangle rectangle = this.textPane.modelToView(n);
            if (rectangle != null) {
                Rectangle rectangle2 = this.getVisibleRect();
                rectangle.y -= rectangle2.height / 2;
                rectangle.height = rectangle2.height;
                if (bl) {
                    this.caretPosition = n;
                    this.smoothScrolling.scrollTo(rectangle);
                } else {
                    this.textPane.scrollRectToVisible(rectangle);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void smoothScrollingDidComplete() {
        this.textPane.setCaretPosition(this.caretPosition);
    }

    public void setAnalysisColumnVisible(boolean bl) {
        this.analysisColumn.setVisible(bl);
        if (bl) {
            this.analysisColumn.setPreferredSize(new Dimension(ANALYSIS_COLUMN_WIDTH, 0));
        } else {
            this.analysisColumn.setPreferredSize(new Dimension(0, 0));
        }
    }

    public boolean isAnalysisColumnVisible() {
        return this.analysisColumn.isVisible();
    }

    public void toggleAnalysis() {
        this.setAnalysisColumnVisible(!this.isAnalysisColumnVisible());
    }

    public void setSyntaxColoring(boolean bl) {
        this.syntaxColoring = bl;
        this.textPane.repaint();
    }

    public boolean isSyntaxColoring() {
        return this.syntaxColoring;
    }

    public ATEKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public void toggleSyntaxColoring() {
        this.setSyntaxColoring(!this.isSyntaxColoring());
    }

    public void setEditorKit(StyledEditorKit styledEditorKit) {
        this.textPane.setEditorKit(styledEditorKit);
        this.textPaneListener = new TextPaneListener();
        this.textPane.getDocument().addDocumentListener(this.textPaneListener);
        this.textPane.getDocument().putProperty("__EndOfLine__", unixEndOfLine);
    }

    public void damage() {
        if (this.underlyingManager != null) {
            this.underlyingManager.reset();
        }
        if (this.gutter != null) {
            this.gutter.updateSize();
            this.gutter.revalidate();
            this.gutter.markDirty();
        }
    }

    public void refresh() {
        this.damage();
        if (this.engine != null) {
            this.engine.refreshColoring();
        }
        this.repaint();
    }

    public void changeOccurred() {
        this.gutter.markDirty();
        this.parse();
    }

    public int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    public String getSelectedText() {
        return this.textPane.getSelectedText();
    }

    public List<ATEToken> getTokens() {
        return this.engine == null ? null : this.engine.getTokens();
    }

    public List<ATELine> getLines() {
        return this.engine == null ? null : this.engine.getLines();
    }

    public int getCurrentLinePosition() {
        return this.getLinePositionAtIndex(this.getCaretPosition());
    }

    public int getLinePositionAtIndex(int n) {
        return this.getLineIndexAtTextPosition(n) + 1;
    }

    public int getCurrentColumnPosition() {
        return this.getColumnPositionAtIndex(this.getCaretPosition());
    }

    public int getColumnPositionAtIndex(int n) {
        int n2 = this.getLineIndexAtTextPosition(n);
        Point point = this.getLineTextPositionsAtLineIndex(n2);
        if (point == null) {
            return 1;
        }
        return this.getCaretPosition() - point.x + 1;
    }

    public int getLineIndexAtTextPosition(int n) {
        List<ATELine> list = this.getLines();
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            ATELine aTELine = list.get(i);
            if (aTELine.position <= n) continue;
            return i - 1;
        }
        return list.size() - 1;
    }

    public Point getLineTextPositionsAtTextPosition(int n) {
        return this.getLineTextPositionsAtLineIndex(this.getLineIndexAtTextPosition(n));
    }

    public Point getLineTextPositionsAtLineIndex(int n) {
        List<ATELine> list = this.getLines();
        if (n == -1 || list == null) {
            return null;
        }
        ATELine aTELine = list.get(n);
        int n2 = aTELine.position;
        if (n + 1 >= list.size()) {
            return new Point(n2, this.getTextPane().getDocument().getLength() - 1);
        }
        ATELine aTELine2 = list.get(n + 1);
        int n3 = aTELine2.position;
        return new Point(n2, n3 - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadText(String string) {
        this.setEnableRecordChange(false);
        try {
            this.ateEngineWillParse();
            this.textPane.setText(ATEPanel.normalizeText(string));
            if (this.engine != null) {
                this.engine.processSyntax();
            }
            this.textPane.setCaretPosition(0);
            this.textPane.moveCaretPosition(0);
            this.textPane.getCaret().setSelectionVisible(true);
            this.ateEngineDidParse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setEnableRecordChange(true);
        }
    }

    public void setText(String string) {
        Document document = this.textPane.getDocument();
        this.getTextPaneUndo().beginUndoGroup("setText");
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.getTextPaneUndo().endUndoGroup();
    }

    public void insertText(int n, String string) {
        try {
            this.textPane.getDocument().insertString(n, ATEPanel.normalizeText(string), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void replaceSelectedText(String string) {
        this.replaceText(this.getSelectionStart(), this.getSelectionEnd(), string);
    }

    public void replaceText(int n, int n2, String string) {
        this.getTextPaneUndo().beginUndoGroup("replaceText");
        try {
            this.textPane.getDocument().remove(n, n2 - n);
            this.textPane.getDocument().insertString(n, ATEPanel.normalizeText(string), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.getTextPaneUndo().endUndoGroup();
    }

    public static String normalizeText(String string) {
        return string.replaceAll(System.getProperty("line.separator"), unixEndOfLine);
    }

    public void selectTextRange(int n, int n2) {
        this.textPane.setCaretPosition(n);
        this.textPane.moveCaretPosition(n2);
        this.textPane.getCaret().setSelectionVisible(true);
        this.scrollCenterToPosition(n, false);
    }

    public void deselectTextRange() {
        this.textPane.setCaretPosition(this.textPane.getCaretPosition());
    }

    public void print() throws PrinterException {
        new ATEPrintUtility().print();
    }

    public void textPaneDidPaint(Graphics graphics) {
        if (this.underlyingManager != null) {
            this.underlyingManager.paint(graphics);
        }
    }

    public void textPaneInvokePopUp(Component component, int n, int n2) {
        if (this.delegate != null) {
            this.delegate.ateInvokePopUp(component, n, n2);
        }
    }

    protected void createTextPane(StyledEditorKit styledEditorKit) {
        this.textPane = new ATETextPane(this, styledEditorKit);
        this.textPane.setFocusable(true);
        this.textPane.setBackground(Color.white);
        this.textPane.setBorder(null);
        this.textPane.setWordWrap(false);
        this.textPaneListener = new TextPaneListener();
        this.textPane.getDocument().addDocumentListener(this.textPaneListener);
        this.textPane.getDocument().putProperty("__EndOfLine__", unixEndOfLine);
        this.cl = new TextPaneCaretListener();
        this.textPane.addCaretListener(this.cl);
        this.ml = new TextPaneMouseAdapter();
        this.textPane.addMouseListener(this.ml);
        this.mml = new TextPaneMouseMotionAdapter();
        this.textPane.addMouseMotionListener(this.mml);
        this.smoothScrolling = new XJSmoothScrolling(this.textPane, this);
        this.gutter = new ATEGutter(this);
        this.keyBindings = new ATEKeyBindings(this.getTextPane());
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setWheelScrollingEnabled(true);
        jScrollPane.setRowHeaderView(this.gutter);
        this.analysisColumn = new ATEAnalysisColumn(this);
        this.analysisColumn.setMinimumSize(new Dimension(ANALYSIS_COLUMN_WIDTH, 0));
        this.analysisColumn.setMaximumSize(new Dimension(ANALYSIS_COLUMN_WIDTH, Integer.MAX_VALUE));
        this.analysisColumn.setPreferredSize(new Dimension(ANALYSIS_COLUMN_WIDTH, this.analysisColumn.getPreferredSize().height));
        Box box = Box.createHorizontalBox();
        box.add(jScrollPane);
        box.add(this.analysisColumn);
        this.add((Component)box, "Center");
    }

    public ATETextPane getTextPane() {
        return this.textPane;
    }

    public ATEGutter getGutter() {
        return this.gutter;
    }

    public void parse() {
        if (this.engine != null) {
            this.engine.process();
        }
    }

    @Override
    public String getText() {
        return this.getTextPane().getText();
    }

    @Override
    public void ateEngineWillParse() {
        if (this.delegate != null) {
            this.delegate.ateParserWillParse();
        }
    }

    @Override
    public void ateEngineDidParse() {
        if (this.delegate != null) {
            this.delegate.ateParserDidParse();
        }
    }

    public void ateAutoIndent(int n, int n2) {
        if (this.delegate != null) {
            this.delegate.ateAutoIndent(n, n2);
        }
    }

    public void ateColoringWillColorize() {
        this.setEnableRecordChange(false);
        this.disableUndo();
    }

    public void ateColoringDidColorize() {
        this.setEnableRecordChange(true);
        this.enableUndo();
    }

    public XJUndo getTextPaneUndo() {
        return this.parentFrame.getUndo(this.getTextPane());
    }

    public void disableUndo() {
        XJUndo xJUndo = this.getTextPaneUndo();
        if (xJUndo != null) {
            xJUndo.disableUndo();
        }
    }

    public void enableUndo() {
        XJUndo xJUndo = this.getTextPaneUndo();
        if (xJUndo != null) {
            xJUndo.enableUndo();
        }
    }

    public int getTextIndexAtPosition(int n, int n2) {
        return this.getTextPane().viewToModel(new Point(n, n2));
    }

    public void close() {
        this.textPane.removeCaretListener(this.cl);
        this.textPane.removeMouseListener(this.ml);
        this.textPane.removeMouseMotionListener(this.mml);
        this.keyBindings.close();
        this.textPane.close();
        this.analysisColumn.close();
        this.setParentFrame(null);
        this.setDelegate(null);
    }

    public class ATEPrintUtility
    implements Printable {
        public void print() throws PrinterException {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this);
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            double d = pageFormat.getImageableWidth();
            double d2 = pageFormat.getImageableHeight();
            double d3 = ATEPanel.this.textPane.getUI().getRootView(ATEPanel.this.textPane).getView(0).getPreferredSpan(0);
            double d4 = d / d3;
            double d5 = (double)ATEPanel.this.textPane.getFontMetrics(ATEPanel.this.textPane.getFont()).getHeight() * d4;
            double d6 = d2 / d5;
            double d7 = ATEPanel.this.textPane.getDocument().getDefaultRootElement().getElementCount();
            int n2 = (int)Math.ceil(d7 / d6);
            if (n >= n2) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.disableDoubleBuffering(ATEPanel.this.textPane);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d8 = (double)(n * (int)d6) * d5;
            graphics2D.translate(0.0, -d8);
            graphics2D.setClip(null);
            graphics2D.clipRect(0, (int)d8, (int)Math.floor(d), (int)Math.floor((double)((int)d6) * d5));
            graphics2D.scale(d4, d4);
            ATEPanel.this.textPane.printPaint(graphics2D);
            this.enableDoubleBuffering(ATEPanel.this.textPane);
            return 0;
        }

        public void disableDoubleBuffering(Component component) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            repaintManager.setDoubleBufferingEnabled(false);
        }

        public void enableDoubleBuffering(Component component) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            repaintManager.setDoubleBufferingEnabled(true);
        }
    }

    protected class TextPaneMouseMotionAdapter
    extends MouseMotionAdapter {
        protected TextPaneMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMouseMoved(mouseEvent.getPoint());
            }
        }
    }

    protected class TextPaneMouseAdapter
    extends MouseAdapter {
        protected TextPaneMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ATEPanel.this.textPane.highlightCursorLine) {
                ATEPanel.this.textPane.repaint();
            }
            this.checkForPopupTrigger(mouseEvent);
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMousePressed(mouseEvent.getPoint());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        public void checkForPopupTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = ATEPanel.this.textPane.viewToModel(mouseEvent.getPoint());
                if (ATEPanel.this.textPane.getSelectionStart() != ATEPanel.this.textPane.getSelectionEnd()) {
                    if (n < ATEPanel.this.textPane.getSelectionStart() || n > ATEPanel.this.textPane.getSelectionEnd()) {
                        ATEPanel.this.setCaretPosition(n, false, false);
                    }
                } else if (n != ATEPanel.this.getCaretPosition()) {
                    ATEPanel.this.setCaretPosition(n, false, false);
                }
                ATEPanel.this.textPaneInvokePopUp(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMouseExited();
            }
        }
    }

    protected class TextPaneListener
    implements DocumentListener {
        protected int enable = 0;

        protected TextPaneListener() {
        }

        public synchronized void enable() {
            --this.enable;
        }

        public synchronized void disable() {
            ++this.enable;
        }

        public synchronized boolean isEnable() {
            return this.enable == 0;
        }

        public void changeUpdate(int n, int n2, boolean bl) {
            if (this.isEnable()) {
                if (ATEPanel.this.delegate != null) {
                    ATEPanel.this.delegate.ateChangeUpdate(n, n2, bl);
                }
                if (bl) {
                    ATEPanel.this.autoIndent.indent(n, n2);
                }
                ATEPanel.this.changeOccurred();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changeUpdate(documentEvent.getOffset(), documentEvent.getLength(), true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changeUpdate(documentEvent.getOffset(), -documentEvent.getLength(), false);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    protected class TextPaneCaretListener
    implements CaretListener {
        protected TextPaneCaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateCaretUpdate(caretEvent.getDot());
            }
            if (ATEPanel.this.textPane.highlightCursorLine) {
                ATEPanel.this.textPane.repaint();
            }
        }
    }
}

