/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.breakpoint.ATEBreakpointEntity;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.utils.IconManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATEGutter
extends JComponent {
    private static final int BREAKPOINT_WIDTH = 9;
    private static final int BREAKPOINT_HEIGHT = 9;
    private static final int FOLDING_ICON_WIDTH = 9;
    private static final int FOLDING_ICON_HEIGHT = 9;
    private static final int OFFSET_FROM_TEXT = 2;
    private static final Color BACKGROUND_COLOR = new Color(240, 240, 240);
    private static final Stroke FOLDING_DASHED_STROKE = new BasicStroke(0.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);
    private static final Font LINE_NUMBER_FONT = new Font("Courier", 0, 12);
    private ATEPanel textEditor;
    private List<BreakpointInfo> breakpoints = new ArrayList<BreakpointInfo>();
    private List<FoldingInfo> foldingInfos = new ArrayList<FoldingInfo>();
    private boolean foldingEnabled = false;
    private FontMetrics lineNumberMetrics;
    private int offsetForLineNumber;
    private boolean lineNumberEnabled;
    private transient Image collapseDown;
    private transient Image collapseUp;
    private transient Image collapse;
    private transient Image expand;
    private transient Image delimiter;
    private transient Image delimiterUp;
    private transient Image delimiterDown;

    public ATEGutter(ATEPanel aTEPanel) {
        this.textEditor = aTEPanel;
        this.collapseDown = IconManager.shared().getIconCollapseDown().getImage();
        this.collapseUp = IconManager.shared().getIconCollapseUp().getImage();
        this.collapse = IconManager.shared().getIconCollapse().getImage();
        this.expand = IconManager.shared().getIconExpand().getImage();
        this.delimiter = IconManager.shared().getIconDelimiter().getImage();
        this.delimiterUp = IconManager.shared().getIconDelimiterUp().getImage();
        this.delimiterDown = IconManager.shared().getIconDelimiterDown().getImage();
        this.addMouseListener(new MyMouseAdapter());
        this.addMouseMotionListener(new MyMouseMotionAdapter());
    }

    public void setFoldingEnabled(boolean bl) {
    }

    public void setLineNumberEnabled(boolean bl) {
        this.lineNumberEnabled = bl;
    }

    public void markDirty() {
        this.repaint();
    }

    public Set<Integer> getBreakpoints() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (BreakpointInfo breakpointInfo : this.breakpoints) {
            if (!breakpointInfo.entity.breakpointEntityIsBreakpoint()) continue;
            hashSet.add(breakpointInfo.entity.breakpointEntityLine());
        }
        return hashSet;
    }

    protected void toggleBreakpoint(BreakpointInfo breakpointInfo) {
        if (breakpointInfo == null) {
            return;
        }
        breakpointInfo.entity.breakpointEntitySetBreakpoint(!breakpointInfo.entity.breakpointEntityIsBreakpoint());
        this.repaint();
    }

    protected void toggleFolding(FoldingInfo foldingInfo) {
        if (foldingInfo == null || !foldingInfo.entity.foldingEntityCanBeCollapsed()) {
            return;
        }
        this.textEditor.foldingManager.toggleFolding(foldingInfo.entity);
        this.markDirty();
    }

    protected int getLineYPixelPosition(int n) {
        try {
            Rectangle rectangle = this.textEditor.textPane.modelToView(n);
            return rectangle.y + rectangle.height / 2;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void updateInfo(Rectangle rectangle) {
        int n;
        int n2;
        List<Object> list;
        int n3 = this.textEditor.textPane.viewToModel(new Point(rectangle.x, rectangle.y));
        int n4 = this.textEditor.textPane.viewToModel(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        this.breakpoints.clear();
        if (this.textEditor.breakpointManager != null) {
            list = this.textEditor.breakpointManager.getBreakpointEntities();
            for (Object object : list) {
                n2 = object.breakpointEntityIndex();
                if (n2 < n3 || n2 > n4) continue;
                n = this.getLineYPixelPosition(object.breakpointEntityIndex());
                Rectangle rectangle2 = new Rectangle(this.offsetForLineNumber, n - 4, 9, 9);
                this.breakpoints.add(new BreakpointInfo((ATEBreakpointEntity)object, rectangle2));
            }
        }
        this.foldingInfos.clear();
        if (this.textEditor.foldingManager != null) {
            list = this.textEditor.foldingManager.getFoldingEntities();
            for (Object object : list) {
                n2 = object.foldingEntityGetStartIndex();
                n = object.foldingEntityGetEndIndex();
                if (n2 > n4 || n < n3) continue;
                int n5 = this.getLineYPixelPosition(object.foldingEntityGetStartIndex());
                int n6 = this.getLineYPixelPosition(object.foldingEntityGetEndIndex());
                Point point = new Point(this.getWidth() - this.getOffsetFromText(), n5);
                Point point2 = new Point(this.getWidth() - this.getOffsetFromText(), n6);
                this.foldingInfos.add(new FoldingInfo((ATEFoldingEntity)object, point, point2));
            }
        }
    }

    public void updateSize() {
        List<ATELine> list;
        if (this.lineNumberMetrics == null) {
            this.lineNumberMetrics = this.textEditor.textPane.getFontMetrics(LINE_NUMBER_FONT);
        }
        this.offsetForLineNumber = 0;
        if (this.lineNumberEnabled && (list = this.textEditor.getLines()) != null) {
            this.offsetForLineNumber = this.lineNumberMetrics.stringWidth(String.valueOf(list.size()));
        }
    }

    public BreakpointInfo getBreakpointInfoAtPoint(Point point) {
        for (BreakpointInfo breakpointInfo : this.breakpoints) {
            if (!breakpointInfo.contains(point)) continue;
            return breakpointInfo;
        }
        return null;
    }

    public FoldingInfo getFoldingInfoAtPoint(Point point) {
        for (FoldingInfo foldingInfo : this.foldingInfos) {
            if (!foldingInfo.contains(point)) continue;
            return foldingInfo;
        }
        return null;
    }

    public int getOffsetFromText() {
        return 6;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        this.updateInfo(rectangle);
        this.updateSize();
        this.paintGutter(graphics, rectangle);
        this.paintFolding((Graphics2D)graphics, rectangle);
        this.paintBreakpoints((Graphics2D)graphics, rectangle);
        if (this.lineNumberEnabled) {
            this.paintLineNumbers((Graphics2D)graphics, rectangle);
        }
    }

    private void paintGutter(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.textEditor.textPane.getBackground());
        graphics.fillRect(rectangle.x + rectangle.width - this.getOffsetFromText(), rectangle.y, this.getOffsetFromText(), rectangle.height);
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - this.getOffsetFromText(), rectangle.height);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(rectangle.x + rectangle.width - this.getOffsetFromText(), rectangle.y, rectangle.x + rectangle.width - this.getOffsetFromText(), rectangle.y + rectangle.height);
    }

    private void paintBreakpoints(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.red);
        for (BreakpointInfo breakpointInfo : this.breakpoints) {
            Rectangle rectangle2;
            if (!breakpointInfo.entity.breakpointEntityIsBreakpoint() || !rectangle.intersects(rectangle2 = breakpointInfo.r)) continue;
            graphics2D.fillArc(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 360);
        }
    }

    private void paintLineNumbers(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setColor(Color.black);
        graphics2D.setFont(LINE_NUMBER_FONT);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n = this.textEditor.getLines().size();
        int n2 = this.textEditor.textPane.getFontMetrics(this.textEditor.textPane.getFont()).getHeight();
        int n3 = Math.max(0, Math.round(rectangle.y / n2) - 1);
        int n4 = n3 * n2;
        while (n3 <= n && (double)(n4 - n2) <= rectangle.getY() + rectangle.getHeight()) {
            String string = String.valueOf(n3++);
            graphics2D.drawString(string, this.offsetForLineNumber - this.lineNumberMetrics.stringWidth(string), n4 - 4);
            n4 += n2;
        }
    }

    private void paintFolding(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (FoldingInfo foldingInfo : this.foldingInfos) {
            if (!rectangle.intersects(foldingInfo.top_r) && !rectangle.intersects(foldingInfo.bottom_r)) continue;
            Point point = foldingInfo.top;
            Point point2 = foldingInfo.bottom;
            if (this.foldingEnabled && foldingInfo.entity.foldingEntityCanBeCollapsed()) {
                if (foldingInfo.entity.foldingEntityIsExpanded()) {
                    this.drawFoldingLine(graphics2D, point, point2);
                    if (point.equals(point2)) {
                        ATEGutter.drawCenteredImageAtPoint(graphics2D, this.collapse, point);
                        continue;
                    }
                    ATEGutter.drawCenteredImageAtPoint(graphics2D, this.collapseUp, point);
                    ATEGutter.drawCenteredImageAtPoint(graphics2D, this.collapseDown, point2);
                    continue;
                }
                ATEGutter.drawCenteredImageAtPoint(graphics2D, this.expand, point);
                continue;
            }
            this.drawFoldingLine(graphics2D, point, point2);
            if (point.equals(point2)) {
                ATEGutter.drawCenteredImageAtPoint(graphics2D, this.delimiter, point);
                continue;
            }
            ATEGutter.drawCenteredImageAtPoint(graphics2D, this.delimiterUp, point);
            ATEGutter.drawCenteredImageAtPoint(graphics2D, this.delimiterDown, point2);
        }
    }

    private void drawFoldingLine(Graphics2D graphics2D, Point point, Point point2) {
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(FOLDING_DASHED_STROKE);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        graphics2D.setStroke(stroke);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.textEditor.textPane.getSize();
        dimension.width = 25 + this.offsetForLineNumber;
        return dimension;
    }

    public static void drawCenteredImageAtPoint(Graphics graphics, Image image, Point point) {
        graphics.drawImage(image, point.x - image.getWidth(null) / 2, point.y - image.getHeight(null) / 2, null);
    }

    protected class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        protected MyMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!ATEGutter.this.foldingEnabled) {
                return;
            }
            FoldingInfo foldingInfo = ATEGutter.this.getFoldingInfoAtPoint(mouseEvent.getPoint());
            if (foldingInfo != null && foldingInfo.entity.foldingEntityCanBeCollapsed()) {
                ATEGutter.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ATEGutter.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected class MyMouseAdapter
    extends MouseAdapter {
        protected MyMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ATEGutter.this.toggleBreakpoint(ATEGutter.this.getBreakpointInfoAtPoint(mouseEvent.getPoint()));
            ATEGutter.this.toggleFolding(ATEGutter.this.getFoldingInfoAtPoint(mouseEvent.getPoint()));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ATEGutter.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected static class FoldingInfo {
        public ATEFoldingEntity entity;
        public Point top;
        public Point bottom;
        public Rectangle top_r;
        public Rectangle bottom_r;

        public FoldingInfo(ATEFoldingEntity aTEFoldingEntity, Point point, Point point2) {
            this.entity = aTEFoldingEntity;
            this.top = point;
            this.bottom = point2;
            this.top_r = new Rectangle(point.x - 4, point.y - 4, 9, 9);
            this.bottom_r = new Rectangle(point2.x - 4, point2.y - 4, 9, 9);
        }

        public boolean contains(Point point) {
            if (this.entity.foldingEntityIsExpanded()) {
                return this.top_r.contains(point) || this.bottom_r.contains(point);
            }
            return this.top_r.contains(point);
        }
    }

    protected static class BreakpointInfo {
        public ATEBreakpointEntity entity;
        public Rectangle r;

        public BreakpointInfo(ATEBreakpointEntity aTEBreakpointEntity, Rectangle rectangle) {
            this.entity = aTEBreakpointEntity;
            this.r = rectangle;
        }

        public boolean contains(Point point) {
            return this.r.contains(point);
        }
    }
}

