/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works;

import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.antlr.Tool;
import org.antlr.tool.ErrorManager;
import org.antlr.works.SplashScreen;
import org.antlr.works.components.grammar.CContainerGrammar;
import org.antlr.works.components.grammar.CDocumentGrammar;
import org.antlr.works.components.project.CContainerProject;
import org.antlr.works.components.project.CDocumentProject;
import org.antlr.works.dialog.DialogAbout;
import org.antlr.works.dialog.DialogPersonalInfo;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.prefs.AWPrefsDialog;
import org.antlr.works.stats.Statistics;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.Console;
import org.antlr.works.utils.ErrorListener;
import org.antlr.works.utils.HelpManager;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Localizable;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJApplicationDelegate;
import org.antlr.xjlib.appkit.document.XJDataPlainText;
import org.antlr.xjlib.appkit.document.XJDataXML;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.swing.XJLookAndFeel;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDE
extends XJApplicationDelegate
implements XJMenuItemDelegate {
    public static final String PROPERTIES_PATH = "org/antlr/works/properties/";
    public static SplashScreen sc;
    protected static ResourceBundle resourceMenusBundle;
    public static boolean _isPlugin;
    public static final String PLUGIN_PROPERTIES_PATH = "org/antlr/works/plugin/properties/strings";

    public static void main(String[] stringArray) {
        XJSystem.setSystemProperties();
        XJApplication.setPropertiesPath(PROPERTIES_PATH);
        XJAlert.setDefaultAlertIcon(IconManager.shared().getIconApplication64x64());
        if (stringArray.length >= 1 && stringArray[0].equals("-stats")) {
            XJApplication.run(new Statistics(), stringArray, "Statistics");
        } else {
            sc = new SplashScreen();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        sc.setVisible(true);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            XJApplication.run(new IDE(), stringArray);
        }
    }

    public void closeSplashScreen() {
        if (sc != null) {
            sc.setVisible(false);
            sc.dispose();
            sc = null;
        }
    }

    @Override
    public void appDidLaunch(String[] stringArray, List<String> list) {
        AWPrefs.setLookAndFeel(XJLookAndFeel.applyLookAndFeel(AWPrefs.getLookAndFeel()));
        XJApplication.addDocumentType(CDocumentGrammar.class, CContainerGrammar.class, XJDataPlainText.class, "g", Localizable.getLocalizedString("GrammarDocumentType"));
        if (AWPrefs.getEnableProjectDocument()) {
            XJApplication.addDocumentType(CDocumentProject.class, CContainerProject.class, XJDataXML.class, "awp", Localizable.getLocalizedString("ProjectDocumentType"));
        }
        XJApplication.addScheduledTimer(new HelpManager(), 1L, true);
        AWPrefsDialog.applyCommonPrefs();
        this.registerUser();
        this.checkLibraries();
        this.checkEnvironment();
        if (stringArray.length >= 2 && stringArray[0].equals("-f")) {
            XJApplication.shared().openDocument(stringArray[1]);
        } else if (list != null && list.size() > 0) {
            XJApplication.shared().openDocuments(list);
        } else {
            switch (AWPrefs.getStartupAction()) {
                case 0: {
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 1: {
                    if (XJApplication.shared().getDocuments().size() != 0 || XJApplication.shared().openLastUsedDocument()) break;
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 2: {
                    if (XJApplication.shared().getDocuments().size() != 0 || XJApplication.shared().openDocument(AWPrefs.getLastSavedDocument())) break;
                    this.closeSplashScreen();
                    XJApplication.shared().newDocument();
                    break;
                }
                case 3: {
                    this.closeSplashScreen();
                    if (this.restoreAllOpenedDocuments()) break;
                    XJApplication.shared().newDocument();
                }
            }
        }
        this.closeSplashScreen();
    }

    public void registerUser() {
        if (!AWPrefs.isUserRegistered()) {
            this.closeSplashScreen();
            AWPrefs.setServerID("");
            new DialogPersonalInfo(null).runModal();
            AWPrefs.setUserRegistered(true);
        }
    }

    public void checkLibraries() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Class.forName("org.antlr.Tool");
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringBuffer.append("\n- ANTLR 3.x");
        }
        try {
            Class.forName("org.antlr.stringtemplate.StringTemplate");
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringBuffer.append("\n- StringTemplate");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            stringBuffer.append("\n- StringTemplate");
        }
        if (stringBuffer.length() > 0) {
            this.closeSplashScreen();
            stringBuffer.insert(0, "ANTLRWorks cannot find the following libraries:");
            stringBuffer.append("\nThey are required in order to use all the features of ANTLRWorks.\nDownload them from www.antlr.org and put them in the same directory as ANTLRWorks.");
            XJAlert.display(null, "Missing Libraries", stringBuffer.toString());
            System.exit(0);
        }
    }

    public void checkEnvironment() {
        ErrorListener errorListener = ErrorListener.getThreadInstance();
        CheckStream checkStream = new CheckStream(System.err);
        PrintStream printStream = new PrintStream(checkStream);
        PrintStream printStream2 = System.err;
        System.setErr(printStream);
        try {
            ErrorManager.setTool(new Tool());
            ErrorManager.setErrorListener(errorListener);
        }
        catch (Throwable throwable) {
            XJAlert.display(null, "Fatal Error", "ANTLRWorks will quit now because ANTLR reported an error:\n" + checkStream.getMessage());
            System.exit(0);
        }
        if (errorListener.hasErrors()) {
            XJAlert.display(null, "Error", "ANTLRWorks will continue to launch but ANTLR reported an error:\n" + checkStream.getMessage());
        }
        errorListener.clear();
        System.setErr(printStream2);
        printStream.close();
    }

    public static String getApplicationPath() {
        int n;
        String string;
        Class<?> clazz = XJApplication.getAppDelegate().getClass();
        URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (uRL == null) {
            String string2 = clazz.getName().replace('.', '/').concat(".class");
            uRL = clazz.getClassLoader().getResource(string2);
            if (uRL == null) {
                System.err.println("IDE: unable to get the location of the XJApplicationDelegate");
                return null;
            }
            string = uRL.getPath();
            string = string.substring(0, string.length() - string2.length());
        } else {
            string = uRL.getPath();
        }
        if (string.startsWith("jar:")) {
            string = string.substring("jar:".length());
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if ((n = string.lastIndexOf("!")) != -1) {
            string = string.substring(0, n);
        }
        if (XJSystem.isWindows()) {
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != '/') continue;
                stringBuffer.replace(i, i + 1, "\\");
            }
            string = stringBuffer.toString();
        }
        string = string.replaceAll("%20", " ");
        return string;
    }

    public static void debugVerbose(Console console, Class clazz, String string) {
        if (AWPrefs.getDebugVerbose()) {
            String string2 = clazz.getName() + ": " + string;
            if (console != null) {
                console.println(string2);
            }
            System.out.println(string2);
        }
    }

    @Override
    public void customizeHelpMenu(XJMenu xJMenu) {
        xJMenu.insertItemAfter(new XJMenuItem("Check for Updates", 102, this), 10020);
        xJMenu.insertItemAfter(new XJMenuItem("Send Feedback", 101, this), 10020);
        xJMenu.insertItemAfter(new XJMenuItem("Submit Statistics...", 100, this), 10020);
        xJMenu.insertSeparatorAfter(10020);
    }

    @Override
    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        switch (xJMenuItem.getTag()) {
            case 100: {
                IDE.submitStats(this.getDefaultParent());
                break;
            }
            case 101: {
                IDE.submitFeedback(this.getDefaultParent());
                break;
            }
            case 102: {
                IDE.checkUpdates(this.getDefaultParent());
            }
        }
    }

    public Container getDefaultParent() {
        return XJApplication.shared().getActiveWindow().getJavaContainer();
    }

    public static void checkUpdates(Container container) {
        StatisticsAW.shared().recordEvent(132);
        HelpManager.checkUpdates(container, false);
    }

    public static void submitFeedback(Container container) {
        HelpManager.sendFeedback(container);
    }

    public static void submitStats(Container container) {
        HelpManager.submitStats(container);
    }

    public static void showHelp(Container container) {
        StatisticsAW.shared().recordEvent(131);
        String string = Localizable.getLocalizedString("DocumentationURL");
        try {
            BrowserLauncher.openURL(string);
        }
        catch (IOException iOException) {
            XJAlert.display(container, "Cannot access the online help", "An error occurred when accessing the online help:\n" + iOException.toString() + "\n\nBrowse the online help at " + string + ".");
        }
    }

    @Override
    public void appShowHelp() {
        IDE.showHelp(this.getDefaultParent());
    }

    @Override
    public void appWillTerminate() {
        this.saveAllOpenedDocuments();
        StatisticsAW.shared().close();
    }

    @Override
    public Class appPreferencesPanelClass() {
        return AWPrefsDialog.class;
    }

    @Override
    public XJPanel appInstanciateAboutPanel() {
        return new DialogAbout();
    }

    @Override
    public boolean appHasPreferencesMenuItem() {
        return true;
    }

    @Override
    public boolean appShouldQuitAfterLastWindowClosed() {
        return false;
    }

    @Override
    public boolean useDesktopMode() {
        return AWPrefs.getUseDesktopMode();
    }

    @Override
    public Class appPreferencesClass() {
        return IDE.class;
    }

    @Override
    public String appName() {
        return Localizable.getLocalizedString("AppName") + " " + this.appVersionShort();
    }

    @Override
    public String appVersionShort() {
        return Localizable.getLocalizedString("AppVersionShort");
    }

    @Override
    public String appVersionLong() {
        return Localizable.getLocalizedString("AppVersionLong");
    }

    private boolean restoreAllOpenedDocuments() {
        List<String> list = AWPrefs.getAllOpenedDocuments();
        if (list == null) {
            return false;
        }
        boolean bl = false;
        for (String string : list) {
            if (!XJApplication.shared().openDocument(string)) continue;
            bl = true;
        }
        return bl;
    }

    private void saveAllOpenedDocuments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (XJDocument xJDocument : XJApplication.shared().getDocuments()) {
            XJDocument xJDocument2 = xJDocument;
            if (!(xJDocument2 instanceof CDocumentGrammar)) continue;
            arrayList.add(xJDocument2.getDocumentPath());
        }
        AWPrefs.setAllOpenedDocuments(arrayList);
    }

    public static ResourceBundle getMenusResourceBundle() {
        return resourceMenusBundle;
    }

    public static boolean isPlugin() {
        return _isPlugin;
    }

    public static String getPluginVersionShort() {
        return XJLocalizable.getStringFromPath(PLUGIN_PROPERTIES_PATH, "VERSION_SHORT");
    }

    static {
        resourceMenusBundle = ResourceBundle.getBundle("org.antlr.works.properties.menus");
        _isPlugin = false;
    }

    private class CheckStream
    extends ByteArrayOutputStream {
        private PrintStream errorStream;
        private StringBuffer sb = new StringBuffer();

        public CheckStream(PrintStream printStream) {
            this.errorStream = printStream;
        }

        public synchronized void write(int n) {
            super.write(n);
            this.record();
        }

        public synchronized void write(byte[] byArray, int n, int n2) {
            super.write(byArray, n, n2);
            this.record();
        }

        public synchronized void writeTo(OutputStream outputStream) throws IOException {
            super.writeTo(outputStream);
            this.record();
        }

        public void write(byte[] byArray) throws IOException {
            super.write(byArray);
            this.record();
        }

        private void record() {
            this.errorStream.println(this.toString());
            this.sb.append(this.toString());
            this.reset();
        }

        public String getMessage() {
            return this.sb.toString();
        }
    }
}

