/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works;

import java.io.File;
import java.io.IOException;
import org.antlr.Tool;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.components.grammar.CEditorGrammar;
import org.antlr.works.grammar.EngineGrammar;
import org.antlr.works.grammar.EngineGrammarDelegate;
import org.antlr.works.syntax.GrammarSyntaxEngine;
import org.antlr.works.visualization.SDGenerator;
import org.antlr.works.visualization.serializable.SXMLEncoder;
import org.antlr.xjlib.foundation.XJUtils;

public class Console {
    private String file;
    private String outputDirectory;
    private String outputFile;
    private boolean verbose;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Console.printUsage();
            return;
        }
        System.setProperty("java.awt.headless", "true");
        Console console = new Console();
        console.process(stringArray);
    }

    private static void printUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Usage: java -cp antlrworks.jar org.antlr.works.Console [args]\n");
        stringBuffer.append(" -f grammarFile : ").append("specify the input grammar file (*.g)\n");
        stringBuffer.append(" -sd format : ").append("specify the format of the syntax diagram output file. For EPS, use 'eps'. For bitmap, use either 'png' or any available extensions\n");
        stringBuffer.append(" -serialize outputFile : ").append("serialize all the syntax diagram of the specified files");
        stringBuffer.append(" -o outputDir : ").append("specify the output directory\n");
        stringBuffer.append(" -verbose : ").append("prints the operations\n");
        System.out.println(stringBuffer.toString());
    }

    private void process(String[] stringArray) throws Exception {
        this.readArguments(stringArray);
        String string = Console.getArgumentValue(stringArray, "-sd");
        if (string != null) {
            if (this.verbose) {
                System.out.println("Generating syntax diagram in " + string);
            }
            this.generateSyntaxDiagrams(string);
        }
        if (Console.hasArgument(stringArray, "-serialize")) {
            if (this.verbose) {
                System.out.println("Serializing syntax diagram ");
            }
            this.serializeSyntaxDiagrams();
        }
    }

    private void readArguments(String[] stringArray) {
        this.file = Console.getArgumentValue(stringArray, "-f");
        if (this.file == null) {
            System.err.println("File not specified (-f)");
            return;
        }
        this.outputDirectory = Console.getArgumentValue(stringArray, "-o");
        if (this.outputDirectory == null && Console.hasArgument(stringArray, "-sd")) {
            System.err.println("Output directory not specified (-o)");
            return;
        }
        this.outputFile = Console.getArgumentValue(stringArray, "-serialize");
        if (this.outputFile == null && Console.hasArgument(stringArray, "-serialize")) {
            System.err.println("Output file not specified (-serialize)");
            return;
        }
        String string = Console.getArgumentValue(stringArray, "-verbose");
        if (string != null) {
            this.verbose = true;
        }
    }

    private void generateSyntaxDiagrams(String string) throws Exception {
        GrammarSyntaxEngine grammarSyntaxEngine = new GrammarSyntaxEngine();
        grammarSyntaxEngine.setDelegate(new SyntaxDelegate());
        grammarSyntaxEngine.processSyntax();
        CEditorGrammar cEditorGrammar = new CEditorGrammar(null);
        cEditorGrammar.parserEngine = new GrammarSyntaxEngine();
        EngineGrammar engineGrammar = new EngineGrammar(cEditorGrammar);
        engineGrammar.setDelegate(new ConsoleEngineGrammarDelegate());
        SDGenerator sDGenerator = new SDGenerator(engineGrammar);
        if (this.verbose) {
            System.out.println("Begin");
        }
        new File(this.outputDirectory).mkdirs();
        for (String string2 : grammarSyntaxEngine.getRuleNames()) {
            if (this.verbose) {
                System.out.println("Generate rule " + string2);
            }
            String string3 = XJUtils.concatPath(this.outputDirectory, string2 + "." + string);
            if (string.equals("eps")) {
                sDGenerator.renderRuleToEPSFile(string2, string3);
                continue;
            }
            sDGenerator.renderRuleToBitmapFile(string2, string, string3);
        }
        if (this.verbose) {
            System.out.println("Done");
        }
    }

    private void serializeSyntaxDiagrams() throws Exception {
        GrammarSyntaxEngine grammarSyntaxEngine = new GrammarSyntaxEngine();
        grammarSyntaxEngine.setDelegate(new SyntaxDelegate());
        grammarSyntaxEngine.processSyntax();
        CEditorGrammar cEditorGrammar = new CEditorGrammar(null);
        cEditorGrammar.parserEngine = new GrammarSyntaxEngine();
        EngineGrammar engineGrammar = new EngineGrammar(cEditorGrammar);
        engineGrammar.setDelegate(new ConsoleEngineGrammarDelegate());
        SDGenerator sDGenerator = new SDGenerator(engineGrammar);
        if (this.verbose) {
            System.out.println("Begin");
        }
        new File(XJUtils.getPathByDeletingLastComponent(this.outputFile)).mkdirs();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : grammarSyntaxEngine.getRuleNames()) {
            if (this.verbose) {
                System.out.println("Generate rule " + string);
            }
            SXMLEncoder sXMLEncoder = new SXMLEncoder();
            sDGenerator.serializeRule(string, sXMLEncoder);
            stringBuffer.append("\n\n------").append(string).append("------\n\n");
            stringBuffer.append(((Object)sXMLEncoder).toString());
        }
        XJUtils.writeStringToFile(stringBuffer.toString(), this.outputFile);
        if (this.verbose) {
            System.out.println("Done");
        }
    }

    private static String getArgumentValue(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            if (i + 1 < stringArray.length) {
                return stringArray[i + 1];
            }
            return string2;
        }
        return null;
    }

    private static boolean hasArgument(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getGrammarText() {
        try {
            return XJUtils.getStringFromFile(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public class SyntaxDelegate
    implements ATESyntaxEngineDelegate {
        public String getText() {
            return Console.this.getGrammarText();
        }

        public void ateEngineWillParse() {
        }

        public void ateEngineDidParse() {
        }
    }

    public class ConsoleEngineGrammarDelegate
    implements EngineGrammarDelegate {
        public String getFileName() {
            return Console.this.file;
        }

        public String getText() {
            return Console.this.getGrammarText();
        }

        public Tool getANTLRTool() {
            return new Tool();
        }
    }
}

