/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Quarter
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 3810061714380888671L;
    public static final int FIRST_QUARTER = 1;
    public static final int LAST_QUARTER = 4;
    public static final int[] FIRST_MONTH_IN_QUARTER;
    public static final int[] LAST_MONTH_IN_QUARTER;
    private short year;
    private byte quarter;
    private long firstMillisecond;
    private long lastMillisecond;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 10;
        FIRST_MONTH_IN_QUARTER = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 3;
        nArray2[2] = 6;
        nArray2[3] = 9;
        nArray2[4] = 12;
        LAST_MONTH_IN_QUARTER = nArray2;
    }

    public Quarter() {
        this(new Date());
    }

    public Quarter(int quarter, int year) {
        if (quarter < 1 || quarter > 4) {
            throw new IllegalArgumentException("Quarter outside valid range.");
        }
        this.year = (short)year;
        this.quarter = (byte)quarter;
        this.peg(Calendar.getInstance());
    }

    public Quarter(int quarter, Year year) {
        if (quarter < 1 || quarter > 4) {
            throw new IllegalArgumentException("Quarter outside valid range.");
        }
        this.year = (short)year.getYear();
        this.quarter = (byte)quarter;
        this.peg(Calendar.getInstance());
    }

    public Quarter(Date time) {
        this(time, TimeZone.getDefault());
    }

    public Quarter(Date time, TimeZone zone) {
        this(time, zone, Locale.getDefault());
    }

    public Quarter(Date time, TimeZone zone, Locale locale) {
        Calendar calendar = Calendar.getInstance(zone, locale);
        calendar.setTime(time);
        int month = calendar.get(2) + 1;
        this.quarter = (byte)SerialDate.monthCodeToQuarter(month);
        this.year = (short)calendar.get(1);
        this.peg(calendar);
    }

    public int getQuarter() {
        return this.quarter;
    }

    public Year getYear() {
        return new Year(this.year);
    }

    public int getYearValue() {
        return this.year;
    }

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    @Override
    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    @Override
    public RegularTimePeriod previous() {
        Quarter result = this.quarter > 1 ? new Quarter(this.quarter - 1, this.year) : (this.year > 1900 ? new Quarter(4, this.year - 1) : null);
        return result;
    }

    @Override
    public RegularTimePeriod next() {
        Quarter result = this.quarter < 4 ? new Quarter(this.quarter + 1, this.year) : (this.year < 9999 ? new Quarter(1, this.year + 1) : null);
        return result;
    }

    @Override
    public long getSerialIndex() {
        return (long)this.year * 4L + (long)this.quarter;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof Quarter) {
                Quarter target = (Quarter)obj;
                return this.quarter == target.getQuarter() && this.year == target.getYearValue();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.quarter;
        result = 37 * result + this.year;
        return result;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Quarter) {
            Quarter q = (Quarter)o1;
            result = this.year - q.getYearValue();
            if (result == 0) {
                result = this.quarter - q.getQuarter();
            }
        } else {
            result = o1 instanceof RegularTimePeriod ? 0 : 1;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Q" + this.quarter + "/" + this.year;
    }

    @Override
    public long getFirstMillisecond(Calendar calendar) {
        int month = FIRST_MONTH_IN_QUARTER[this.quarter];
        calendar.set(this.year, month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    @Override
    public long getLastMillisecond(Calendar calendar) {
        int month = LAST_MONTH_IN_QUARTER[this.quarter];
        int eom = SerialDate.lastDayOfMonth(month, this.year);
        calendar.set(this.year, month - 1, eom, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Quarter parseQuarter(String s) {
        int i = s.indexOf("Q");
        if (i == -1) {
            throw new TimePeriodFormatException("Missing Q.");
        }
        if (i == s.length() - 1) {
            throw new TimePeriodFormatException("Q found at end of string.");
        }
        String qstr = s.substring(i + 1, i + 2);
        int quarter = Integer.parseInt(qstr);
        String remaining = String.valueOf(s.substring(0, i)) + s.substring(i + 2, s.length());
        remaining = remaining.replace('/', ' ');
        remaining = remaining.replace(',', ' ');
        remaining = remaining.replace('-', ' ');
        Year year = Year.parseYear(remaining.trim());
        Quarter result = new Quarter(quarter, year);
        return result;
    }
}

