/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.if672.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class Comparator {
    private static final int MAX_SIZE = 50;
    private File arq1;
    private File arq2;
    private int matchCount;
    private int mismatchCount;
    private int totalLines;
    private int[] mismatchedLines;
    private int nElem;

    public Comparator(String arq1, String arq2) {
        this.arq1 = new File(arq1);
        this.arq2 = new File(arq2);
        this.matchCount = 0;
        this.mismatchCount = 0;
        this.totalLines = 0;
        this.mismatchedLines = new int[50];
        this.nElem = 0;
    }

    public File getArq1() {
        return this.arq1;
    }

    public void setArq1(String arq1) {
        this.arq1 = new File(arq1);
    }

    public void setArq2(String arq2) {
        this.arq2 = new File(arq2);
    }

    public File getArq2() {
        return this.arq2;
    }

    public int getMatchCount() {
        return this.matchCount;
    }

    public int getMismatchCount() {
        return this.mismatchCount;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public float getPercentMatched() {
        return 100.0f * (float)this.matchCount / (float)this.totalLines;
    }

    public void play() {
        this.matchCount = 0;
        this.mismatchCount = 0;
        this.totalLines = 0;
        this.nElem = 0;
        try {
            BufferedReader readerArq1 = new BufferedReader(new FileReader(this.arq1));
            BufferedReader readerArq2 = new BufferedReader(new FileReader(this.arq2));
            String lineArq2 = null;
            String lineArq1 = null;
            boolean isEnd = false;
            while (!isEnd) {
                lineArq1 = readerArq1.readLine();
                isEnd = lineArq1 == null;
                lineArq2 = readerArq2.readLine();
                boolean bl = isEnd = lineArq2 == null && isEnd;
                if (lineArq1 != null && lineArq1.equals(lineArq2)) {
                    ++this.matchCount;
                } else if (!isEnd) {
                    if (this.mismatchCount < 50) {
                        this.mismatchedLines[this.mismatchCount] = this.totalLines + 1;
                        ++this.nElem;
                    }
                    ++this.mismatchCount;
                }
                if (isEnd) continue;
                ++this.totalLines;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] getMismatchedLines() {
        return this.mismatchedLines;
    }

    public String getMismatchedLinesToString() {
        String out = new String();
        int i = 0;
        while (i < this.nElem) {
            out = String.valueOf(out) + this.mismatchedLines[i] + " ";
            ++i;
        }
        return out;
    }

    public int getNElem() {
        return this.nElem;
    }
}

