/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

class FormatElement {
    static final String DESCRIPTORS = "doxfeEgG";
    private static final String INT_DESCRIPTORS = "dox";
    private static final int INT_DESCRIPTOR = 0;
    private static final int FLOAT_DESCRIPTOR = 1;
    private final char _descriptor;
    private final int _descriptorType;
    private final double _tenToPrecision;
    private boolean _decimalPoint;
    private boolean _flushLeft;
    private boolean _leadingZeros;
    private boolean _alwaysSign;
    private int _width;
    private int _precision;

    private static final double power(double x, int n) {
        return n < 0 ? 1.0 / FormatElement.power2(x, -n) : FormatElement.power2(x, n);
    }

    private static final double power2(double x, int n) {
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return x;
            }
        }
        double p = FormatElement.power2(x, n / 2);
        return p * p * FormatElement.power2(x, n % 2);
    }

    FormatElement(String formatString) {
        int len = formatString.length() - 1;
        this._descriptor = formatString.charAt(len);
        if (DESCRIPTORS.indexOf(this._descriptor) < 0) {
            throw new IllegalArgumentException("Format element '" + formatString + "' does not ends with one of the following characters: " + DESCRIPTORS);
        }
        int n = this._descriptorType = INT_DESCRIPTORS.indexOf(this._descriptor) >= 0 ? 0 : 1;
        if (formatString.length() > 1) {
            int last;
            switch (formatString.charAt(0)) {
                case '-': {
                    this._flushLeft = true;
                    formatString = formatString.substring(1);
                    break;
                }
                case '0': {
                    this._leadingZeros = true;
                    formatString = formatString.substring(1);
                    break;
                }
                case '+': {
                    this._alwaysSign = true;
                    formatString = formatString.substring(1);
                }
            }
            len = formatString.length() - 1;
            int index = formatString.indexOf(46);
            this._decimalPoint = index >= 0;
            int n2 = last = this._decimalPoint ? index : len;
            if (last > 0) {
                this._width = Integer.parseInt(formatString.substring(0, last));
            }
            if (this._decimalPoint && ++index < len) {
                this._precision = Integer.parseInt(formatString.substring(index, len));
            }
        }
        this._tenToPrecision = FormatElement.power(10.0, this._precision);
    }

    public void form(StringBuffer buffer, long number) {
        if (this._descriptorType == 1) {
            this.form(buffer, (double)number);
        } else {
            buffer.append(this.form(number < 0L, Long.toString(Math.abs(number), this._descriptor == 'o' ? 8 : (this._descriptor == 'x' ? 16 : 10)), ""));
        }
    }

    public void form(StringBuffer buffer, double number) {
        if (this._descriptorType == 0) {
            this.form(buffer, (long)Math.floor(number + 0.5));
        } else if (this._descriptor == 'f') {
            buffer.append(this.formF(number));
        } else if (this._descriptor == 'e' || this._descriptor == 'E') {
            buffer.append(this.formE(number));
        } else if (this._descriptor == 'g' || this._descriptor == 'G') {
            String formF = this.formF(number);
            String formE = this.formE(number);
            buffer.append(formF.length() > formE.length() ? formE : formF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String form(boolean negativeValue, String intPart, String fracPart) {
        block5: {
            len = intPart.length() + fracPart.length();
            result = new StringBuffer();
            count = 0;
            if (this._alwaysSign || negativeValue) {
                result.append(negativeValue != false ? '-' : '+');
                ++count;
            }
            if (this._leadingZeros) {
                i = count + len;
                while (i < this._width) {
                    result.append('0');
                    ++count;
                    ++i;
                }
            }
            result.append(intPart).append(fracPart);
            count += len;
            if (!this._flushLeft) ** GOTO lbl29
            while (count < this._width) {
                result.append(' ');
                ++count;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                result.insert(0, ' ');
                ++count;
lbl29:
                // 2 sources

                ** while (count < this._width)
            }
        }
        return new String(result);
    }

    private String formE(double number) {
        int exponent = 0;
        String zeros = "00000000000000000000000".substring(0, this._precision + 1);
        if (number != 0.0) {
            exponent = (int)Math.floor(Math.log(Math.abs(number)) / Math.log(10.0));
            double mantisse = Math.floor(Math.abs(number * FormatElement.power(10.0, this._precision - exponent)) + 0.5);
            if (mantisse >= 10.0 * this._tenToPrecision) {
                mantisse = Math.floor(Math.abs(number * FormatElement.power(10.0, this._precision - ++exponent)) + 0.5);
            }
            zeros = Long.toString((long)mantisse);
        }
        StringBuffer fracPart = new StringBuffer();
        if (this._decimalPoint) {
            fracPart.append('.').append(zeros.substring(1));
        }
        fracPart.append(Character.isLowerCase(this._descriptor) ? (char)'e' : 'E').append(exponent < 0 ? (char)'-' : '+');
        exponent = Math.abs(exponent);
        int i = 0;
        int n = fracPart.length();
        while (i < 3) {
            fracPart.insert(n, Character.forDigit(exponent % 10, 10));
            exponent /= 10;
            ++i;
        }
        return this.form(number < 0.0, zeros.substring(0, 1), new String(fracPart));
    }

    private String formF(double number) {
        String digits;
        double multiplier = number < 0.0 ? -this._tenToPrecision : this._tenToPrecision;
        String intPart = digits = Long.toString((long)Math.floor(number * multiplier + 0.5));
        StringBuffer fracPart = new StringBuffer();
        if (this._decimalPoint) {
            int len = digits.length() - this._precision;
            fracPart.append('.').append(digits.substring(Math.max(0, len)));
            if (len > 0) {
                intPart = digits.substring(0, len);
            } else {
                intPart = "0";
                while (len < 0) {
                    fracPart.insert(1, '0');
                    ++len;
                }
            }
        }
        return this.form(number < 0.0, intPart, new String(fracPart));
    }
}

