/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.util.Vector;
import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;
import jcckit.util.FormatElement;
import jcckit.util.TicLabelFormat;

public class Format
implements TicLabelFormat {
    private final FormatElement[] _formatElements;
    private final Vector _staticParts = new Vector();

    public static Format create(ConfigParameters config, String key) {
        Format result = null;
        String format = config.get(key, null);
        if (format != null && format.length() > 0) {
            try {
                result = new Format(format);
            }
            catch (Exception e) {
                throw new FactoryException(config, key, e);
            }
        }
        return result;
    }

    public Format(String formatString) {
        Vector<String> formatElements = new Vector<String>();
        StringBuffer part = new StringBuffer();
        boolean insideFormatElement = false;
        boolean atPercentSymbol = false;
        int i = 0;
        int n = formatString.length();
        while (i < n) {
            char c = formatString.charAt(i);
            if (insideFormatElement) {
                part.append(c);
                if ("doxfeEgG".indexOf(c) >= 0) {
                    formatElements.addElement(new String(part));
                    part.setLength(0);
                    insideFormatElement = false;
                }
            } else if (atPercentSymbol) {
                atPercentSymbol = false;
                if (c != '%') {
                    this._staticParts.addElement(new String(part));
                    part.setLength(0);
                    insideFormatElement = true;
                }
                part.append(c);
                if ("doxfeEgG".indexOf(c) >= 0) {
                    formatElements.addElement(new String(part));
                    part.setLength(0);
                    insideFormatElement = false;
                }
            } else if (c == '%') {
                atPercentSymbol = true;
            } else {
                part.append(c);
            }
            ++i;
        }
        if (insideFormatElement) {
            formatElements.addElement(new String(part));
        } else {
            this._staticParts.addElement(new String(part));
        }
        this._formatElements = new FormatElement[formatElements.size()];
        i = 0;
        while (i < this._formatElements.length) {
            this._formatElements[i] = new FormatElement((String)formatElements.elementAt(i));
            ++i;
        }
    }

    public String form(long number) {
        StringBuffer result = new StringBuffer();
        result.append(this._staticParts.elementAt(0));
        if (this._formatElements.length > 0) {
            this._formatElements[0].form(result, number);
        }
        return this.appendRest(result);
    }

    public String form(double number) {
        StringBuffer result = new StringBuffer();
        result.append(this._staticParts.elementAt(0));
        if (this._formatElements.length > 0) {
            this._formatElements[0].form(result, number);
        }
        return this.appendRest(result);
    }

    private String appendRest(StringBuffer buffer) {
        int i = 1;
        int n = this._staticParts.size();
        while (i < n) {
            buffer.append(this._staticParts.elementAt(i));
            ++i;
        }
        return new String(buffer);
    }

    public String form(double[] numbers) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        int n = this._staticParts.size();
        while (i < n) {
            result.append(this._staticParts.elementAt(i));
            if (i < this._formatElements.length && i < numbers.length) {
                this._formatElements[i].form(result, numbers[i]);
            }
            ++i;
        }
        return new String(result);
    }
}

