/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.awt.Color;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.ShapeAttributes;
import jcckit.plot.AttributesHint;
import jcckit.util.ConfigParameters;

public class ShapeAttributesHint
implements AttributesHint,
Cloneable {
    public static final String INITIAL_ATTRIBUTES_KEY = "initialAttributes";
    public static final String FILL_COLOR_HSB_INCREMENT_KEY = "fillColorHSBIncrement";
    public static final String LINE_COLOR_HSB_INCREMENT_KEY = "lineColorHSBIncrement";
    public static final String LINE_THICKNESS_INCREMENT_KEY = "lineThicknessIncrement";
    private float[] _fillColorHSB;
    private float[] _lineColorHSB;
    private double _lineThickness;
    private double[] _linePattern;
    private double[] _fillColorHSBIncrement;
    private double[] _lineColorHSBIncrement;
    private double _lineThicknessIncrement;

    private static float[] extractHSB(Color color) {
        return color == null ? null : Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private static Color createColor(float[] colorHSB) {
        return colorHSB == null ? null : Color.getHSBColor(colorHSB[0], colorHSB[1], colorHSB[2]);
    }

    private static float[] incrementColor(float[] colorHSB, double[] increments) {
        float[] result = null;
        if (colorHSB != null) {
            result = (float[])colorHSB.clone();
            int i = 0;
            while (i < 3) {
                int n = i;
                result[n] = (float)((double)result[n] + increments[i]);
                ++i;
            }
        }
        return result;
    }

    public ShapeAttributesHint(ConfigParameters config) {
        ShapeAttributes attributes = new ShapeAttributes(config.getNode(INITIAL_ATTRIBUTES_KEY));
        this._fillColorHSB = ShapeAttributesHint.extractHSB(attributes.getFillColor());
        this._lineColorHSB = ShapeAttributesHint.extractHSB(attributes.getLineColor());
        this._lineThickness = attributes.getLineThickness();
        this._linePattern = attributes.getLinePattern();
        this._fillColorHSBIncrement = config.getDoubleArray(FILL_COLOR_HSB_INCREMENT_KEY, new double[3]);
        this._lineColorHSBIncrement = config.getDoubleArray(LINE_COLOR_HSB_INCREMENT_KEY, new double[3]);
        this._lineThicknessIncrement = config.getDouble(LINE_THICKNESS_INCREMENT_KEY, 0.0);
    }

    public AttributesHint getNextHint() {
        ShapeAttributesHint nextHint = null;
        try {
            nextHint = (ShapeAttributesHint)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nextHint._fillColorHSB = ShapeAttributesHint.incrementColor(this._fillColorHSB, this._fillColorHSBIncrement);
        nextHint._lineColorHSB = ShapeAttributesHint.incrementColor(this._lineColorHSB, this._lineColorHSBIncrement);
        nextHint._lineThickness = Math.max(0.0, this._lineThickness + this._lineThicknessIncrement);
        return nextHint;
    }

    public GraphicAttributes getAttributes() {
        return new ShapeAttributes(ShapeAttributesHint.createColor(this._fillColorHSB), ShapeAttributesHint.createColor(this._lineColorHSB), this._lineThickness, this._linePattern);
    }
}

