/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Vector;
import jcckit.data.DataCurve;
import jcckit.data.DataEvent;
import jcckit.data.DataListener;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.plot.CoordinateSystem;
import jcckit.plot.Curve;
import jcckit.plot.CurveFactory;
import jcckit.plot.Hint;
import jcckit.plot.Legend;
import jcckit.plot.PlotEvent;
import jcckit.plot.PlotEventType;
import jcckit.plot.PlotListener;
import jcckit.transformation.Transformation;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class Plot
implements DataListener {
    public static final String COORDINATE_SYSTEM_KEY = "coordinateSystem";
    public static final String CURVE_FACTORY_KEY = "curveFactory";
    public static final String LEGEND_VISIBLE_KEY = "legendVisible";
    public static final String LEGEND_KEY = "legend";
    public static final String INITIAL_HINT_FOR_NEXT_CURVE_KEY = "initialHintForNextCurve";
    private final Vector _plotListeners = new Vector();
    private DataPlot _dataPlot;
    private final CurveFactory _curveFactory;
    private final Vector _curves = new Vector();
    private final Vector _nextCurveHints = new Vector();
    private final Hint _initialHintForNextCurve;
    private final Legend _legend;
    private final boolean _legendVisibility;
    private GraphicalElement _coordinateSystemView;
    private ClippingShape _clippingShape;
    private Transformation _transformation;
    private GraphicalElement _annotation;
    private GraphicalComposite _legendView = new GraphicalComposite(null);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Plot(ConfigParameters config) {
        ConfigParameters configParameters = config.getNode(COORDINATE_SYSTEM_KEY);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jcckit.plot.CartesianCoordinateSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CoordinateSystem coordinateSystem = (CoordinateSystem)Factory.create(configParameters, clazz.getName());
        this.setCoordinateSystem(coordinateSystem);
        ConfigParameters configParameters2 = config.getNode(CURVE_FACTORY_KEY);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("jcckit.plot.SimpleCurveFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._curveFactory = (CurveFactory)Factory.create(configParameters2, clazz2.getName());
        this._initialHintForNextCurve = (Hint)Factory.createOrGet(config.getNode(INITIAL_HINT_FOR_NEXT_CURVE_KEY), null);
        this._legend = new Legend(config.getNode(LEGEND_KEY));
        this._legendVisibility = config.getBoolean(LEGEND_VISIBLE_KEY, true);
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this._coordinateSystemView = coordinateSystem.getView();
        this._clippingShape = coordinateSystem.getClippingShape();
        this._transformation = coordinateSystem.getTransformation();
        if (this._dataPlot != null) {
            this.generateCurves(this._dataPlot);
        }
        this.notifyListeners(new PlotEvent(this, PlotEventType.COODINATE_SYSTEM_CHANGED, null));
    }

    public void addPlotListener(PlotListener listener) {
        if (!this._plotListeners.contains(listener)) {
            this._plotListeners.addElement(listener);
        }
    }

    public void removePlotListener(PlotListener listener) {
        this._plotListeners.removeElement(listener);
    }

    protected void notifyListeners(PlotEvent event) {
        int i = 0;
        int n = this._plotListeners.size();
        while (i < n) {
            ((PlotListener)this._plotListeners.elementAt(i)).plotChanged(event);
            ++i;
        }
    }

    public void connect(DataPlot dataPlot) {
        if (this._dataPlot != null) {
            this._dataPlot.removeDataListener(this);
            this.notifyListeners(new PlotEvent(this, PlotEventType.DATA_PLOT_DISCONNECTED, this._dataPlot));
        }
        this._dataPlot = dataPlot;
        if (this._dataPlot != null) {
            this._dataPlot.addDataListener(this);
            this.generateCurves(this._dataPlot);
            this.notifyListeners(new PlotEvent(this, PlotEventType.DATA_PLOT_CONNECTED, this._dataPlot));
        }
    }

    public DataPoint transform(GraphPoint point) {
        return this._transformation.transformToData(point);
    }

    public GraphicalComposite getCompletePlot() {
        GraphicalComposite result = new GraphicalComposite(null);
        result.addElement(this._coordinateSystemView);
        GraphicalElement[] curves = this.getCurves();
        int i = 0;
        while (i < curves.length) {
            result.addElement(curves[i]);
            ++i;
        }
        if (this._annotation != null) {
            result.addElement(this._annotation);
        }
        if (this._legendVisibility) {
            result.addElement(this.getLegend());
        }
        return result;
    }

    public GraphicalElement getCoordinateSystem() {
        return this._coordinateSystemView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicalElement[] getCurves() {
        Vector vector = this._curves;
        synchronized (vector) {
            GraphicalElement[] curves = new GraphicalElement[this._curves.size()];
            int i = 0;
            while (i < curves.length) {
                curves[i] = ((Curve)this._curves.elementAt(i)).getView();
                ++i;
            }
            return curves;
        }
    }

    public GraphicalElement getAnnotation() {
        return this._annotation;
    }

    public void setAnnotation(GraphicalElement annotation) {
        this._annotation = annotation;
    }

    public boolean isLegendVisible() {
        return this._legendVisibility;
    }

    public GraphicalElement getLegend() {
        return this._legendView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged(DataEvent event) {
        Integer index = new Integer(0);
        PlotEventType type = PlotEventType.DATA_PLOT_CHANGED;
        Vector vector = this._curves;
        synchronized (vector) {
            int numberOfCurves = this._curves.size();
            if (event.getContainer() instanceof DataCurve && numberOfCurves == this._dataPlot.getNumberOfElements()) {
                DataCurve curve = (DataCurve)event.getContainer();
                index = new Integer(curve.getContainer().getIndexOf(curve));
                type = PlotEventType.DATA_CURVE_CHANGED;
                this.fillCurve(index, curve);
                if (index < numberOfCurves - 1) {
                    Vector curveHints = (Vector)this._nextCurveHints.elementAt(index);
                    int i = 0;
                    int n = curveHints.size();
                    while (i < n) {
                        if (curveHints.elementAt(i) != null) {
                            type = PlotEventType.DATA_PLOT_CHANGED;
                            int j = index + 1;
                            while (j < numberOfCurves) {
                                this.fillCurve(j, (DataCurve)this._dataPlot.getElement(j));
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                this.generateCurves(this._dataPlot);
            }
        }
        this.notifyListeners(new PlotEvent(this, type, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCurves(DataPlot dataPlot) {
        Vector vector = this._curves;
        synchronized (vector) {
            this._legendView = new GraphicalComposite(null);
            this._legendView.addElement(this._legend.getBox());
            this._curves.setSize(0);
            this._nextCurveHints.setSize(0);
            int i = 0;
            int n = dataPlot.getNumberOfElements();
            while (i < n) {
                Curve curve = this._curveFactory.create(i, n, this._clippingShape, this._legend);
                this._curves.addElement(curve);
                this._nextCurveHints.addElement(new Vector());
                DataCurve dataCurve = (DataCurve)dataPlot.getElement(i);
                this._legendView.addElement(curve.getLegendSymbol());
                this._legendView.addElement(this._legend.createCurveTitle(i, n, dataCurve.getTitle()));
                this.fillCurve(i, dataCurve);
                ++i;
            }
        }
    }

    private void fillCurve(int curveIndex, DataCurve dataCurve) {
        Vector curveHints = (Vector)this._nextCurveHints.elementAt(curveIndex);
        Curve curve = (Curve)this._curves.elementAt(curveIndex);
        curve.removeAllPoints();
        int i = 0;
        int n = dataCurve.getNumberOfElements();
        while (i < n) {
            this.setHintForNextCurve(curveHints, i, curve.addPoint(this._transformation.transformToGraph((DataPoint)dataCurve.getElement(i)), this.getHintForNextCurve(curveIndex - 1, i)));
            ++i;
        }
    }

    private Hint getHintForNextCurve(int curveIndex, int pointIndex) {
        Hint result = this._initialHintForNextCurve;
        if (curveIndex >= 0) {
            Vector curveHints = (Vector)this._nextCurveHints.elementAt(curveIndex);
            result = pointIndex < curveHints.size() ? (Hint)curveHints.elementAt(pointIndex) : this.getHintForNextCurve(curveIndex - 1, pointIndex);
        }
        return result;
    }

    private void setHintForNextCurve(Vector curveHints, int pointIndex, Hint hint) {
        while (curveHints.size() <= pointIndex) {
            curveHints.addElement(this._initialHintForNextCurve);
        }
        curveHints.setElementAt(hint, pointIndex);
    }
}

