/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.data.DataPoint;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Polygon;
import jcckit.graphic.Text;
import jcckit.plot.AxisParameters;
import jcckit.plot.CoordinateSystem;
import jcckit.transformation.CartesianTransformation;
import jcckit.transformation.Transformation;
import jcckit.util.ConfigParameters;

public class CartesianCoordinateSystem
implements CoordinateSystem {
    public static final String ORIGIN_KEY = "origin";
    public static final String X_AXIS_KEY = "xAxis";
    public static final String Y_AXIS_KEY = "yAxis";
    private final CartesianTransformation _transformation;
    private final GraphicalComposite _view;
    private final ClippingRectangle _clippingRectangle;

    public CartesianCoordinateSystem(ConfigParameters config) {
        this(new GraphPoint(config.getDoubleArray(ORIGIN_KEY, new double[]{0.15, 0.1})), AxisParameters.createXAxis(config.getNode(X_AXIS_KEY)), AxisParameters.createYAxis(config.getNode(Y_AXIS_KEY)));
    }

    public CartesianCoordinateSystem(GraphPoint origin, AxisParameters xAxisParameters, AxisParameters yAxisParameters) {
        double x = origin.getX();
        double y = origin.getY();
        this._transformation = new CartesianTransformation(xAxisParameters.logScale, yAxisParameters.logScale, new DataPoint(xAxisParameters.minimum, yAxisParameters.minimum), new GraphPoint(x, y), new DataPoint(xAxisParameters.maximum, yAxisParameters.maximum), new GraphPoint(x + xAxisParameters.axisLength, y + yAxisParameters.axisLength));
        this._clippingRectangle = new ClippingRectangle(x, y, x + xAxisParameters.axisLength, y + yAxisParameters.axisLength);
        this._view = new GraphicalComposite(null);
        this.createView(origin, xAxisParameters, yAxisParameters);
    }

    private void createView(GraphPoint origin, AxisParameters xAxisParameters, AxisParameters yAxisParameters) {
        double x0 = origin.getX();
        double x1 = x0 + xAxisParameters.axisLength;
        double y0 = origin.getY();
        double y1 = y0 + yAxisParameters.axisLength;
        GraphPoint lowerLeftCorner = new GraphPoint(x0, y0);
        GraphPoint upperLeftCorner = new GraphPoint(x0, y1);
        GraphPoint lowerRightCorner = new GraphPoint(x1, y0);
        GraphPoint upperRightCorner = new GraphPoint(x1, y1);
        LineAttributes xLineAttributes = xAxisParameters.axisAttributes;
        LineAttributes yLineAttributes = yAxisParameters.axisAttributes;
        this.createTicsAndGrid(true, y0, y1, xAxisParameters);
        this.createTicsAndGrid(false, x0, x1, yAxisParameters);
        this.addLine(lowerLeftCorner, lowerRightCorner, xLineAttributes);
        this.addLine(lowerLeftCorner, upperLeftCorner, yLineAttributes);
        this.addLine(upperLeftCorner, upperRightCorner, xLineAttributes);
        this.addLine(lowerRightCorner, upperRightCorner, yLineAttributes);
        this.createLabel(0.5 * (x0 + x1), y0, xAxisParameters);
        this.createLabel(x0, 0.5 * (y0 + y1), yAxisParameters);
    }

    private void createLabel(double x, double y, AxisParameters parameters) {
        if (parameters.axisLabel.length() > 0) {
            this._view.addElement(new Text(new GraphPoint(x + parameters.axisLabelPosition.getX(), y + parameters.axisLabelPosition.getY()), parameters.axisLabel, parameters.axisLabelAttributes));
        }
    }

    private void createTicsAndGrid(boolean isXAxis, double low, double high, AxisParameters parameters) {
        double[] tics = parameters.calculateTics();
        int offIndex = isXAxis ? 1 : 0;
        double[] point = new double[2];
        int i = 0;
        while (i < tics.length) {
            point[1 - offIndex] = tics[i];
            point[offIndex] = 1.0;
            GraphPoint gPoint1 = this._transformation.transformToGraph(new DataPoint(point[0], point[1]));
            point[0] = gPoint1.getX();
            point[1] = gPoint1.getY();
            point[offIndex] = high;
            gPoint1 = new GraphPoint(point[0], point[1]);
            int n = offIndex;
            point[n] = point[n] + parameters.ticLength;
            this.addLine(gPoint1, new GraphPoint(point[0], point[1]), parameters.ticAttributes);
            point[offIndex] = low;
            GraphPoint gPoint2 = new GraphPoint(point[0], point[1]);
            if (parameters.grid) {
                this.addLine(gPoint1, gPoint2, parameters.gridAttributes);
            }
            int n2 = offIndex;
            point[n2] = point[n2] - parameters.ticLength;
            this.addLine(gPoint2, new GraphPoint(point[0], point[1]), parameters.ticAttributes);
            if (parameters.ticLabelFormat != null) {
                int n3 = offIndex;
                point[n3] = point[n3] + parameters.ticLength;
                point[0] = point[0] + parameters.ticLabelPosition.getX();
                point[1] = point[1] + parameters.ticLabelPosition.getY();
                this._view.addElement(new Text(new GraphPoint(point[0], point[1]), parameters.ticLabelFormat.form(tics[i]), parameters.ticLabelAttributes));
            }
            ++i;
        }
    }

    private void addLine(GraphPoint point1, GraphPoint point2, GraphicAttributes attributes) {
        Polygon line = new Polygon(attributes, false);
        line.addPoint(point1);
        line.addPoint(point2);
        this._view.addElement(line);
    }

    public GraphicalElement getView() {
        return this._view;
    }

    public ClippingShape getClippingShape() {
        return this._clippingRectangle;
    }

    public Transformation getTransformation() {
        return this._transformation;
    }
}

