/*
 * Decompiled with CFR 0.152.
 */
package jcckit.data;

import jcckit.data.DataContainer;
import jcckit.data.DataElement;
import jcckit.data.DataPoint;
import jcckit.util.ConfigParameters;

public class DataCurve
extends DataContainer
implements DataElement {
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";
    public static final String TITLE_KEY = "title";
    private final String _title;
    private DataContainer _container;

    public DataCurve(String title) {
        this._title = title;
    }

    public DataCurve(ConfigParameters config) {
        this(config.get(TITLE_KEY, ""));
        double[] xPoints = config.getDoubleArray(X_KEY);
        double[] yPoints = config.getDoubleArray(Y_KEY);
        int n = Math.min(xPoints.length, yPoints.length);
        int i = 0;
        while (i < n) {
            this.addElement(new DataPoint(xPoints[i], yPoints[i]));
            ++i;
        }
    }

    public DataContainer getContainer() {
        return this._container;
    }

    public void setContainer(DataContainer container) {
        this._container = container;
    }

    public String getTitle() {
        return this._title;
    }

    protected boolean isValid(DataElement element) {
        return element instanceof DataPoint;
    }
}

