/*
 * Decompiled with CFR 0.152.
 */
package jcckit;

import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextArea;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import jcckit.GraphicsPlotCanvas;
import jcckit.data.DataPlot;
import jcckit.util.AppletBasedConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;
import jcckit.util.PropertiesBasedConfigData;

public class PlotApplet
extends Applet
implements Runnable {
    public static final String DEFAULT_WAITING_MESSAGE = "Please wait, applet data are loading...";
    public static final String WAITING_MESSAGE_KEY = "waitingMessage";
    public static final String DATA_PROPERTIES_KEY = "dataProperties";
    public static final String DATA_KEY = "data";
    public static final String RENDERER_KEY = "renderer";
    private CardLayout _layout = new CardLayout();

    public void init() {
        this.setLayout(this._layout);
        String label = this.getParameter(WAITING_MESSAGE_KEY);
        if (label == null) {
            label = DEFAULT_WAITING_MESSAGE;
        }
        this.add((Component)new Label(label, 1), "");
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        try {
            ConfigParameters config = new ConfigParameters(new AppletBasedConfigData(this));
            DataPlot dPlot = new DataPlot(this.getDataConfig(config));
            GraphicsPlotCanvas canvas = config.get("className", null) == null ? new GraphicsPlotCanvas(config) : (GraphicsPlotCanvas)Factory.create(config);
            canvas.setRenderer(config.get(RENDERER_KEY, "jcckit.renderer.GraphicsRenderer"));
            canvas.connect(dPlot);
            this.show(canvas.getGraphicsCanvas());
        }
        catch (Throwable t) {
            this.show(t);
        }
    }

    private void show(Throwable throwable) {
        TextArea error = new TextArea(throwable.toString());
        error.setForeground(Color.red);
        this.show(error);
    }

    private void show(Component component) {
        this.removeAll();
        this.add(component, "");
        this._layout.last(this);
    }

    private ConfigParameters getDataConfig(ConfigParameters config) throws Throwable {
        ConfigParameters result = config.getNode(DATA_KEY);
        String dataProperties = config.get(DATA_PROPERTIES_KEY, null);
        if (dataProperties != null) {
            Properties properties = new Properties();
            InputStream is = new URL(this.getDocumentBase(), dataProperties).openStream();
            properties.load(is);
            is.close();
            result = new ConfigParameters(new PropertiesBasedConfigData(properties));
        }
        return result;
    }
}

