/*
 * Decompiled with CFR 0.152.
 */
package jcckit;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import jcckit.data.DataPlot;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Renderer;
import jcckit.plot.Plot;
import jcckit.plot.PlotCanvas;
import jcckit.plot.PlotEvent;
import jcckit.plot.PlotEventType;
import jcckit.renderer.GraphicsRenderer;
import jcckit.renderer.Transformation;
import jcckit.util.ConfigParameters;
import jcckit.util.ConfigParametersBasedConfigData;
import jcckit.util.Factory;
import jcckit.util.PropertiesBasedConfigData;

public class GraphicsPlotCanvas
extends PlotCanvas {
    public static final String BACKGROUND_KEY = "background";
    public static final String FOREGROUND_KEY = "foreground";
    public static final String DOUBLE_BUFFERING_KEY = "doubleBuffering";
    private Transformation _transformation;
    private boolean _reset = true;
    private boolean _doubleBuffering;
    private String _renderer = "jcckit.renderer.GraphicsRenderer";
    protected GraphicsCanvas _canvas;
    private GraphicalElement _marker;

    public GraphicsPlotCanvas(ConfigParameters config) {
        super(config);
        this.createGraphicsCanvas();
        this._doubleBuffering = config.getBoolean(DOUBLE_BUFFERING_KEY, true);
        this._canvas.setBackground(config.getColor(BACKGROUND_KEY, this._canvas.getBackground()));
        this._canvas.setForeground(config.getColor(FOREGROUND_KEY, this._canvas.getForeground()));
    }

    public void setRenderer(String className) {
        this._renderer = className;
    }

    public void setDoubleBuffering(boolean doubleBuffering) {
        this._doubleBuffering = doubleBuffering;
    }

    public void drawInto(Image image) {
        this._canvas.setSize(image.getWidth(null), image.getHeight(null));
        this._canvas.paint(image.getGraphics());
    }

    protected void createGraphicsCanvas() {
        this._canvas = new GraphicsCanvas();
    }

    public void plotChanged(PlotEvent event) {
        if (event.getType() == PlotEventType.COODINATE_SYSTEM_CHANGED) {
            this._reset = true;
        }
        this._canvas.handleEvent(event);
    }

    public Canvas getGraphicsCanvas() {
        return this._canvas;
    }

    public GraphPoint mapCursorPosition(int x, int y) {
        return this._transformation.transformBack(x, y);
    }

    public void setMarker(GraphicalElement marker) {
        this._marker = marker;
    }

    public static void main(String[] args) throws Exception {
        GraphicsPlotCanvas.run(args, "jcckit.GraphicsPlotCanvas");
    }

    protected static void run(String[] args, String plotCanvas) throws Exception {
        if (args.length == 0) {
            GraphicsPlotCanvas.printUsageAndExit(plotCanvas);
        }
        String file = args[0];
        String renderer = null;
        if (file.equals("-r")) {
            if (args.length > 2) {
                renderer = args[1];
                file = args[2];
            } else {
                GraphicsPlotCanvas.printUsageAndExit(plotCanvas);
            }
        }
        Properties p = new Properties();
        p.put("className", plotCanvas);
        ConfigParameters config = new ConfigParameters(new ConfigParametersBasedConfigData(new ConfigParameters(new PropertiesBasedConfigData(file)), new ConfigParameters(new PropertiesBasedConfigData(p))));
        GraphicsPlotCanvas canvas = (GraphicsPlotCanvas)Factory.create(config);
        if (renderer != null) {
            canvas.setRenderer(renderer);
        }
        canvas.connect(DataPlot.create(config));
        Frame frame = new Frame("JCCKit: " + file);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.add((Component)canvas.getGraphicsCanvas(), "Center");
        frame.setSize(666, 555);
        frame.show();
    }

    private static void printUsageAndExit(String plotCanvas) {
        System.out.println("Usage: java " + plotCanvas + " [-r <renderer class>] <properties file>");
        System.exit(0);
    }

    protected class GraphicsPainter {
        private final Component _component;
        private Image _buffer;
        private Image _coordinateSystem;
        private Graphics _bufferGraphics;
        private Dimension _currentSize;

        public GraphicsPainter(Component component) {
            this._component = component;
        }

        public void paint(Graphics g) {
            Dimension size = this._component.getSize();
            if (size.width <= 0) {
                size.width = 1;
            }
            if (size.height <= 0) {
                size.height = 1;
            }
            if (GraphicsPlotCanvas.this._reset || !size.equals(this._currentSize)) {
                this.init(size);
            }
            Plot plot = GraphicsPlotCanvas.this.getPlot();
            this.drawCoordinateSystem(size, plot, g);
            this.drawPlot(plot, GraphicsPlotCanvas.this._doubleBuffering ? this._bufferGraphics : g);
            if (GraphicsPlotCanvas.this._doubleBuffering) {
                g.drawImage(this._buffer, 0, 0, null);
            }
            if (GraphicsPlotCanvas.this._marker != null) {
                GraphicsPlotCanvas.this._marker.renderWith(this.createRenderer(g));
            }
        }

        private void drawPlot(Plot plot, Graphics g) {
            this.prepare(g);
            if (GraphicsPlotCanvas.this._doubleBuffering) {
                g.drawImage(this._coordinateSystem, 0, 0, null);
            }
            Renderer renderer = this.createRenderer(g);
            GraphicalElement[] curves = plot.getCurves();
            int i = 0;
            while (i < curves.length) {
                curves[i].renderWith(renderer);
                ++i;
            }
            GraphicalElement annotation = plot.getAnnotation();
            if (annotation != null) {
                annotation.renderWith(renderer);
            }
            if (plot.isLegendVisible()) {
                plot.getLegend().renderWith(renderer);
            }
        }

        private void init(Dimension size) {
            GraphicsPlotCanvas.this._reset = false;
            this._currentSize = size;
            if (this._buffer != null) {
                this._buffer.flush();
                this._bufferGraphics.dispose();
            }
            if (GraphicsPlotCanvas.this._doubleBuffering) {
                this._buffer = this._component.createImage(size.width, size.height);
                this._bufferGraphics = this._buffer.getGraphics();
            }
            if (this._coordinateSystem != null) {
                this._coordinateSystem.flush();
                this._coordinateSystem = null;
            }
            this.calculateTransformation(size);
        }

        private void drawCoordinateSystem(Dimension size, Plot plot, Graphics g) {
            if (this._coordinateSystem == null || !GraphicsPlotCanvas.this._doubleBuffering) {
                if (GraphicsPlotCanvas.this._doubleBuffering) {
                    this._coordinateSystem = this._component.createImage(size.width, size.height);
                    g = this._coordinateSystem.getGraphics();
                }
                g.setColor(this._component.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this._component.getForeground());
                plot.getCoordinateSystem().renderWith(this.createRenderer(g));
                if (GraphicsPlotCanvas.this._doubleBuffering) {
                    g.dispose();
                }
            }
        }

        protected void prepare(Graphics g) {
        }

        protected void calculateTransformation(Dimension size) {
            GraphicsPlotCanvas.this._transformation = new Transformation(size.width, size.height, GraphicsPlotCanvas.this.getPaper(), GraphicsPlotCanvas.this.getHorizontalAnchor(), GraphicsPlotCanvas.this.getVerticalAnchor());
        }

        protected Renderer createRenderer(Graphics g) {
            return ((GraphicsRenderer)Factory.create(GraphicsPlotCanvas.this._renderer)).init(g, this._component, GraphicsPlotCanvas.this._transformation);
        }
    }

    protected class GraphicsCanvas
    extends Canvas {
        protected GraphicsPainter _painter;

        public GraphicsCanvas() {
            this._painter = new GraphicsPainter(this);
        }

        public void handleEvent(PlotEvent event) {
            this.repaint();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            this._painter.paint(g);
        }
    }
}

