/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jcckit.GraphicsPlotCanvas;
import jcckit.data.DataCurve;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

public class GraficoColunas
extends JPanel {
    private double[] variaveis;
    private int tamanho;
    private DataPlot vPlot;
    private String variavel;
    private String pontosMedios;
    private boolean ehHistograma;

    public GraficoColunas(double[] var, String pontosMedios, String variavel, boolean ehHist) {
        this.variaveis = var;
        this.variavel = variavel;
        this.pontosMedios = pontosMedios;
        this.tamanho = var.length;
        this.ehHistograma = ehHist;
    }

    public void init() {
        GraphicsPlotCanvas plotCanvas = this.createPlotCanvas(this.variavel);
        this.vPlot = new DataPlot();
        this.vPlot.addElement(new DataCurve(""));
        plotCanvas.connect(this.vPlot);
        this.setLayout(new BorderLayout());
        this.add((Component)plotCanvas.getGraphicsCanvas(), "Center");
        new Thread(){

            public void run() {
                GraficoColunas.this.animate();
            }
        }.start();
    }

    private GraphicsPlotCanvas createPlotCanvas(String nome) {
        String str = "" + ((double)this.tamanho - 0.25);
        String str2 = "0.05";
        if (this.tamanho != 0) {
            str2 = "" + 0.765 / (double)this.tamanho;
        }
        String alt = "" + this.altura();
        Properties props = new Properties();
        ConfigParameters config = new ConfigParameters(new PropertiesBasedConfigData(props));
        props.put("plot/legendVisible", "false");
        props.put("plot/coordinateSystem/xAxis/minimum", "-0.75");
        props.put("plot/coordinateSystem/xAxis/maximum", str);
        props.put("plot/coordinateSystem/xAxis/axisLabel", nome);
        props.put("plot/coordinateSystem/xAxis/ticLabelFormat/className", "jcckit.plot.TicLabelMap");
        props.put("plot/coordinateSystem/xAxis/ticLabelFormat/map", this.pontosMedios);
        props.put("plot/coordinateSystem/yAxis/axisLabel", "Freq\u00fc\u00eancia Relativa");
        props.put("plot/coordinateSystem/yAxis/maximum", alt);
        props.put("plot/coordinateSystem/yAxis/ticLabelFormat", "%d%%");
        props.put("plot/curveFactory/definitions", "curve");
        if (this.ehHistograma) {
            props.put("plot/curveFactory/curve/symbolFactory/className", "jcckit.plot.BarFactory");
            props.put("plot/curveFactory/curve/symbolFactory/attributes/className", "jcckit.graphic.ShapeAttributes");
            props.put("plot/curveFactory/curve/symbolFactory/attributes/fillColor", "0xfe8000");
            props.put("plot/curveFactory/curve/symbolFactory/attributes/lineColor", "10");
            props.put("plot/curveFactory/curve/symbolFactory/size", str2);
            props.put("plot/curveFactory/curve/withLine", "false");
        } else {
            props.put("plot/curveFactory/curve/withLine", "true");
        }
        props.put("plot/initialHintForNextCurve/className", "jcckit.plot.PositionHint");
        props.put("plot/initialHintForNextCurve/position", "0 0.1");
        return new GraphicsPlotCanvas(config);
    }

    private void animate() {
        int n = this.variaveis.length;
        DataCurve curve = new DataCurve("");
        int i = 0;
        while (i < n) {
            curve.addElement(new DataPoint(i, 0.0));
            ++i;
        }
        this.vPlot.replaceElementAt(0, curve);
        i = 0;
        while (i < n) {
            double x = i;
            double y = 0.0;
            while (y < this.variaveis[i]) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                y = Math.min(this.variaveis[i], y + 5.0);
                curve.replaceElementAt(i, new DataPoint(x, y));
            }
            ++i;
        }
    }

    private double altura() {
        double retorno = this.variaveis[0];
        int i = 1;
        while (i < this.tamanho) {
            double var = this.variaveis[i];
            if (var > retorno) {
                retorno = var;
            }
            ++i;
        }
        return retorno *= 1.1;
    }

    protected static void criarEMostrarGUI(double[] var, String pontMed, String titulo, boolean ehHist) {
        JFrame frame = new JFrame("Pol\u00edgono de freq\u00fc\u00eancia relativa");
        if (ehHist) {
            frame.setTitle("Histograma de freq\u00fc\u00eancia relativa");
        }
        GraficoColunas applet = new GraficoColunas(var, pontMed, titulo, ehHist);
        applet.init();
        frame.setContentPane(applet);
        frame.pack();
        frame.setSize(629, 453);
        frame.setVisible(true);
    }
}

