/*
 * Decompiled with CFR 0.152.
 */
package estatisticas;

import java.math.BigDecimal;
import util.CalculoNaoExiste;
import util.Fila;
import util.Moda;
import util.Ordenar;
import util.Retorno;

public class CalculosEstatisticos {
    private double[] variaveis;
    private int tamanho;
    private int precisao;
    private int cont;

    public CalculosEstatisticos(double[] var, int pr) {
        this.precisao = pr;
        this.tamanho = var.length;
        Ordenar ordem = new Ordenar(var);
        ordem.mergesort(0, this.tamanho - 1);
        this.variaveis = ordem.getVariaveis();
    }

    public double mediaAr() {
        double retorno = 0.0;
        int i = 0;
        while (i < this.tamanho) {
            retorno += this.variaveis[i];
            ++i;
        }
        if (this.tamanho != 0) {
            retorno /= (double)this.tamanho;
        }
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double variancia() {
        double retorno = 0.0;
        double medAr = this.mediaAr();
        int i = 0;
        while (i < this.tamanho) {
            double var = this.variaveis[i];
            retorno += Math.pow(var - medAr, 2.0);
            ++i;
        }
        if (this.tamanho != 1) {
            retorno /= (double)(this.tamanho - 1);
        }
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double desvioPad() {
        double retorno = Math.sqrt(this.variancia());
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double curtose() {
        double retorno = 0.0;
        int p = this.precisao;
        this.precisao = 7;
        double medAr = this.mediaAr();
        double variancia = this.variancia();
        if (variancia != 0.0) {
            int i = 0;
            while (i < this.tamanho) {
                double var = this.variaveis[i];
                retorno += Math.pow(var - medAr, 4.0);
                ++i;
            }
            retorno /= Math.pow(variancia, 2.0);
            if (this.tamanho > 3) {
                double tam = this.tamanho;
                double a = tam * (tam + 1.0) / ((tam - 1.0) * (tam - 2.0) * (tam - 3.0));
                double b = 3.0 * (tam - 1.0) * (tam - 1.0) / ((tam - 2.0) * (tam - 3.0));
                retorno = a * retorno - b;
            }
            this.precisao = p;
            BigDecimal ret = new BigDecimal(retorno);
            retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        } else {
            --this.precisao;
        }
        return retorno;
    }

    public double mediaHar() throws CalculoNaoExiste {
        double retorno = 0.0;
        int i = 0;
        while (i < this.tamanho) {
            double var = this.variaveis[i];
            if (var != 0.0) {
                retorno += 1.0 / var;
            } else {
                throw new CalculoNaoExiste();
            }
            ++i;
        }
        if (this.tamanho != 0) {
            retorno = (double)this.tamanho / retorno;
        }
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double mediaGeom() {
        double retorno = 1.0;
        int i = 0;
        while (i < this.tamanho) {
            retorno *= this.variaveis[i];
            ++i;
        }
        if (this.tamanho != 0) {
            retorno = Math.pow(retorno, Math.pow(this.tamanho, -1.0));
        }
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double mediaPond(double a, double pa, double b, double pb) {
        return (a * pa + b * pb) / (pa + pb);
    }

    public double pQuartil() {
        double retorno = this.variaveis[0];
        double ind = ((double)this.tamanho + 3.0) / 4.0;
        int indiceA = new Double(ind).intValue();
        if (indiceA != 0 && indiceA < this.tamanho) {
            double a = this.variaveis[indiceA - 1];
            double b = this.variaveis[indiceA];
            double pb = ind - (double)indiceA;
            double pa = 1.0 - pb;
            retorno = this.mediaPond(a, pa, b, pb);
            BigDecimal ret = new BigDecimal(retorno);
            retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        }
        return retorno;
    }

    public double tQuartil() {
        double retorno = this.variaveis[0];
        double ind = (3.0 * (double)this.tamanho + 1.0) / 4.0;
        int indiceA = new Double(ind).intValue();
        if (indiceA != 0 && indiceA < this.tamanho) {
            double a = this.variaveis[indiceA - 1];
            double b = this.variaveis[indiceA];
            double pb = ind - (double)indiceA;
            double pa = 1.0 - pb;
            retorno = this.mediaPond(a, pa, b, pb);
            BigDecimal ret = new BigDecimal(retorno);
            retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        }
        return retorno;
    }

    public double mediana() {
        double retorno = this.variaveis[0];
        double ind = ((double)this.tamanho + 1.0) / 2.0;
        int indiceA = new Double(ind).intValue();
        if (indiceA != 0 && indiceA < this.tamanho) {
            double a = this.variaveis[indiceA - 1];
            double b = this.variaveis[indiceA];
            double pb = ind - (double)indiceA;
            double pa = 1.0 - pb;
            retorno = this.mediaPond(a, pa, b, pb);
            BigDecimal ret = new BigDecimal(retorno);
            retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        }
        return retorno;
    }

    public Retorno moda() {
        Retorno retorno = new Retorno();
        Fila f = new Fila();
        int i = 0;
        int cont = 0;
        double re = this.variaveis[0];
        while (i < this.tamanho && this.variaveis[i] == re) {
            ++cont;
            ++i;
        }
        while (i < this.tamanho) {
            int cont2 = 0;
            double ret = this.variaveis[i];
            while (i < this.tamanho && this.variaveis[i] == ret) {
                ++cont2;
                ++i;
            }
            if (cont2 > cont) {
                re = ret;
                cont = cont2;
                f.setInicio(null);
                continue;
            }
            if (cont2 != cont) continue;
            f.inserir(new Moda(re));
            re = ret;
        }
        if (re != this.variaveis[0] && cont != 1) {
            f.inserir(new Moda(re));
            retorno.setModas(f);
            retorno.setExiste(true);
        }
        return retorno;
    }

    public double assimetria() {
        double retorno = 0.0;
        int pr = this.precisao;
        this.precisao = 7;
        double p = this.pQuartil();
        double t = this.tQuartil();
        double medAr = this.mediaAr();
        this.precisao = pr;
        double amplIntQuartil = t - p;
        BigDecimal temp = new BigDecimal(amplIntQuartil);
        if ((amplIntQuartil = temp.divide(new BigDecimal(1), this.precisao, 0).doubleValue()) != 0.0) {
            retorno = (p + t - 2.0 * medAr) / amplIntQuartil;
        }
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double amplitudeInterQuartil() {
        double t = this.tQuartil();
        double p = this.pQuartil();
        double retorno = t - p;
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double coeficienteDeVariacao() throws CalculoNaoExiste {
        double retorno = 0.0;
        int p = this.precisao;
        this.precisao = 7;
        double mediaAr = this.mediaAr();
        double desvioPad = this.desvioPad();
        this.precisao = p;
        if (mediaAr == 0.0) {
            throw new CalculoNaoExiste();
        }
        retorno = desvioPad / mediaAr;
        BigDecimal ret = new BigDecimal(retorno *= 100.0);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public double amplitudeTotal() {
        double retorno = this.variaveis[this.tamanho - 1] - this.variaveis[0];
        BigDecimal ret = new BigDecimal(retorno);
        retorno = ret.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        return retorno;
    }

    public String representacao() {
        String retorno = "";
        retorno = String.valueOf(retorno) + "  M\u00e9dia Aritm\u00e9tica = " + this.mediaAr() + "\n";
        retorno = String.valueOf(retorno) + "  M\u00e9dia Harm\u00f4nica = ";
        try {
            retorno = String.valueOf(retorno) + this.mediaHar();
        }
        catch (CalculoNaoExiste e) {
            retorno = String.valueOf(retorno) + e.getMessage();
        }
        retorno = String.valueOf(retorno) + "\n";
        retorno = String.valueOf(retorno) + "  M\u00e9dia Geom\u00e9trica = " + this.mediaGeom() + "\n";
        retorno = String.valueOf(retorno) + "  Mediana = " + this.mediana() + "\n";
        retorno = String.valueOf(retorno) + "  Primeiro Quartil = " + this.pQuartil() + "\n";
        retorno = String.valueOf(retorno) + "  Terceiro Quartil = " + this.tQuartil() + "\n";
        retorno = String.valueOf(retorno) + "  Amplitude Inter-Quartil = " + this.amplitudeInterQuartil() + "\n";
        retorno = String.valueOf(retorno) + "  Amplitude Total = " + this.amplitudeTotal() + "\n";
        retorno = String.valueOf(retorno) + "  Coeficiente de Varia\u00e7\u00e3o = ";
        try {
            retorno = String.valueOf(retorno) + this.coeficienteDeVariacao();
        }
        catch (CalculoNaoExiste e) {
            retorno = String.valueOf(retorno) + e.getMessage();
        }
        retorno = String.valueOf(retorno) + "\n";
        retorno = String.valueOf(retorno) + "  Desvio Padr\u00e3o = " + this.desvioPad() + "\n";
        retorno = String.valueOf(retorno) + "  Vari\u00e2ncia  = " + this.variancia() + "\n";
        retorno = String.valueOf(retorno) + "  Curtose = " + this.curtose() + "\n";
        retorno = String.valueOf(retorno) + "  Assimetria = " + this.assimetria() + "\n";
        retorno = String.valueOf(retorno) + "  Modas = ";
        Retorno moda = this.moda();
        Moda mod = null;
        if (moda.getExiste()) {
            Fila m = moda.getModas();
            if (m != null) {
                mod = m.getInicio();
            }
        } else {
            retorno = String.valueOf(retorno) + "n\u00e3o existe";
        }
        while (mod != null) {
            retorno = String.valueOf(retorno) + mod.getValor() + " ";
            mod = mod.getProximo();
        }
        return retorno;
    }

    private int numeroDeIntervalos() {
        double reto = Math.sqrt(this.tamanho);
        BigDecimal ret = new BigDecimal(reto);
        int retorno = ret.divide(new BigDecimal(1), 0, 0).intValue();
        return retorno;
    }

    private int contar(double inicio, double fim) {
        int retorno = 0;
        boolean controle = true;
        while (controle && this.cont < this.tamanho) {
            double var = this.variaveis[this.cont];
            if (fim > var) {
                ++retorno;
                ++this.cont;
                continue;
            }
            controle = false;
        }
        return retorno;
    }

    public Object[][] criar() {
        int numeroDeIntervalos = this.numeroDeIntervalos();
        double amplitudeDoIntervalo = 0.0;
        double amplitudeTotal = this.amplitudeTotal() + Math.pow(10.0, -this.precisao);
        BigDecimal amplitude = new BigDecimal(amplitudeTotal);
        amplitudeTotal = amplitude.divide(new BigDecimal(1), this.precisao, 0).doubleValue();
        BigDecimal num = new BigDecimal(numeroDeIntervalos);
        if (numeroDeIntervalos != 0) {
            amplitudeDoIntervalo = amplitude.divide(num, this.precisao, 0).doubleValue();
        }
        while (amplitudeDoIntervalo * (double)numeroDeIntervalos - amplitudeTotal >= amplitudeDoIntervalo) {
            --numeroDeIntervalos;
        }
        double inicio = this.variaveis[0] + Math.pow(10.0, -this.precisao - 1);
        BigDecimal in = new BigDecimal(inicio);
        inicio = in.divide(new BigDecimal(1), this.precisao, 3).doubleValue();
        int i = 0;
        Object[][] retorno = new Object[numeroDeIntervalos + 1][5];
        i = 0;
        while (i < numeroDeIntervalos) {
            String classe = "" + inicio;
            double fim = inicio + amplitudeDoIntervalo;
            BigDecimal fin = new BigDecimal(fim);
            fim = fin.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
            int fi = this.contar(inicio, fim);
            inicio = fim;
            BigDecimal frR = new BigDecimal((double)fi);
            double fr = frR.divide(new BigDecimal((double)this.tamanho), 4, 4).doubleValue();
            int Fi = fi;
            if (i != 0) {
                Fi += ((Integer)retorno[i - 1][3]).intValue();
            }
            BigDecimal FrR = new BigDecimal((double)Fi);
            double Fr = FrR.divide(new BigDecimal((double)this.tamanho), 4, 4).doubleValue();
            classe = String.valueOf(classe) + " |-- " + inicio;
            Object[] ret = new Object[]{classe, new Integer(fi), new Double(fr), new Integer(Fi), new Double(Fr)};
            retorno[i] = ret;
            ++i;
        }
        this.cont = 0;
        Object[] ret = new Object[]{"Total", retorno[i - 1][3], retorno[i - 1][4], "", ""};
        retorno[numeroDeIntervalos] = ret;
        return retorno;
    }

    public String[] titulos() {
        int numeroDeIntervalos = this.numeroDeIntervalos();
        double amplitudeDoIntervalo = 0.0;
        double amplitudeTotal = this.amplitudeTotal() + Math.pow(10.0, -this.precisao);
        BigDecimal amplitude = new BigDecimal(amplitudeTotal);
        amplitudeTotal = amplitude.divide(new BigDecimal(1), this.precisao, 0).doubleValue();
        BigDecimal num = new BigDecimal(numeroDeIntervalos);
        if (numeroDeIntervalos != 0) {
            amplitudeDoIntervalo = amplitude.divide(num, this.precisao, 0).doubleValue();
        }
        while (amplitudeDoIntervalo * (double)numeroDeIntervalos - amplitudeTotal >= amplitudeDoIntervalo) {
            --numeroDeIntervalos;
        }
        double inicio = this.variaveis[0] + Math.pow(10.0, -this.precisao - 1);
        BigDecimal in = new BigDecimal(inicio);
        inicio = in.divide(new BigDecimal(1), this.precisao, 3).doubleValue();
        String[] retorno = new String[numeroDeIntervalos];
        int i = 0;
        while (i < numeroDeIntervalos) {
            String classe = "" + inicio;
            double fim = inicio + amplitudeDoIntervalo;
            BigDecimal fin = new BigDecimal(fim);
            inicio = fim = fin.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
            retorno[i] = classe = String.valueOf(classe) + " |-- " + inicio;
            ++i;
        }
        return retorno;
    }

    public double[] frequenciaRelativa() {
        int numeroDeIntervalos = this.numeroDeIntervalos();
        double amplitudeDoIntervalo = 0.0;
        double amplitudeTotal = this.amplitudeTotal() + Math.pow(10.0, -this.precisao);
        BigDecimal amplitude = new BigDecimal(amplitudeTotal);
        amplitudeTotal = amplitude.divide(new BigDecimal(1), this.precisao, 0).doubleValue();
        BigDecimal num = new BigDecimal(numeroDeIntervalos);
        if (numeroDeIntervalos != 0) {
            amplitudeDoIntervalo = amplitude.divide(num, this.precisao, 0).doubleValue();
        }
        while (amplitudeDoIntervalo * (double)numeroDeIntervalos - amplitudeTotal >= amplitudeDoIntervalo) {
            --numeroDeIntervalos;
        }
        double inicio = this.variaveis[0] + Math.pow(10.0, -this.precisao - 1);
        BigDecimal in = new BigDecimal(inicio);
        inicio = in.divide(new BigDecimal(1), this.precisao, 3).doubleValue();
        double[] retorno = new double[numeroDeIntervalos];
        int i = 0;
        i = 0;
        while (i < numeroDeIntervalos) {
            double fim = inicio + amplitudeDoIntervalo;
            BigDecimal fin = new BigDecimal(fim);
            fim = fin.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
            int fi = this.contar(inicio, fim);
            inicio = fim;
            BigDecimal frR = new BigDecimal((double)fi);
            double fr = frR.divide(new BigDecimal((double)this.tamanho), 4, 4).doubleValue();
            frR = new BigDecimal(fr *= 100.0);
            retorno[i] = fr = frR.divide(new BigDecimal(1), 2, 4).doubleValue();
            ++i;
        }
        return retorno;
    }

    public String pontosMedios() {
        int numeroDeIntervalos = this.numeroDeIntervalos();
        double amplitudeDoIntervalo = 0.0;
        double amplitudeTotal = this.amplitudeTotal() + Math.pow(10.0, -this.precisao);
        BigDecimal amplitude = new BigDecimal(amplitudeTotal);
        amplitudeTotal = amplitude.divide(new BigDecimal(1), this.precisao, 0).doubleValue();
        BigDecimal num = new BigDecimal(numeroDeIntervalos);
        if (numeroDeIntervalos != 0) {
            amplitudeDoIntervalo = amplitude.divide(num, this.precisao, 0).doubleValue();
        }
        while (amplitudeDoIntervalo * (double)numeroDeIntervalos - amplitudeTotal >= amplitudeDoIntervalo) {
            --numeroDeIntervalos;
        }
        double inicio = this.variaveis[0] + Math.pow(10.0, -this.precisao - 1);
        BigDecimal in = new BigDecimal(inicio);
        inicio = in.divide(new BigDecimal(1), this.precisao, 3).doubleValue();
        String retorno = "";
        double fim = inicio + amplitudeDoIntervalo;
        BigDecimal fin = new BigDecimal(fim);
        fim = fin.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
        fin = new BigDecimal(fim);
        double med = fin.add(new BigDecimal(inicio)).divide(new BigDecimal(2), this.precisao, 4).doubleValue();
        int i = 0;
        retorno = String.valueOf(retorno) + i + "=" + med;
        ++i;
        while (i < numeroDeIntervalos) {
            BigDecimal m = new BigDecimal(med += amplitudeDoIntervalo);
            med = m.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
            retorno = String.valueOf(retorno) + ";" + i + "=" + med;
            ++i;
        }
        return retorno;
    }

    public CalculosEstatisticos uniao(CalculosEstatisticos entrada, CalculosEstatisticos entrada1) {
        int n1 = this.tamanho;
        int n2 = entrada.tamanho;
        int n3 = entrada1.tamanho;
        double[] saida = new double[n1 + n2 + n3];
        int i = 0;
        while (i < n1) {
            saida[i] = this.variaveis[i];
            ++i;
        }
        i = 0;
        while (i < n2) {
            saida[i + n1] = entrada.variaveis[i];
            ++i;
        }
        i = 0;
        while (i < n3) {
            saida[i + n1 + n2] = entrada1.variaveis[i];
            ++i;
        }
        CalculosEstatisticos retorno = new CalculosEstatisticos(saida, this.precisao);
        return retorno;
    }

    public Object[][] criar2(CalculosEstatisticos[] c) {
        int numeroDeIntervalos = this.numeroDeIntervalos();
        double amplitudeDoIntervalo = 0.0;
        double amplitudeTotal = this.amplitudeTotal() + Math.pow(10.0, -this.precisao);
        BigDecimal amplitude = new BigDecimal(amplitudeTotal);
        amplitudeTotal = amplitude.divide(new BigDecimal(1), this.precisao, 0).doubleValue();
        BigDecimal num = new BigDecimal(numeroDeIntervalos);
        if (numeroDeIntervalos != 0) {
            amplitudeDoIntervalo = amplitude.divide(num, this.precisao, 0).doubleValue();
        }
        while (amplitudeDoIntervalo * (double)numeroDeIntervalos - amplitudeTotal >= amplitudeDoIntervalo) {
            --numeroDeIntervalos;
        }
        double inicio = this.variaveis[0] + Math.pow(10.0, -this.precisao - 1);
        BigDecimal in = new BigDecimal(inicio);
        inicio = in.divide(new BigDecimal(1), this.precisao, 3).doubleValue();
        int i = 0;
        int n = c.length;
        Object[][] retorno = new Object[numeroDeIntervalos][n + 1];
        i = 0;
        while (i < numeroDeIntervalos) {
            String classe = "" + inicio;
            double fim = inicio + amplitudeDoIntervalo;
            BigDecimal fin = new BigDecimal(fim);
            inicio = fim = fin.divide(new BigDecimal(1), this.precisao, 4).doubleValue();
            classe = String.valueOf(classe) + " |-- " + inicio;
            retorno[i][0] = classe;
            int y = 0;
            while (y < n) {
                int fi = c[y].contar(inicio, fim);
                inicio = fim;
                BigDecimal frR = new BigDecimal((double)fi);
                retorno[i][y + 1] = new Double(frR.divide(new BigDecimal((double)c[y].tamanho), 4, 4).doubleValue());
                ++y;
            }
            ++i;
        }
        int y = 0;
        while (y < n) {
            c[y].cont = 0;
            ++y;
        }
        return retorno;
    }
}

