/*
 * Decompiled with CFR 0.152.
 */
package basicas;

import basicas.Instancia;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class Repositorio {
    private Vector repositorio = new Vector(0, 1);

    public Repositorio(File f) {
        try {
            LineNumberReader leitor = new LineNumberReader(new FileReader(f));
            String linha = leitor.readLine();
            while (linha != null) {
                String[] strings = linha.split("[,]");
                char x = strings[0].charAt(0);
                double y = Double.parseDouble(strings[1]);
                double z = Double.parseDouble(strings[2]);
                double w = Double.parseDouble(strings[3]);
                double a = Double.parseDouble(strings[4]);
                double b = Double.parseDouble(strings[5]);
                Instancia instancia = new Instancia(x, y, z, w, a, b);
                this.repositorio.add(instancia);
                linha = leitor.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Vector getClasses(char cl) {
        Vector<Instancia> retorno = new Vector<Instancia>(0, 1);
        int n = this.repositorio.size();
        int i = 0;
        while (i < n) {
            Instancia inst = (Instancia)this.repositorio.get(i);
            char op = inst.getAtributoClasse();
            if (op == cl) {
                retorno.add(inst);
            }
            ++i;
        }
        return retorno;
    }

    public double[] getVariaveis(char op, char cl) {
        Vector v = this.getClasses(cl);
        int n = v.size();
        double[] retorno = new double[n];
        int i = 0;
        while (i < n) {
            switch (op) {
                case '0': {
                    Instancia inst = (Instancia)v.get(i);
                    retorno[i] = inst.getT3Resina();
                    break;
                }
                case '1': {
                    Instancia inst2 = (Instancia)v.get(i);
                    retorno[i] = inst2.getMedDeTiroxinaSericaTotal();
                    break;
                }
                case '2': {
                    Instancia inst3 = (Instancia)v.get(i);
                    retorno[i] = inst3.getMedTriIodoTironinaSericaTotal();
                    break;
                }
                case '3': {
                    Instancia inst4 = (Instancia)v.get(i);
                    retorno[i] = inst4.getMedDeTSH();
                    break;
                }
                case '4': {
                    Instancia inst5 = (Instancia)v.get(i);
                    retorno[i] = inst5.getDiferencaAbsolutaMaxDeTSH();
                }
            }
            ++i;
        }
        return retorno;
    }
}

