/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELException;
import org.jdesktop.el.ELResolver;
import org.jdesktop.el.MethodInfo;
import org.jdesktop.el.PropertyNotFoundException;
import org.jdesktop.el.impl.lang.EvaluationContext;
import org.jdesktop.el.impl.parser.SimpleNode;
import org.jdesktop.el.impl.util.MessageFactory;
import org.jdesktop.el.impl.util.ReflectionUtil;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().getType(ctx, t.base, t.property);
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        int i;
        Object base = this.children[0].getValue(ctx);
        if (base == null || base == ELContext.UNRESOLVABLE_RESULT) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        ELResolver resolver = ctx.getELResolver();
        if (propCount > 1) {
            for (i = 1; base != null && base != ELContext.UNRESOLVABLE_RESULT && i < propCount; ++i) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                base = resolver.getValue(ctx, base, property);
            }
            if (base == ELContext.UNRESOLVABLE_RESULT || base == null || property == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        if ((property = this.children[i].getValue(ctx)) == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[i]));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        int i;
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        if (base == ELContext.UNRESOLVABLE_RESULT || base == null && propCount > 1) {
            ctx.clearResolvedProperties();
            return ELContext.UNRESOLVABLE_RESULT;
        }
        Object property = null;
        ELResolver resolver = ctx.getELResolver();
        for (i = 1; base != null && i < propCount; ++i) {
            property = this.children[i].getValue(ctx);
            if (property == null) {
                return null;
            }
            ctx.setPropertyResolved(false);
            Object origBase = base;
            base = resolver.getValue(ctx, base, property);
            if (base == ELContext.UNRESOLVABLE_RESULT) {
                ctx.clearResolvedProperties();
                return base;
            }
            ctx.resolvedProperty(origBase, property);
        }
        if (base == null && i < propCount) {
            ctx.clearResolvedProperties();
            return ELContext.UNRESOLVABLE_RESULT;
        }
        return base;
    }

    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        return ctx.getELResolver().isReadOnly(ctx, t.base, t.property);
    }

    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ctx.getELResolver().setValue(ctx, t.base, t.property, value);
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        Object result = null;
        try {
            result = m.invoke(t.base, paramValues);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        return result;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

