/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.gui;

import com.gcap.randomvariategenerator.basics.EmpiricalLoader;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.EmpiricalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ErlangRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ExponentialRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.GeometricRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.LogNormalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.NormalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ParetoRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.PoissonRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.WeibullRandomVariateGenerator;
import com.gcap.randomvariategenerator.control.DataAnalyzer;
import com.gcap.randomvariategenerator.control.DatasetCreator;
import com.gcap.randomvariategenerator.facade.Facade;
import com.gcap.randomvariategenerator.gui.JPanelDataEmpirical;
import com.gcap.randomvariategenerator.gui.JPanelDataErlang;
import com.gcap.randomvariategenerator.gui.JPanelDataExponential;
import com.gcap.randomvariategenerator.gui.JPanelDataGeometric;
import com.gcap.randomvariategenerator.gui.JPanelDataLogNormal;
import com.gcap.randomvariategenerator.gui.JPanelDataNormal;
import com.gcap.randomvariategenerator.gui.JPanelDataPareto;
import com.gcap.randomvariategenerator.gui.JPanelDataPoisson;
import com.gcap.randomvariategenerator.gui.JPanelDataWeibull;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.jfree.ui.RefineryUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JFrameRandomVariateGenerator
extends JFrame {
    Facade facade;
    RandomVariateGenerator randomVariateGenerator = null;
    boolean autorange = true;
    JPanelDataExponential jPanelExponential = new JPanelDataExponential();
    JPanelDataNormal jPanelNormal = new JPanelDataNormal();
    JPanelDataErlang jPanelErlang = new JPanelDataErlang();
    JPanelDataLogNormal jPanelLogNormal = new JPanelDataLogNormal();
    JPanelDataGeometric jPanelGeometric = new JPanelDataGeometric();
    JPanelDataPareto jPanelPareto = new JPanelDataPareto();
    JPanelDataWeibull jPanelWeibull = new JPanelDataWeibull();
    JPanelDataPoisson jPanelPoisson = new JPanelDataPoisson();
    JPanelDataEmpirical jPanelEmpirical = new JPanelDataEmpirical();
    String fileChoseenReport = "";
    String fileChoseenOutput = "";
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonExportFileData;
    private JButton jButtonExportFileReport;
    private JButton jButtonGenerateGraph;
    private JButton jButtonSelectOutputData;
    private JComboBox jComboBoxSelectGraphGenerated;
    private JComboBox jComboBoxSelectProbabilityDistrubution;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelReport;
    private JPanel jPanelSelectable;
    private JRadioButton jRadioButton1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaDistributionFitting;
    private JTextField jTextFieldGeneratedData;
    private JTextField jTextFieldMaximumValue;
    private JTextField jTextFieldMinimumValue;
    private JTextField jTextFieldNumberOfBins;
    private JTextField jTextFieldNumberOfSamples;
    protected JTextField jTextFieldReportCoeficientOfVariation;
    protected JTextField jTextFieldReportFirstQuartile;
    protected JTextField jTextFieldReportInterquartileInterval;
    protected JTextField jTextFieldReportKurtose;
    protected JTextField jTextFieldReportMaxvalue;
    protected JTextField jTextFieldReportMean;
    protected JTextField jTextFieldReportMedian;
    protected JTextField jTextFieldReportMidRange;
    protected JTextField jTextFieldReportMinValue;
    protected JTextField jTextFieldReportRange;
    protected JTextField jTextFieldReportSTD;
    protected JTextField jTextFieldReportSkewness;
    protected JTextField jTextFieldReportThirdQuartile;
    protected JTextField jTextFieldReportVariace;
    private JTextField jTextFieldStatisticResume;

    public JFrameRandomVariateGenerator() {
        try {
            String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lookAndFeel);
            this.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.jPanelExponential.setBackground(this.jPanelPoisson.getBackground());
        this.setBackground(this.jPanelPoisson.getBackground());
        RefineryUtilities.centerFrameOnScreen((Window)this);
        this.facade = new Facade();
        this.refreshScreen(this.jPanelExponential, this.jPanelSelectable);
        this.generateGraph();
        this.setDefaultCloseOperation(3);
    }

    public Image getIconImage() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icone-hp1.png"));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldMinimumValue = new JTextField();
        this.jTextFieldMaximumValue = new JTextField();
        this.jComboBoxSelectProbabilityDistrubution = new JComboBox();
        this.jRadioButton1 = new JRadioButton();
        this.jPanel17 = new JPanel();
        this.jButtonGenerateGraph = new JButton();
        this.jComboBoxSelectGraphGenerated = new JComboBox();
        this.jPanelSelectable = new JPanel();
        this.jPanel15 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextFieldNumberOfSamples = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldNumberOfBins = new JTextField();
        this.jPanelReport = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jTextFieldReportMidRange = new JTextField();
        this.jTextFieldReportRange = new JTextField();
        this.jTextFieldReportMinValue = new JTextField();
        this.jTextFieldReportMaxvalue = new JTextField();
        this.jTextFieldReportMean = new JTextField();
        this.jTextFieldReportSTD = new JTextField();
        this.jTextFieldReportVariace = new JTextField();
        this.jLabel15 = new JLabel();
        this.jTextFieldReportMedian = new JTextField();
        this.jLabel16 = new JLabel();
        this.jTextFieldReportCoeficientOfVariation = new JTextField();
        this.jTextFieldReportFirstQuartile = new JTextField();
        this.jLabel17 = new JLabel();
        this.jTextFieldReportThirdQuartile = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jTextFieldReportInterquartileInterval = new JTextField();
        this.jTextFieldReportSkewness = new JTextField();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jTextFieldReportKurtose = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextFieldStatisticResume = new JTextField();
        this.jButtonExportFileReport = new JButton();
        this.jLabel22 = new JLabel();
        this.jTextFieldGeneratedData = new JTextField();
        this.jButtonExportFileData = new JButton();
        this.jButtonSelectOutputData = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDistributionFitting = new JTextArea();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("com/gcap/randomvariategenerator/gui/Bundle");
        this.setTitle(bundle.getString("Random_Generator_1"));
        this.setBounds(new Rectangle(800, 600, 800, 600));
        this.setForeground(Color.white);
        this.setIconImage(this.getIconImage());
        this.setName("mainFrame");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel1.setText("Graph generated:");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 622, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 596, Short.MAX_VALUE));
        this.jPanel16.setBorder(BorderFactory.createTitledBorder(null, "Distribution Probability Range", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel4.setText("Minimum value: ");
        this.jLabel3.setText("Maximum value:");
        this.jLabel2.setText("Probability Distribution: ");
        this.jTextFieldMinimumValue.setText("0");
        this.jTextFieldMinimumValue.setEnabled(false);
        this.jTextFieldMaximumValue.setText("10000");
        this.jTextFieldMaximumValue.setEnabled(false);
        this.jTextFieldMaximumValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldMaximumValueActionPerformed(evt);
            }
        });
        this.jComboBoxSelectProbabilityDistrubution.setModel(new DefaultComboBoxModel<String>(new String[]{"Exponential", "Normal", "Erlang", "LogNormal", "Geometric", "Pareto", "Weibull", "Poisson", "Empirical"}));
        this.jComboBoxSelectProbabilityDistrubution.setAutoscrolls(true);
        this.jComboBoxSelectProbabilityDistrubution.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jComboBoxSelectProbabilityDistrubutionActionPerformed(evt);
            }
        });
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("AutoRange");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jRadioButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMinimumValue, -1, 151, Short.MAX_VALUE).addComponent(this.jTextFieldMaximumValue, -1, 151, Short.MAX_VALUE).addComponent(this.jComboBoxSelectProbabilityDistrubution, 0, 151, Short.MAX_VALUE))).addGroup(jPanel16Layout.createSequentialGroup().addGap(76, 76, 76).addComponent(this.jRadioButton1, -1, 115, Short.MAX_VALUE).addGap(88, 88, 88)));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxSelectProbabilityDistrubution).addComponent(this.jLabel2, -1, 26, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMaximumValue).addComponent(this.jLabel3, -1, 26, Short.MAX_VALUE)).addGap(12, 12, 12).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMinimumValue).addComponent(this.jLabel4, -1, 26, Short.MAX_VALUE)).addGap(7, 7, 7).addComponent(this.jRadioButton1, -2, 15, -2)));
        this.jPanel17.setBorder(BorderFactory.createTitledBorder(null, "Graph Selection", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jButtonGenerateGraph.setText("Generate Graph");
        this.jButtonGenerateGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jButtonGenerateGraphActionPerformed(evt);
            }
        });
        this.jComboBoxSelectGraphGenerated.setModel(new DefaultComboBoxModel<String>(new String[]{"Probability Distribution", "Random Variates", "Both"}));
        this.jComboBoxSelectGraphGenerated.setSelectedItem("Both");
        this.jComboBoxSelectGraphGenerated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jComboBoxSelectGraphGeneratedActionPerformed(evt);
            }
        });
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonGenerateGraph).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSelectGraphGenerated, 0, 144, Short.MAX_VALUE).addContainerGap()));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonGenerateGraph).addComponent(this.jComboBoxSelectGraphGenerated, -2, -1, -2)).addContainerGap(39, Short.MAX_VALUE)));
        GroupLayout jPanelSelectableLayout = new GroupLayout(this.jPanelSelectable);
        this.jPanelSelectable.setLayout(jPanelSelectableLayout);
        jPanelSelectableLayout.setHorizontalGroup(jPanelSelectableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 295, Short.MAX_VALUE));
        jPanelSelectableLayout.setVerticalGroup(jPanelSelectableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 219, Short.MAX_VALUE));
        this.jPanel15.setBorder(BorderFactory.createTitledBorder(null, " Data of Histogram ", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel7.setText("Number of samples: ");
        this.jTextFieldNumberOfSamples.setText("100000");
        this.jTextFieldNumberOfSamples.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldNumberOfSamplesActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Number of Bins: ");
        this.jTextFieldNumberOfBins.setText("40");
        this.jTextFieldNumberOfBins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldNumberOfBinsActionPerformed(evt);
            }
        });
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldNumberOfBins, -1, 161, Short.MAX_VALUE).addComponent(this.jTextFieldNumberOfSamples, GroupLayout.Alignment.LEADING, -1, 161, Short.MAX_VALUE))));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addComponent(this.jLabel7, -1, 23, Short.MAX_VALUE).addGap(13, 13, 13).addComponent(this.jLabel8, -1, 17, Short.MAX_VALUE)).addGroup(jPanel15Layout.createSequentialGroup().addComponent(this.jTextFieldNumberOfSamples).addGap(13, 13, 13).addComponent(this.jTextFieldNumberOfBins))).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel16, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelSelectable, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel15, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel17, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jPanel16, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSelectable, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.jPanel15, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel17, -2, -1, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Data Generator", this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Statistic summary", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel9.setText("Standard deviation:");
        this.jLabel6.setText("Variance:");
        this.jLabel10.setText("Mean:");
        this.jLabel11.setText("Max Value:");
        this.jLabel12.setText("Min Value:");
        this.jLabel13.setText("Range:");
        this.jLabel14.setText("MidRange:");
        this.jTextFieldReportMidRange.setEditable(false);
        this.jTextFieldReportMidRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportMidRangeActionPerformed(evt);
            }
        });
        this.jTextFieldReportRange.setEditable(false);
        this.jTextFieldReportRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportRangeActionPerformed(evt);
            }
        });
        this.jTextFieldReportMinValue.setEditable(false);
        this.jTextFieldReportMinValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportMinValueActionPerformed(evt);
            }
        });
        this.jTextFieldReportMaxvalue.setEditable(false);
        this.jTextFieldReportMean.setEditable(false);
        this.jTextFieldReportSTD.setEditable(false);
        this.jTextFieldReportVariace.setEditable(false);
        this.jTextFieldReportVariace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportVariaceActionPerformed(evt);
            }
        });
        this.jLabel15.setText("Median:");
        this.jTextFieldReportMedian.setEditable(false);
        this.jTextFieldReportMedian.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportMedianActionPerformed(evt);
            }
        });
        this.jLabel16.setText("Coeficient of variation:");
        this.jTextFieldReportCoeficientOfVariation.setEditable(false);
        this.jTextFieldReportCoeficientOfVariation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportCoeficientOfVariationActionPerformed(evt);
            }
        });
        this.jTextFieldReportFirstQuartile.setEditable(false);
        this.jTextFieldReportFirstQuartile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportFirstQuartileActionPerformed(evt);
            }
        });
        this.jLabel17.setText("First Quartile:");
        this.jTextFieldReportThirdQuartile.setEditable(false);
        this.jTextFieldReportThirdQuartile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportThirdQuartileActionPerformed(evt);
            }
        });
        this.jLabel18.setText("Third Quartile:");
        this.jLabel19.setText("Interquartile interval:");
        this.jTextFieldReportInterquartileInterval.setEditable(false);
        this.jTextFieldReportInterquartileInterval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportInterquartileIntervalActionPerformed(evt);
            }
        });
        this.jTextFieldReportSkewness.setEditable(false);
        this.jTextFieldReportSkewness.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportSkewnessActionPerformed(evt);
            }
        });
        this.jLabel20.setText("Skewness:");
        this.jLabel21.setText("Kurtosis:");
        this.jTextFieldReportKurtose.setEditable(false);
        this.jTextFieldReportKurtose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jTextFieldReportKurtoseActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(40, 40, 40).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, GroupLayout.Alignment.TRAILING, -1, 129, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, -1, 110, Short.MAX_VALUE).addComponent(this.jLabel11, -1, 110, Short.MAX_VALUE).addComponent(this.jLabel10, -1, 110, Short.MAX_VALUE).addComponent(this.jLabel6, -1, 110, Short.MAX_VALUE)).addGap(19, 19, 19)).addComponent(this.jLabel13, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel14, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel17, GroupLayout.Alignment.TRAILING, -1, 129, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel9).addGap(30, 30, 30)).addComponent(this.jLabel18, -2, 101, -2).addComponent(this.jLabel16, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel19, GroupLayout.Alignment.TRAILING, -2, 127, -2).addComponent(this.jLabel20, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel21, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldReportInterquartileInterval, GroupLayout.Alignment.LEADING, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportMedian, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportMidRange, GroupLayout.Alignment.LEADING, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportRange, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportMinValue, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportMaxvalue, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportMean, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportSTD, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportVariace, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportFirstQuartile, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportThirdQuartile, GroupLayout.Alignment.LEADING, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportCoeficientOfVariation, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportSkewness, -1, 316, Short.MAX_VALUE).addComponent(this.jTextFieldReportKurtose, -1, 316, Short.MAX_VALUE)).addGap(33, 33, 33)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 14, -2).addGap(15, 15, 15).addComponent(this.jLabel9).addGap(9, 9, 9).addComponent(this.jLabel10, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel11, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel12, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel13, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel14, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel15, -2, 14, -2).addGap(12, 12, 12).addComponent(this.jLabel17, -2, 14, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextFieldReportVariace, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportSTD, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportMean, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportMaxvalue, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportMinValue, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportRange, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportMidRange, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportMedian, -2, 20, -2).addGap(6, 6, 6).addComponent(this.jTextFieldReportFirstQuartile, -2, 20, -2).addGap(6, 6, 6).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldReportThirdQuartile, -2, 20, -2).addComponent(this.jLabel18, -2, 17, -2)))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel19, -2, 17, -2)).addGroup(jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldReportInterquartileInterval, -2, 20, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldReportCoeficientOfVariation, -2, 20, -2).addComponent(this.jLabel16, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldReportSkewness, -2, 20, -2).addComponent(this.jLabel20, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldReportKurtose, -2, 20, -2).addComponent(this.jLabel21, -2, 17, -2)).addContainerGap(153, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Export report", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jLabel5.setText("Export statistic resume");
        this.jTextFieldStatisticResume.setText("c:\\resume.txt");
        this.jButtonExportFileReport.setText("Export");
        this.jButtonExportFileReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jButtonExportFileReportActionPerformed(evt);
            }
        });
        this.jLabel22.setText("Export generated data");
        this.jTextFieldGeneratedData.setText("c:\\generatedData.txt");
        this.jButtonExportFileData.setText("Export");
        this.jButtonExportFileData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jButtonExportFileDataActionPerformed(evt);
            }
        });
        this.jButtonSelectOutputData.setText("...");
        this.jButtonSelectOutputData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFrameRandomVariateGenerator.this.jButtonSelectOutputDataActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel22).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldGeneratedData, GroupLayout.Alignment.LEADING, -2, 271, -2).addComponent(this.jTextFieldStatisticResume, GroupLayout.Alignment.LEADING, -2, 271, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectOutputData, -2, 0, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExportFileData).addComponent(this.jButtonExportFileReport)))).addContainerGap(35, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel5).addGap(6, 6, 6).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldStatisticResume, -2, -1, -2).addComponent(this.jButtonExportFileReport)).addGap(26, 26, 26).addComponent(this.jLabel22).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGeneratedData, -2, -1, -2).addComponent(this.jButtonSelectOutputData).addComponent(this.jButtonExportFileData)).addContainerGap(24, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Fit Test", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 0, 255)));
        this.jTextAreaDistributionFitting.setColumns(20);
        this.jTextAreaDistributionFitting.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaDistributionFitting);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 383, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 309, -2).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout jPanelReportLayout = new GroupLayout(this.jPanelReport);
        this.jPanelReport.setLayout(jPanelReportLayout);
        jPanelReportLayout.setHorizontalGroup(jPanelReportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReportLayout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelReportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelReportLayout.setVerticalGroup(jPanelReportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReportLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanelReportLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelReportLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(57, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Report", this.jPanelReport);
        this.getContentPane().add((Component)this.jTabbedPane1, new AbsoluteConstraints(0, 0, 1010, -1));
        this.pack();
    }

    private void jComboBoxSelectGraphGeneratedActionPerformed(ActionEvent evt) {
        if (this.jComboBoxSelectGraphGenerated.getSelectedItem().equals("Probability Distribution")) {
            this.jTextFieldNumberOfBins.setEnabled(false);
            this.jTextFieldNumberOfSamples.setEnabled(false);
        } else {
            this.jTextFieldNumberOfBins.setEnabled(true);
            this.jTextFieldNumberOfSamples.setEnabled(true);
        }
    }

    private void jButtonGenerateGraphActionPerformed(ActionEvent evt) {
        int option;
        this.generateGraph();
        if (this.jComboBoxSelectGraphGenerated.getSelectedIndex() != 0 && (option = JOptionPane.showConfirmDialog(null, "would you like to see the report of the generated data?", "Atention", 0)) == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
            DatasetCreator.getAnalysis().updateVariables();
            this.generateReport();
        }
    }

    private void jTextFieldNumberOfBinsActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldNumberOfSamplesActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldMaximumValueActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxSelectProbabilityDistrubutionActionPerformed(ActionEvent evt) {
        if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Exponential")) {
            this.refreshScreen(this.jPanelExponential, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Normal")) {
            this.refreshScreen(this.jPanelNormal, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Erlang")) {
            this.refreshScreen(this.jPanelErlang, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("LogNormal")) {
            this.refreshScreen(this.jPanelLogNormal, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Geometric")) {
            this.refreshScreen(this.jPanelGeometric, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Pareto")) {
            this.refreshScreen(this.jPanelPareto, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Weibull")) {
            this.refreshScreen(this.jPanelWeibull, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Poisson")) {
            this.refreshScreen(this.jPanelPoisson, this.jPanelSelectable);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Empirical")) {
            this.refreshScreen(this.jPanelEmpirical, this.jPanelSelectable);
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            this.jTextFieldMaximumValue.setEnabled(false);
            this.jTextFieldMinimumValue.setEnabled(false);
            this.autorange = true;
        } else {
            this.jTextFieldMaximumValue.setEnabled(true);
            this.jTextFieldMinimumValue.setEnabled(true);
            this.autorange = false;
        }
    }

    private void jTextFieldReportVariaceActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportMinValueActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportRangeActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportMidRangeActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportMedianActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportCoeficientOfVariationActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportFirstQuartileActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportThirdQuartileActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportInterquartileIntervalActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportSkewnessActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldReportKurtoseActionPerformed(ActionEvent evt) {
    }

    private void jButtonExportFileReportActionPerformed(ActionEvent evt) {
        try {
            DatasetCreator.getAnalysis().exportReport(this.jTextFieldStatisticResume.getText());
            JOptionPane.showMessageDialog(null, "File saved", "Message", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid Path", "Error", 0);
        }
    }

    private void jButtonExportFileDataActionPerformed(ActionEvent evt) {
        try {
            DatasetCreator.getAnalysis().exportData(this.jTextFieldGeneratedData.getText());
            JOptionPane.showMessageDialog(null, "File saved", "Message", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid Path", "Error", 0);
        }
    }

    private void jButtonSelectOutputDataActionPerformed(ActionEvent evt) {
    }

    private void generateReport() {
        DataAnalyzer analisys = DatasetCreator.getAnalysis();
        this.jTextFieldReportMaxvalue.setText(analisys.getMaxValue() + "");
        this.jTextFieldReportMinValue.setText(analisys.getMinValue() + "");
        this.jTextFieldReportMean.setText(analisys.getMean() + "");
        this.jTextFieldReportRange.setText(analisys.getRange() + "");
        this.jTextFieldReportMidRange.setText(analisys.getMidRange() + "");
        this.jTextFieldReportMedian.setText(analisys.getMedian() + "");
        this.jTextFieldReportSTD.setText(analisys.getStd() + "");
        this.jTextFieldReportVariace.setText(analisys.getVariance() + "");
        this.jTextFieldReportCoeficientOfVariation.setText(analisys.getCoeficientOfVariation() + "");
        this.jTextFieldReportFirstQuartile.setText(analisys.getQ1() + "");
        this.jTextFieldReportThirdQuartile.setText(analisys.getQ3() + "");
        this.jTextFieldReportInterquartileInterval.setText(analisys.getInterquartileInterval() + "");
        analisys.updateKurtoiseSkewness();
        this.jTextFieldReportKurtose.setText(analisys.getKurtosis() + "");
        this.jTextFieldReportSkewness.setText(analisys.getSkewness() + "");
        this.jTextAreaDistributionFitting.setText(analisys.getStringKS());
    }

    private void generateGraph() {
        double maxValue = 0.0;
        double minValue = 0.0;
        double rate = 0.0;
        double variance = 0.0;
        double average = 0.0;
        double successProbability = 0.0;
        double scale = 0.0;
        double shapes = 0.0;
        int numSamples = 0;
        int numBins = 0;
        JPanel jpanel = null;
        try {
            maxValue = Double.parseDouble(this.jTextFieldMaximumValue.getText());
            minValue = Double.parseDouble(this.jTextFieldMinimumValue.getText());
            numBins = Integer.parseInt(this.jTextFieldNumberOfBins.getText());
            numSamples = Integer.parseInt(this.jTextFieldNumberOfSamples.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
            return;
        }
        if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Exponential")) {
            try {
                rate = Double.parseDouble(this.jPanelExponential.jTextFieldRate.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                return;
            }
            this.randomVariateGenerator = new ExponentialRandomVariateGenerator(minValue, maxValue, rate);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Normal")) {
            try {
                average = Double.parseDouble(this.jPanelNormal.jTextFieldAverage.getText());
                variance = Double.parseDouble(this.jPanelNormal.jTextFieldVariance.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                return;
            }
            this.randomVariateGenerator = new NormalRandomVariateGenerator(minValue, maxValue, average, variance);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("LogNormal")) {
            try {
                average = Double.parseDouble(this.jPanelLogNormal.jTextFieldAverage.getText());
                variance = Double.parseDouble(this.jPanelLogNormal.jTextFieldVariance.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                return;
            }
            this.randomVariateGenerator = new LogNormalRandomVariateGenerator(minValue, maxValue, average, variance);
        } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Erlang")) {
            try {
                rate = Double.parseDouble(this.jPanelErlang.jTextFieldRate.getText());
                shapes = Double.parseDouble(this.jPanelErlang.jTextFieldShape.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                return;
            }
            this.randomVariateGenerator = new ErlangRandomVariateGenerator(minValue, maxValue, rate, (int)shapes);
        } else {
            if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Geometric")) {
                try {
                    successProbability = Double.parseDouble(this.jPanelGeometric.jTextFieldSucessProbability.getText());
                    this.randomVariateGenerator = new GeometricRandomVariateGenerator(minValue, maxValue, successProbability);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                    return;
                }
                catch (IllegalArgumentException ex1) {
                    JOptionPane.showMessageDialog(null, ex1.getMessage(), "Error", 0);
                    return;
                }
            }
            if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Pareto")) {
                try {
                    scale = Double.parseDouble(this.jPanelPareto.jTextFieldScale.getText());
                    shapes = Double.parseDouble(this.jPanelPareto.jTextFieldShape.getText());
                    if (minValue != scale) {
                        JOptionPane.showMessageDialog(null, "The minimum value has been altered", "Information", 1);
                        this.jTextFieldMinimumValue.setText(scale + "");
                        minValue = scale;
                    }
                    this.randomVariateGenerator = new ParetoRandomVariateGenerator(minValue, maxValue, shapes, scale);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                    return;
                }
                catch (IllegalArgumentException ex1) {
                    JOptionPane.showMessageDialog(null, ex1.getMessage(), "Error", 0);
                    return;
                }
            }
            if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Weibull")) {
                try {
                    scale = Double.parseDouble(this.jPanelWeibull.jTextFieldScale.getText());
                    shapes = Double.parseDouble(this.jPanelWeibull.jTextFieldShape.getText());
                    this.randomVariateGenerator = new WeibullRandomVariateGenerator(minValue, maxValue, shapes, scale);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                    return;
                }
                catch (IllegalArgumentException ex1) {
                    JOptionPane.showMessageDialog(null, ex1.getMessage(), "Error", 0);
                    return;
                }
            }
            if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Poisson")) {
                try {
                    rate = Double.parseDouble(this.jPanelPoisson.jTextFieldRate.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "Please insert a number", "Error", 0);
                    return;
                }
                this.randomVariateGenerator = new PoissonRandomVariateGenerator(minValue, maxValue, rate);
            } else if (this.jComboBoxSelectProbabilityDistrubution.getSelectedItem().equals("Empirical")) {
                EmpiricalLoader loader = new EmpiricalLoader(numBins);
                String path = this.jPanelEmpirical.jTextFieldLoadFileEmpirical.getText();
                try {
                    loader.load(new File(path));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Something is Wrong with the file", "Error", 0);
                    return;
                }
                if (loader.getProbabilityDensityFunction().length != numBins) {
                    JOptionPane.showMessageDialog(null, "The number of bins must be equal to number of empirical classes, in this case " + loader.getProbabilityDensityFunction(), "Message", 1);
                    this.jTextFieldNumberOfBins.setText(loader.getProbabilityDensityFunction().length + "");
                    numBins = loader.getProbabilityDensityFunction().length;
                }
                this.randomVariateGenerator = new EmpiricalRandomVariateGenerator(minValue, maxValue, 0, loader);
            }
        }
        jpanel = this.jComboBoxSelectGraphGenerated.getSelectedItem().equals("Probability Distribution") ? this.facade.createChartProbabilityDistribution(this.randomVariateGenerator, numBins, this.autorange) : (this.jComboBoxSelectGraphGenerated.getSelectedItem().equals("Random Variates") ? this.facade.createChartRandomVariate(this.randomVariateGenerator, numBins, numSamples, this.autorange) : this.facade.createChartProbabilityDistributionAndRandomVariate(this.randomVariateGenerator, numBins, numSamples, this.autorange));
        this.refreshScreen(jpanel, this.jPanel1);
    }

    private void refreshScreen(JPanel jpanel, JPanel template) {
        jpanel.setSize(template.getSize());
        template.removeAll();
        template.setLayout(new BorderLayout());
        template.add(jpanel);
        template.updateUI();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new JFrameRandomVariateGenerator().setVisible(true);
            }
        });
    }
}

