/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.control;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.EmpiricalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import com.gcap.randomvariategenerator.control.DataAnalyzer;
import org.jfree.data.Range;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYDataset;

public class DatasetCreator {
    public static final DatasetCreator INSTANCE = new DatasetCreator();
    public static final DataAnalyzer analysis = new DataAnalyzer();

    public static DatasetCreator getInstance() {
        return INSTANCE;
    }

    public static DataAnalyzer getAnalysis() {
        return analysis;
    }

    public XYDataset getDataSet(RandomVariateGenerator randomVariateGenerator, int numBins, int maxSample, boolean sampleData) {
        analysis.reset();
        analysis.setRandomVariateGenerator(randomVariateGenerator);
        for (int i = 0; i < maxSample; ++i) {
            double numberGenerated = randomVariateGenerator.generateRandomNumber();
            analysis.update(numberGenerated);
        }
        HistogramDataset dataset = new HistogramDataset();
        if (randomVariateGenerator instanceof EmpiricalRandomVariateGenerator) {
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        } else if (!randomVariateGenerator.isDiscrete()) {
            dataset.setType(HistogramType.SCALE_AREA_TO_1);
        } else {
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        }
        if (randomVariateGenerator.isDiscrete()) {
            numBins = (int)(analysis.getMaxValue() - analysis.getMinValue() + 1.0);
        }
        double[] arrayDouble = new double[analysis.getSamples()];
        for (int i = 0; i < arrayDouble.length; ++i) {
            arrayDouble[i] = analysis.getVectorSamples().get(i);
        }
        dataset.addSeries((Comparable)((Object)"Histogram"), arrayDouble, numBins);
        return dataset;
    }

    public Range getRange(RandomVariateGenerator randomVariateGenerator) {
        XYDataset datasetTemp = DatasetCreator.getInstance().getDataSet(randomVariateGenerator, 1, 100000, false);
        return DatasetUtilities.findDomainBounds((XYDataset)datasetTemp);
    }

    public XYDataset getDataSet(RandomVariateGenerator randomVariateGenerator, int numberOfBins) {
        XYDataset result = null;
        analysis.setRandomVariateGenerator(randomVariateGenerator);
        if (randomVariateGenerator.isDiscrete()) {
            numberOfBins = (int)(randomVariateGenerator.getMaxValue() - randomVariateGenerator.getMinValue() + 1.0);
        }
        result = DatasetUtilities.sampleFunction2D((Function2D)randomVariateGenerator, (double)randomVariateGenerator.getMinValue(), (double)randomVariateGenerator.getMaxValue(), (int)(randomVariateGenerator.isDiscrete() ? numberOfBins : 1000), (Comparable)((Object)"Probability Distribution Function"));
        return result;
    }
}

