/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.control;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.EmpiricalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ErlangRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ExponentialRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.LogNormalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.NormalRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ParetoRandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.WeibullRandomVariateGenerator;
import com.gcap.randomvariategenerator.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAnalyzer {
    private double minValue;
    private double maxValue;
    private double sum;
    private int samples;
    private double mean;
    private double range;
    private double midRange;
    private ArrayList<Double> vectorSamples;
    private double std;
    private double sampleSquareSum;
    private double median;
    private double Q1;
    private double Q3;
    private double interquartilInterval;
    private double kurtosis;
    private double skewness;
    private double coeficientOfVariation;
    private double variance;
    private RandomVariateGenerator randomVariateGenerator = null;
    private String ksString = "";

    public DataAnalyzer() {
        this.reset();
    }

    public double getQ1() {
        return this.Q1;
    }

    public double getQ3() {
        return this.Q3;
    }

    public String getStringKS() {
        return this.ksString;
    }

    public void setRandomVariateGenerator(RandomVariateGenerator randomVariateGenerator) {
        this.randomVariateGenerator = randomVariateGenerator;
    }

    public double getCoeficientOfVariation() {
        return this.coeficientOfVariation;
    }

    public double getInterquartileInterval() {
        return this.interquartilInterval;
    }

    public double getKurtosis() {
        return this.kurtosis;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMidRange() {
        return this.midRange;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getRange() {
        return this.range;
    }

    public int getSamples() {
        return this.samples;
    }

    public double getSkewness() {
        return this.skewness;
    }

    public double getStd() {
        return this.std;
    }

    public double getSum() {
        return this.sum;
    }

    public double getVariance() {
        return this.variance;
    }

    public ArrayList<Double> getVectorSamples() {
        return this.vectorSamples;
    }

    public void reset() {
        this.minValue = 2.147483647E9;
        this.maxValue = -2.147483648E9;
        this.sum = 0.0;
        this.samples = 0;
        this.mean = 0.0;
        this.range = 0.0;
        this.vectorSamples = new ArrayList();
        this.std = Double.NaN;
        this.sampleSquareSum = 0.0;
        this.midRange = 0.0;
        this.median = 0.0;
        this.Q1 = 0.0;
        this.Q3 = 0.0;
        this.interquartilInterval = 0.0;
        this.kurtosis = 0.0;
        this.skewness = 0.0;
        this.coeficientOfVariation = 0.0;
        this.variance = 0.0;
        this.ksString = "";
    }

    public void update(double value) {
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
        this.sum += value;
        ++this.samples;
        this.vectorSamples.add(new Double(value));
        this.sampleSquareSum += value * value;
    }

    public void updateVariables() {
        this.updateMean();
        this.updateStd();
        this.updateVariance();
        this.updateCoeficientOfVariation();
        this.updateMidRange();
        this.updateMedianAndQuartiles();
        this.updateRange();
        this.updateKurtoiseSkewness();
    }

    public void updateMean() {
        this.mean = this.sum / (double)this.samples;
    }

    public void updateRange() {
        this.range = this.maxValue - this.minValue;
    }

    public void updateStd() {
        double sampleSumSquare = this.sum * this.sum;
        this.std = Math.sqrt((this.sampleSquareSum - sampleSumSquare / (double)this.samples) / (double)(this.samples - 1));
    }

    public void updateVariance() {
        this.variance = this.std * this.std;
    }

    public void updateCoeficientOfVariation() {
        this.coeficientOfVariation = Double.NaN;
        if (this.mean != 0.0) {
            this.coeficientOfVariation = this.getStd() / this.getMean();
        }
    }

    public void updateMidRange() {
        this.midRange = (this.maxValue + this.minValue) / 2.0;
    }

    public void updateMedianAndQuartiles() {
        int itemCount = this.samples;
        ArrayList<Double> copy = new ArrayList<Double>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            copy.add(i, this.vectorSamples.get(i));
        }
        Collections.sort(copy);
        if (!this.randomVariateGenerator.isDiscrete()) {
            if (this.randomVariateGenerator instanceof EmpiricalRandomVariateGenerator) {
                ((EmpiricalRandomVariateGenerator)this.randomVariateGenerator).updateCumulativeDistributionFunction();
            }
            this.kolmogorovSmirnovTest(copy);
        }
        int count = copy.size();
        this.median = this.calculateMedian(copy, 0, count - 1);
        this.updateQ1(copy);
        this.updateQ3(copy);
        this.interquartilInterval = this.Q3 - this.Q1;
    }

    public void updateKurtoiseSkewness() {
        double m3 = 0.0;
        double m4 = 0.0;
        double deviation = 0.0;
        this.kurtosis = Double.NaN;
        this.skewness = Double.NaN;
        for (Double d : this.getVectorSamples()) {
            deviation = d - this.getMean();
            m3 += Math.pow(deviation, 3.0);
            m4 += Math.pow(deviation, 4.0);
        }
        double var = this.getVariance();
        double stdDev = this.getStd();
        if (var != 0.0) {
            this.skewness = m3 / ((double)this.getSamples() * var * stdDev);
            this.kurtosis = m4 / ((double)this.getSamples() * var * var) - 3.0;
        }
    }

    public void updateQ1(List values) {
        this.Q1 = Double.NaN;
        int count = values.size();
        if (count > 0) {
            this.Q1 = count % 2 == 1 ? (count > 1 ? this.calculateMedian(values, 0, count / 2) : this.calculateMedian(values, 0, 0)) : this.calculateMedian(values, 0, count / 2 - 1);
        }
    }

    public void updateQ3(List values) {
        this.Q3 = Double.NaN;
        int count = values.size();
        if (count > 0) {
            this.Q3 = count % 2 == 1 ? (count > 1 ? this.calculateMedian(values, count / 2, count - 1) : this.calculateMedian(values, 0, 0)) : this.calculateMedian(values, count / 2, count - 1);
        }
    }

    public void exportReport(String path) {
        Writer writer = new Writer(path);
        writer.println("Samples: \t\t" + this.samples);
        writer.println("Min Value: \t\t" + this.minValue);
        writer.println("Max Value: \t\t" + this.maxValue);
        writer.println("Sum: \t\t\t" + this.sum);
        writer.println("Mean: \t\t\t" + this.mean);
        writer.println("Range: \t\t\t" + this.range);
        writer.println("Standard Deviation:\t" + this.std);
        writer.println("Variance:\t\t" + this.variance);
        writer.println("Midrange :\t\t" + this.midRange);
        writer.println("Median :\t\t" + this.median);
        writer.println("First Quartile:\t\t" + this.Q1);
        writer.println("Third Quartile:\t\t" + this.Q3);
        writer.println("Interquartile Interval:\t" + this.interquartilInterval);
        writer.println("Kurtosis: \t\t" + this.kurtosis);
        writer.println("Skewness: \t\t" + this.skewness);
        writer.println("Coeficient variation:\t" + this.coeficientOfVariation);
        writer.println("\n\n" + this.getStringKS());
        writer.close();
    }

    public void exportData(String path) {
        Writer writer = new Writer(path);
        for (int i = 0; i < this.samples; ++i) {
            writer.println(this.vectorSamples.get(i));
        }
        writer.close();
    }

    public double calculateMedian(List values, int start, int end) {
        double result = Double.NaN;
        int count = end - start + 1;
        if (count > 0) {
            if (count % 2 == 1) {
                if (count > 1) {
                    Number value = (Number)values.get(start + (count - 1) / 2);
                    result = value.doubleValue();
                } else {
                    Number value = (Number)values.get(start);
                    result = value.doubleValue();
                }
            } else {
                Number value1 = (Number)values.get(start + count / 2 - 1);
                Number value2 = (Number)values.get(start + count / 2);
                result = (value1.doubleValue() + value2.doubleValue()) / 2.0;
            }
        }
        return result;
    }

    private double kolmogorovSmirnovTest(List orderedValues) {
        double result = 0.0;
        double dMaximum = Double.MIN_VALUE;
        double numberOfSamples = this.samples;
        String consequence = "";
        int i = 1;
        while ((double)i < numberOfSamples) {
            double cumulative = this.randomVariateGenerator.getCumulativeDistributionFunction((Double)orderedValues.get(i));
            double dLeft = Math.abs((double)i / numberOfSamples - cumulative);
            double dRigth = Math.abs(cumulative - (double)(i - 1) / numberOfSamples);
            dMaximum = Math.max(dLeft, dMaximum);
            dMaximum = Math.max(dRigth, dMaximum);
            ++i;
        }
        result = dMaximum * (Math.sqrt(numberOfSamples) + 0.12 + 0.11 / Math.sqrt(numberOfSamples));
        this.ksString = "KOLMOGOROV-SMIRNOV GOODNESS-OF-FIT TEST                      \n";
        this.ksString = this.ksString + "NULL HYPOTHESIS H0:      DISTRIBUTION FITS THE DATA          \n";
        this.ksString = this.ksString + "ALTERNATE HYPOTHESIS HA: DISTRIBUTION DOES NOT FIT THE DATA  \n";
        this.ksString = this.ksString + "NUMBER OF OBSERVATIONS   =  " + numberOfSamples + "\n";
        if (this.randomVariateGenerator instanceof NormalRandomVariateGenerator) {
            this.ksString = this.ksString + "NORMAL DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof ErlangRandomVariateGenerator) {
            this.ksString = this.ksString + "ERLANG DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof LogNormalRandomVariateGenerator) {
            this.ksString = this.ksString + "LOGNORMAL DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof ExponentialRandomVariateGenerator) {
            this.ksString = this.ksString + "EXPONENTIAL DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof ParetoRandomVariateGenerator) {
            this.ksString = this.ksString + "PARETO DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof EmpiricalRandomVariateGenerator) {
            this.ksString = this.ksString + "EMPIRICAL DISTRIBUTION ";
        } else if (this.randomVariateGenerator instanceof WeibullRandomVariateGenerator) {
            this.ksString = this.ksString + "WEIBULL DISTRIBUTION ";
        }
        this.ksString = this.ksString + "\n";
        this.ksString = this.ksString + "TEST:                                                        \n";
        this.ksString = this.ksString + "KOLMOGOROV-SMIRNOV TEST (STATISTIC) =" + result + "\n";
        this.ksString = this.ksString + "    ALPHA LEVEL         CUTOFF              CONCLUSION       \n";
        String string1 = "ACCEPT H0";
        String string2 = "ACCEPT H0";
        String string3 = "ACCEPT H0";
        String string4 = "ACCEPT H0";
        String stringRejected = "REJECT H0";
        if (result > 1.224) {
            string1 = stringRejected;
        } else {
            consequence = "THERE IS NO EVIDENCE TO REJECT H0 WITH 90% OF CONFIDENCE\n";
        }
        if (result > 1.385) {
            string2 = stringRejected;
        } else if (consequence.equals("")) {
            consequence = "THERE IS NO EVIDENCE TO REJECT H0 WITH 95% OF CONFIDENCE\n";
        }
        if (result > 1.48) {
            string3 = stringRejected;
        } else if (consequence.equals("")) {
            consequence = "THERE IS NO EVIDENCE TO REJECT H0 WITH 97.5% OF CONFIDENCE\n";
        }
        if (result > 1.626) {
            string4 = stringRejected;
            consequence = "THERE IS EVIDENCE TO REJECT H0 WITH MORE THAN 99% OF CONFIDENCE\n";
        } else if (consequence.equals("")) {
            consequence = "THERE IS NO EVIDENCE TO REJECT H0 WITH 99% OF CONFIDENCE\n";
        }
        this.ksString = this.ksString + "         10%            1.224               " + string1 + "\n";
        this.ksString = this.ksString + "          5%            1.358               " + string2 + "\n";
        this.ksString = this.ksString + "        2.5%            1.480               " + string3 + "\n";
        this.ksString = this.ksString + "          1%            1.626               " + string4 + "\n";
        this.ksString = this.ksString + "\nCONCLUSION: \n" + consequence;
        return result;
    }
}

