/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.ExponentialRandomVariateGenerator;
import com.gcap.randomvariategenerator.util.Util;

public class ErlangRandomVariateGenerator
extends ExponentialRandomVariateGenerator {
    private int shapes = 0;

    public ErlangRandomVariateGenerator(double minValue, double maxValue, double rate, int shapes) {
        super(minValue, maxValue, rate);
        this.shapes = shapes;
    }

    public double generateRandomNumber() {
        double sum = 0.0;
        for (int i = 0; i < this.shapes; ++i) {
            sum += super.generateRandomNumber();
        }
        return sum;
    }

    public double getValue(double x) {
        double result = 0.0;
        if (x < 0.0) {
            throw new IllegalArgumentException("The Argument must be bigger than 0");
        }
        double rate = this.getRateParameter();
        result = Math.pow(rate, this.shapes - 1) * Math.pow(x, this.shapes - 1) * super.getValue(x) / (double)Util.factorial(this.shapes - 1);
        return result;
    }

    public double getCumulativeDistributionFunction(double x) {
        double cdf = 0.0;
        double rate = this.getRateParameter();
        double numShapes = this.shapes;
        for (double i = 0.0; i < numShapes; i += 1.0) {
            double factorial = Util.factorial((int)i);
            cdf += Math.exp(-rate * x) * Math.pow(rate * x, i) / factorial;
        }
        cdf = 1.0 - cdf;
        return cdf;
    }
}

