/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.EmpiricalLoader;
import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import java.util.ArrayList;
import java.util.Collections;

public class EmpiricalRandomVariateGenerator
extends RandomVariateGenerator {
    protected double[] cdf;
    private double[] pdf;
    ArrayList<Double> array;
    protected int interpolationType;
    private EmpiricalLoader loader;
    public static final int LINEAR_INTERPOLATION = 0;
    public static final int NO_INTERPOLATION = 1;

    public EmpiricalRandomVariateGenerator(double minValue, double maxValue, int interpolationType, EmpiricalLoader loader) {
        super(minValue, maxValue);
        int ptn;
        if (interpolationType != 0 && interpolationType != 1) {
            throw new IllegalArgumentException("Illegal Interpolation Type");
        }
        this.interpolationType = interpolationType;
        this.loader = loader;
        this.pdf = loader.getProbabilityDensityFunction();
        if (this.pdf == null || this.pdf.length == 0) {
            this.cdf = null;
            return;
        }
        int nBins = this.pdf.length;
        this.cdf = new double[nBins + 1];
        this.cdf[0] = 0.0;
        for (ptn = 0; ptn < nBins; ++ptn) {
            double prob = this.pdf[ptn];
            if (prob < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[ptn + 1] = this.cdf[ptn] + prob;
        }
        if (this.cdf[nBins] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        ptn = 0;
        while (ptn < nBins + 1) {
            int n = ptn++;
            this.cdf[n] = this.cdf[n] / this.cdf[nBins];
        }
    }

    public double generateRandomNumber() {
        double rand = Math.random();
        if (this.cdf == null) {
            return rand;
        }
        int nBins = this.cdf.length - 1;
        int nbelow = 0;
        int nabove = nBins;
        while (nabove > nbelow + 1) {
            int middle = nabove + nbelow + 1 >> 1;
            if (rand >= this.cdf[middle]) {
                nbelow = middle;
                continue;
            }
            nabove = middle;
        }
        if (this.interpolationType == 1) {
            return (double)nbelow / (double)nBins;
        }
        if (this.interpolationType == 0) {
            double binMeasure = this.cdf[nabove] - this.cdf[nbelow];
            if (binMeasure == 0.0) {
                return ((double)nbelow + 0.5) / (double)nBins;
            }
            double binFraction = (rand - this.cdf[nbelow]) / binMeasure;
            double temp = (double)nbelow + binFraction;
            double delta = (this.loader.getDataAnalizer().getMaxValue() - this.loader.getDataAnalizer().getMinValue()) / new Double(this.loader.getBinCount());
            temp = temp * delta + this.loader.getDataAnalizer().getMinValue();
            return temp;
        }
        throw new InternalError();
    }

    public boolean isDiscrete() {
        return this.interpolationType == 1;
    }

    public double getValue(double x) {
        double delta = (this.loader.getDataAnalizer().getMaxValue() - this.loader.getDataAnalizer().getMinValue()) / new Double(this.loader.getBinCount());
        return this.pdf[Math.max((int)Math.ceil((x - this.loader.getDataAnalizer().getMinValue()) / delta) - 1, 0)];
    }

    public double getCumulativeDistributionFunction(double x) {
        double result = 0.0;
        int nbelow = 0;
        int nabove = this.array.size();
        int middle = 0;
        while (nabove > nbelow + 1) {
            middle = nabove + nbelow + 1 >> 1;
            if (x >= this.array.get(middle)) {
                nbelow = middle;
                continue;
            }
            nabove = middle;
        }
        result = middle;
        return result /= (double)this.array.size();
    }

    public void updateCumulativeDistributionFunction() {
        this.array = this.loader.getDataAnalizer().getVectorSamples();
        Collections.sort(this.array);
    }
}

