/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.tokengame;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Timer;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.modcs.tools.spn.simulator.tokengame.TransitionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsBlinker
implements MouseListener,
ActionListener {
    private ArrayList<CellView> cells = new ArrayList();
    private JGraph graph = null;
    private boolean mEntered = false;
    private Color blinkColor;
    private Color originalColor;
    private int currentColor = 1;
    private TransitionListener listener;
    private Timer timer = new Timer(400, this);

    public ComponentsBlinker(JGraph graph, ArrayList<CellView> blinkCells, TransitionListener listener) {
        this.blinkColor = graph.getHighlightColor();
        this.graph = graph;
        this.listener = listener;
        this.cells = blinkCells;
        this.originalColor = GraphConstants.getBorderColor((Map)blinkCells.get(0).getAllAttributes());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.blink();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.mEntered) {
            for (CellView cv : this.cells) {
                Rectangle2D ret = GraphConstants.getBounds((Map)cv.getAllAttributes());
                if (!ret.contains(e.getPoint())) continue;
                this.stop();
                this.listener.transitionFired(cv);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mEntered = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mEntered = false;
    }

    private void blink() {
        for (CellView cv : this.cells) {
            DefaultGraphCell c = (DefaultGraphCell)cv.getCell();
            if (this.currentColor == 1) {
                GraphConstants.setBorderColor((Map)c.getAttributes(), (Color)this.blinkColor);
            } else {
                GraphConstants.setBorderColor((Map)c.getAttributes(), (Color)this.originalColor);
            }
            GraphLayoutCache gLC = this.graph.getGraphLayoutCache();
            gLC.editCell((Object)c, (Map)c.getAttributes());
        }
        this.currentColor = this.currentColor == 1 ? 2 : 1;
    }

    public void reload(ArrayList<CellView> blinkCells) {
        this.stop();
        this.cells = blinkCells;
        this.start();
    }

    public void start() {
        if (this.timer.isRunning()) {
            return;
        }
        this.graph.addMouseListener((MouseListener)this);
        this.timer.start();
    }

    public void stop() {
        if (!this.timer.isRunning()) {
            return;
        }
        this.timer.stop();
        this.graph.removeMouseListener((MouseListener)this);
        for (CellView cv : this.cells) {
            DefaultGraphCell c = (DefaultGraphCell)cv.getCell();
            GraphConstants.setBorderColor((Map)c.getAttributes(), (Color)this.originalColor);
            GraphLayoutCache gLC = this.graph.getGraphLayoutCache();
            gLC.editCell((Object)c, (Map)c.getAttributes());
        }
        this.currentColor = 1;
    }
}

