/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.randomvariates;

import org.modcs.tools.spn.simulator.randomvariates.RandomVariateGenerator;

public class NormalRandomVariateGenerator
implements RandomVariateGenerator {
    public double average;
    public double variance;
    public double standardDeviation;
    private double saved;
    private boolean isSaved;

    public NormalRandomVariateGenerator(double average, double variance) {
        this(variance);
        this.average = average;
    }

    public NormalRandomVariateGenerator(double variance) {
        this.variance = variance;
        this.standardDeviation = Math.sqrt(this.variance);
        this.saved = 0.0;
        this.isSaved = false;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public double generateRandomNumber(double delay) {
        double u = 0.0;
        double v = 0.0;
        double w = 0.0;
        double result = 0.0;
        this.setAverage(delay);
        if (this.isSaved) {
            result = this.saved;
            this.isSaved = false;
        } else {
            while ((w = (u = 2.0 * Math.random() - 1.0) * u + (v = 2.0 * Math.random() - 1.0) * v) > 1.0) {
            }
            w = Math.sqrt(-2.0 * Math.log(w) / w);
            this.saved = u * w * this.standardDeviation + this.average;
            this.isSaved = true;
            result = v * w * this.standardDeviation + this.average;
        }
        if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public double getValue(double x) {
        return Math.exp(-1.0 * (x - this.average) * (x - this.average) / (2.0 * this.standardDeviation * this.standardDeviation)) / Math.sqrt(Math.PI * 2 * this.standardDeviation * this.standardDeviation);
    }

    public boolean isDiscrete() {
        return false;
    }

    public double getDelay() {
        return this.average;
    }

    public double getVariance() {
        return this.variance;
    }

    public boolean isIsSaved() {
        return this.isSaved;
    }

    public void setIsSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    public double getSaved() {
        return this.saved;
    }

    public void setSaved(double saved) {
        this.saved = saved;
    }
}

