/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.randomvariates;

import java.util.Random;
import org.modcs.tools.spn.simulator.randomvariates.RandomVariateGenerator;

public class ExponentialRandomVariateGenerator
implements RandomVariateGenerator {
    private double rateParameter;
    private Random random;
    private static final ExponentialRandomVariateGenerator INSTANCE = new ExponentialRandomVariateGenerator();

    public double getRateParameter() {
        return this.rateParameter;
    }

    public static ExponentialRandomVariateGenerator getInstance(double rate) {
        INSTANCE.setRateParameter(rate);
        return INSTANCE;
    }

    public void restartSeed() {
        this.random = new Random(System.currentTimeMillis());
    }

    public void restartSeed(long value) {
        this.random = new Random(value);
    }

    public static ExponentialRandomVariateGenerator getInstance() {
        return INSTANCE;
    }

    public void setRateParameter(double rateParameter) {
        this.rateParameter = rateParameter;
    }

    public ExponentialRandomVariateGenerator(double rate) {
        this.rateParameter = rate;
        this.random = new Random(System.currentTimeMillis());
    }

    public ExponentialRandomVariateGenerator() {
        this(0.0);
    }

    public double generateRandomNumber(double delay) {
        this.rateParameter = 1.0 / delay;
        double result = -(Math.log(1.0 - Math.random()) / this.rateParameter);
        return result;
    }

    public double getValue(double x) {
        return this.rateParameter * Math.pow(Math.E, -(this.rateParameter * x));
    }

    public boolean isDiscrete() {
        return false;
    }

    public double getDelay() {
        return 1.0 / this.rateParameter;
    }
}

