/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.entities;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.model.Arc;
import org.modcs.tools.spn.model.ArcInhibitor;
import org.modcs.tools.spn.model.ArcInput;
import org.modcs.tools.spn.model.ArcOutput;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.model.EDSPN;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.MarkingParameter;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.RaceType;
import org.modcs.tools.spn.model.RewardMeasure;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.TransitionImmediate;
import org.modcs.tools.spn.model.expressions.IfElseExpression;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelGenerator
implements InterfaceModelGenerator {
    private Scanner scanner;
    private static EDSPN edspn;
    private File file;

    private void expectSentence(String text) throws Exception {
        if (!this.scanner.next().equals(text)) {
            throw new Exception("Error generateModel: " + text);
        }
    }

    public ModelGenerator(File file) {
        this.file = file;
    }

    public static EDSPN getEdspn() {
        return edspn;
    }

    public ArrayList<MarkingParameter> getMarkingParameters(int numberMarkingParameters) throws Exception {
        ArrayList<MarkingParameter> markingParameters = new ArrayList<MarkingParameter>(numberMarkingParameters);
        for (int i = 0; i < numberMarkingParameters; ++i) {
            this.expectSentence("MARKPAR");
            String name = this.scanner.next();
            int value = this.scanner.nextInt();
            double xPos = Double.parseDouble(this.scanner.next());
            double yPos = Double.parseDouble(this.scanner.next());
            this.scanner.nextLine();
            Point2D.Double point2D = new Point2D.Double(xPos, yPos);
            markingParameters.add(new MarkingParameter(name, value));
        }
        return markingParameters;
    }

    public ArrayList<Place> getPlaces(int numberPlaces) throws Exception {
        ArrayList<Place> places = new ArrayList<Place>(numberPlaces);
        for (int i = 0; i < numberPlaces; ++i) {
            this.expectSentence("PLACE");
            String name = this.scanner.next();
            String StringTemp = this.scanner.next();
            int initialMarking = 0;
            try {
                initialMarking = Integer.parseInt(StringTemp);
            }
            catch (NumberFormatException numberFormatException) {
                ArrayList<MarkingParameter> ArrayMarking = edspn.getMarkingParameters();
                MarkingParameter markingParameter = ArrayMarking.get(ArrayMarking.indexOf(new MarkingParameter(StringTemp, 0)));
                initialMarking = markingParameter.getValue();
            }
            double xPos = Double.parseDouble(this.scanner.next());
            double yPos = Double.parseDouble(this.scanner.next());
            Point2D.Double positionPlace = new Point2D.Double(xPos, yPos);
            xPos = Double.parseDouble(this.scanner.next());
            yPos = Double.parseDouble(this.scanner.next());
            Point2D.Double positionTag = new Point2D.Double(xPos, yPos);
            places.add(new Place(name, initialMarking, positionPlace, positionTag));
            this.scanner.nextLine();
        }
        return places;
    }

    public ArrayList<DelayParameter> getDelayParameters(int numberDelayParameters) throws Exception {
        ArrayList<DelayParameter> delayParameters = new ArrayList<DelayParameter>(numberDelayParameters);
        for (int i = 0; i < numberDelayParameters; ++i) {
            double value = 0.0;
            this.expectSentence("DELAYPAR");
            String name = this.scanner.next();
            String valueString = this.scanner.next();
            value = Double.parseDouble(valueString);
            double xPos = Double.parseDouble(this.scanner.next());
            double yPos = Double.parseDouble(this.scanner.next());
            Point2D.Double point2D = new Point2D.Double(xPos, yPos);
            delayParameters.add(new DelayParameter(name, value, point2D));
            this.scanner.nextLine();
        }
        return delayParameters;
    }

    public ArrayList<ArcInput> getArcInputs(int numberArcInput) throws Exception {
        ArrayList<ArcInput> arcInputs = new ArrayList<ArcInput>(numberArcInput);
        for (int arcIndex = 0; arcIndex < numberArcInput; ++arcIndex) {
            String stringMultiplicity = this.scanner.next();
            int multiplicity = 0;
            if (!stringMultiplicity.equals("<MD>")) {
                multiplicity = Integer.parseInt(stringMultiplicity);
            }
            String placeName = this.scanner.next();
            ArrayList<Place> places = edspn.getPlaces();
            Place place = places.get(places.indexOf(new Place(placeName, 0)));
            arcInputs.add(new ArcInput(place, multiplicity));
            int points = this.scanner.nextInt();
            this.scanner.nextLine();
            for (int i = 0; i < points; ++i) {
                this.scanner.nextLine();
            }
        }
        return arcInputs;
    }

    public ArrayList<ArcOutput> getArcOutputs(int numberArcOutout) throws Exception {
        ArrayList<ArcOutput> arcOutputs = new ArrayList<ArcOutput>(numberArcOutout);
        for (int arcIndex = 0; arcIndex < numberArcOutout; ++arcIndex) {
            String stringMultiplicity = this.scanner.next();
            int multiplicity = 0;
            if (!stringMultiplicity.equals("<MD>")) {
                multiplicity = Integer.parseInt(stringMultiplicity);
            }
            String placeName = this.scanner.next();
            ArrayList<Place> places = edspn.getPlaces();
            Place place = places.get(places.indexOf(new Place(placeName, 0)));
            arcOutputs.add(new ArcOutput(place, multiplicity));
            int points = this.scanner.nextInt();
            this.scanner.nextLine();
            for (int i = 0; i < points; ++i) {
                this.scanner.nextLine();
            }
        }
        return arcOutputs;
    }

    private ArrayList<ArcInhibitor> getArcInhibitor(int numberArcInhibit) {
        ArrayList<ArcInhibitor> arcInhibitors = new ArrayList<ArcInhibitor>(numberArcInhibit);
        for (int arcIndex = 0; arcIndex < numberArcInhibit; ++arcIndex) {
            int multiplicity = this.scanner.nextInt();
            String placeName = this.scanner.next();
            ArrayList<Place> places = edspn.getPlaces();
            Place place = places.get(places.indexOf(new Place(placeName, 0)));
            arcInhibitors.add(new ArcInhibitor(place, multiplicity));
            int points = this.scanner.nextInt();
            this.scanner.nextLine();
            for (int i = 0; i < points; ++i) {
                this.scanner.nextLine();
            }
        }
        return arcInhibitors;
    }

    public ArrayList<Transition> getTransitions(int numberTransitions) throws Exception {
        ArrayList<Transition> transitions = new ArrayList<Transition>(numberTransitions);
        for (int i = 0; i < numberTransitions; ++i) {
            this.expectSentence("TRANSITION");
            String name = this.scanner.next();
            String stringTemp = this.scanner.next();
            double delay = 1.0;
            if (!stringTemp.equals("<MD>")) {
                try {
                    delay = Double.parseDouble(stringTemp);
                }
                catch (NumberFormatException numberFormatException) {
                    ArrayList<DelayParameter> delayParameters = edspn.getDelayParameters();
                    DelayParameter delayParameter = delayParameters.get(delayParameters.indexOf(new DelayParameter(stringTemp, 0.0)));
                    delay = delayParameter.getValue();
                }
            }
            FiringPolicy firingPolicy = null;
            String firingType = this.scanner.next();
            if (firingType.equals("SS")) {
                firingPolicy = FiringPolicy.SINGLE_SERVER;
            } else if (firingType.equals("IS")) {
                firingPolicy = FiringPolicy.INFINITY_SERVER;
            } else {
                throw new Exception("Error: Server policy not exist");
            }
            String kind = this.scanner.next();
            RaceType raceType = null;
            String race = this.scanner.next();
            if (race.equals("RS")) {
                raceType = RaceType.RACE_WITH_RESAMPLING;
            } else if (race.equals("RA")) {
                raceType = RaceType.RACE_WITH_AGE_MEMORY;
            } else if (race.equals("RE")) {
                raceType = RaceType.RACE_WITH_ENABLING_MEMORY;
            } else {
                throw new Exception("Error: Race Type not exist");
            }
            String stringPriority = this.scanner.next();
            int priority = Integer.parseInt(stringPriority);
            String orientation = this.scanner.next();
            String phase = this.scanner.next();
            String group = this.scanner.next();
            String groupWheight = this.scanner.next();
            double xPos = Double.parseDouble(this.scanner.next());
            double yPos = Double.parseDouble(this.scanner.next());
            Point2D.Double positionTrans = new Point2D.Double(xPos, yPos -= 0.35);
            xPos = Double.parseDouble(this.scanner.next());
            yPos = Double.parseDouble(this.scanner.next());
            Point2D.Double positionTag = new Point2D.Double(xPos, yPos -= 0.35);
            this.scanner.nextLine();
            this.expectSentence("INPARCS");
            int numberArcInput = this.scanner.nextInt();
            ArrayList<ArcInput> arcInputs = this.getArcInputs(numberArcInput);
            this.expectSentence("OUTPARCS");
            int numberArcOutput = this.scanner.nextInt();
            ArrayList<ArcOutput> arcOutputs = this.getArcOutputs(numberArcOutput);
            this.expectSentence("INHARCS");
            int numberArcInhibit = this.scanner.nextInt();
            ArrayList<ArcInhibitor> arcInhibitors = this.getArcInhibitor(numberArcInhibit);
            if (kind.equals("EXP")) {
                ExponentialRandomVariateGenerator randomVariateGenerator = new ExponentialRandomVariateGenerator(1.0 / delay);
                TransitionExponential transitionExponential = new TransitionExponential(name, randomVariateGenerator, firingPolicy, raceType, arcInputs, arcOutputs, arcInhibitors, positionTrans, positionTag, delay);
                transitions.add(transitionExponential);
                continue;
            }
            if (kind.equals("IM")) {
                TransitionImmediate transitionImmediate = new TransitionImmediate(name, delay, firingPolicy, raceType, arcInputs, arcOutputs, arcInhibitors, positionTrans, positionTag, priority);
                transitions.add(transitionImmediate);
                continue;
            }
            throw new Exception("Error: Unkwon type transition");
        }
        return transitions;
    }

    private void updateTransitonEnablingFuntion(ArrayList<Transition> transitions) {
        String text = this.scanner.next();
        while (text.equals("FUNCTION")) {
            String transitionName = this.scanner.next();
            TransitionImmediate transition = (TransitionImmediate)transitions.get(transitions.indexOf(new TransitionImmediate(transitionName)));
            String logicCondition = this.scanner.nextLine();
            transition.setLogicCondition(logicCondition);
            text = this.scanner.next();
        }
    }

    private void updateDelayDependent(ArrayList<Transition> transitions) {
        String text = this.scanner.next();
        while (text.equals("EXP_DELAY")) {
            String transitionName = this.scanner.next();
            Transition transition = transitions.get(transitions.indexOf(new TransitionExponential(transitionName)));
            String delayExpression = this.scanner.next();
            delayExpression = Util.removeEndComand(delayExpression);
            transition.setDelayExpression(IfElseExpression.parse(delayExpression));
            text = this.scanner.next();
        }
    }

    private void updatePriorityDependent(ArrayList<Transition> transitions) {
        String text = this.scanner.next();
        while (text.equals("WEIGHT")) {
            String transitionName = this.scanner.next();
            Transition transition = transitions.get(transitions.indexOf(new TransitionImmediate(transitionName)));
            String delayExpression = this.scanner.next();
            delayExpression = Util.removeEndComand(delayExpression);
            transition.setDelayExpression(IfElseExpression.parse(delayExpression));
            text = this.scanner.next();
        }
    }

    private void updateArcsMultiplicty(ArrayList<Transition> transitions) {
        String text = this.scanner.next();
        while (text.equals("CARDINALITY")) {
            String arcType = this.scanner.next();
            String transName = this.scanner.next();
            String placeName = this.scanner.next();
            String ifExp = this.scanner.next();
            IfElseExpression ifElseExpression = IfElseExpression.parse(Util.removeEndComand(ifExp));
            if (ifElseExpression == null) {
                return;
            }
            block1: for (int i = 0; i < transitions.size(); ++i) {
                Transition transition = transitions.get(i);
                if (!transName.equals(transition.getName())) continue;
                ArrayList<Arc> arcs = null;
                if (arcType.equals("INPARC")) {
                    arcs = transition.getArcInputs();
                } else if (arcType.equals("OUTPARC")) {
                    arcs = transition.getArcOutputs();
                } else if (arcType.equals("INHARC")) {
                    arcs = transition.getArcInhibitors();
                }
                for (int j = 0; j < arcs.size(); ++j) {
                    Arc arc = arcs.get(j);
                    if (!arc.getPlace().getName().equals(placeName)) continue;
                    arc.setMultiplicityExpression(ifElseExpression);
                    break block1;
                }
                break;
            }
            text = this.scanner.next();
        }
    }

    private ArrayList<RewardMeasure> getRewardMeasures(int numberRewMeasures) {
        ArrayList<RewardMeasure> rewardMeasures = new ArrayList<RewardMeasure>(numberRewMeasures);
        String text = this.scanner.next();
        while (text.equals("MEASURE")) {
            String name = this.scanner.next();
            String rewItem = this.scanner.next();
            RewardMeasure rewardMeasure = new RewardMeasure(name, rewItem);
            rewardMeasures.add(rewardMeasure);
            text = this.scanner.next();
        }
        return rewardMeasures;
    }

    @Override
    public EDSPN generateModel() throws FileNotFoundException, Exception {
        edspn = null;
        this.scanner = new Scanner(this.file);
        String tempString = this.scanner.nextLine();
        this.expectSentence("NET_TYPE:");
        this.expectSentence("eDSPN");
        this.scanner.nextLine();
        tempString = this.scanner.nextLine();
        this.expectSentence("PLACES:");
        int numberPlaces = this.scanner.nextInt();
        this.expectSentence("TRANSITIONS:");
        int numberTransitions = this.scanner.nextInt();
        this.expectSentence("DELAY_PARAMETERS:");
        int numberDelayParameters = this.scanner.nextInt();
        this.expectSentence("MARKING_PARAMETERS:");
        int numberMarkingParameters = this.scanner.nextInt();
        this.expectSentence("REWARD_MEASURES:");
        int numberRewardMeasures = this.scanner.nextInt();
        edspn = new EDSPN(numberPlaces, numberTransitions, numberDelayParameters, numberMarkingParameters, numberRewardMeasures);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("LIST OF MARKING PARAMETERS (NAME, VALUE, (X,Y)-POSITION):")) {
            tempString = this.scanner.nextLine();
        }
        ArrayList<MarkingParameter> markingParameters = this.getMarkingParameters(numberMarkingParameters);
        edspn.setMarkingParameters(markingParameters);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("LIST OF PLACES (NAME, MARKING, (X,Y)-POSITION (PLACE & TAG)):")) {
            tempString = this.scanner.nextLine();
        }
        ArrayList<Place> places = this.getPlaces(numberPlaces);
        edspn.setPlaces(places);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("LIST OF DELAY PARAMETERS (NAME, VALUE, (X,Y)-POSITION)")) {
            tempString = this.scanner.nextLine();
        }
        ArrayList<DelayParameter> delayParameters = this.getDelayParameters(numberDelayParameters);
        edspn.setDelayParameters(delayParameters);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("(TRANSITION, TAG & DELAY), ARCS)")) {
            tempString = this.scanner.nextLine();
        }
        ArrayList<Transition> transitions = this.getTransitions(numberTransitions);
        edspn.setTransitions(transitions);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("MARKING DEPENDENT FIRING DELAYS FOR EXP. TRANSITIONS")) {
            tempString = this.scanner.nextLine();
        }
        this.updateDelayDependent(transitions);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("MARKING DEPENDENT WEIGHTS FOR IMMEDIATE TRANSITIONS")) {
            tempString = this.scanner.nextLine();
        }
        this.updatePriorityDependent(transitions);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("ENABLING FUNCTIONS FOR IMMEDIATE TRANSITIONS:")) {
            tempString = this.scanner.nextLine();
        }
        this.updateTransitonEnablingFuntion(transitions);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("MARKING DEPENDENT ARC CARDINALITIES")) {
            tempString = this.scanner.nextLine();
        }
        this.updateArcsMultiplicty(transitions);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("REWARD MEASURES:")) {
            tempString = this.scanner.nextLine();
        }
        ArrayList<RewardMeasure> rewardMeasures = this.getRewardMeasures(numberRewardMeasures);
        edspn.setRewardMeasures(rewardMeasures);
        tempString = this.scanner.nextLine();
        while (!tempString.contains("END OF SPECIFICATION FILE")) {
            tempString = this.scanner.nextLine();
        }
        this.scanner.close();
        return edspn;
    }

    public static void exportFile(EDSPN e, File file) throws FileNotFoundException, Exception {
        if (e.getDelayParameters() == null) {
            e.setDelayParameters(new ArrayList<DelayParameter>());
        }
        if (e.getMarkingParameters() == null) {
            e.setMarkingParameters(new ArrayList<MarkingParameter>());
        }
        FileOutputStream out = new FileOutputStream(file);
        PrintWriter p = new PrintWriter(out);
        p.println("-- FILE " + file.getAbsolutePath() + " CONTAINING STRUCTURAL DESCRIPTION OF A NET" + "\n");
        p.println("NET_TYPE:\t\t\teDSPN");
        p.println("DESCRIPTION:\t\t?");
        p.println("PLACES:\t\t\t" + e.getPlaces().size());
        p.println("TRANSITIONS:\t\t" + e.getTransitions().size());
        p.println("DELAY_PARAMETERS:\t\t" + e.getDelayParameters().size());
        p.println("MARKING_PARAMETERS:\t" + e.getMarkingParameters().size());
        p.println("REWARD_MEASURES:\t \t" + e.getRewardMeasures().size() + "\n");
        p.println("-- LIST OF MARKING PARAMETERS (NAME, VALUE, (X,Y)-POSITION):\n");
        ArrayList<MarkingParameter> arrayM = e.getMarkingParameters();
        for (MarkingParameter m : arrayM) {
            p.print("MARKPAR ");
            p.print(m.getName() + " ");
            p.print(m.getValue() + " ");
            p.print("" + m.getPosition().getX());
            p.println(" " + m.getPosition().getY() + "\n");
        }
        p.println("\n-- LIST OF PLACES (NAME, MARKING, (X,Y)-POSITION (PLACE & TAG)):\n");
        ArrayList<Place> arrayP = e.getPlaces();
        for (Place plc : arrayP) {
            if (plc.getPositionTag() == null || plc.getPositionTag().getX() == 0.0 && plc.getPositionTag().getY() == 0.0) {
                Point2D.Double posiTag = new Point2D.Double(plc.getPositionPlace().getX() - 0.1, plc.getPositionPlace().getY() + 0.2);
                plc.setPositionTag(posiTag);
            }
            p.print("PLACE ");
            p.print(plc.getName() + " ");
            p.print(plc.getMarking() + " ");
            p.print("" + plc.getPositionPlace().getX());
            p.print(" " + plc.getPositionPlace().getY());
            p.print(" " + (plc.getPositionPlace().getX() - 0.1));
            p.println(" " + (plc.getPositionPlace().getY() + 0.15));
        }
        p.println("\n-- LIST OF DELAY PARAMETERS (NAME, VALUE, (X,Y)-POSITION):");
        ArrayList<DelayParameter> ArrayD = e.getDelayParameters();
        for (DelayParameter dp : ArrayD) {
            p.print("\n");
            p.print("DELAYPAR ");
            p.print(dp.getName() + " ");
            p.print(dp.getValue() + " ");
            p.print("" + dp.getPosition().getX());
            p.println(" " + dp.getPosition().getY());
        }
        p.print("\n");
        p.print("-- LIST OF TRANSITIONS\n-- \t(");
        p.print("NAME, DELAY, ENABLING DEPENDENCE, KIND, FIRING POLICY, PRIORITY,\n");
        p.print("-- \tORIENTATION, PHASE, GROUP, GROUP_WEIGHT,\n");
        p.println("-- \t(X,Y)-POSITION (TRANSITION, TAG & DELAY), ARCS)");
        ArrayList<Transition> arrayT = e.getTransitions();
        for (Transition t : arrayT) {
            if (t.getPositionTag() == null) {
                Point2D.Double posiTag = new Point2D.Double(t.getPositionTransition().getX() - 0.1, t.getPositionTransition().getY() + 0.2);
                t.setPositionTag(posiTag);
            }
            p.print("\nTRANSITION ");
            p.print(t.getName() + " ");
            p.print(t.getDelay() + " ");
            if (t.getFiringPolicy().toString().equalsIgnoreCase("INFINITY_SERVER")) {
                p.print("IS ");
            } else {
                p.print("SS ");
            }
            if (t instanceof TransitionImmediate) {
                p.print("IM ");
            } else {
                p.print("EXP ");
            }
            if (t.getRaceType() == RaceType.RACE_WITH_AGE_MEMORY) {
                p.print("RA ");
            } else if (t.getRaceType() == RaceType.RACE_WITH_ENABLING_MEMORY) {
                p.print("RE ");
            } else if (t.getRaceType() == RaceType.RACE_WITH_RESAMPLING) {
                p.print("RS ");
            }
            if (t instanceof TransitionExponential) {
                p.print("1 ");
            } else {
                TransitionImmediate aux = (TransitionImmediate)t;
                p.print(aux.getPriority() + " ");
            }
            p.print("0 ");
            p.print("1 ");
            p.print("0 ");
            p.print("1.000000 ");
            p.print(t.getPositionTransition().getX() + " ");
            p.print(t.getPositionTransition().getY() + 0.35 + " ");
            p.print(t.getPositionTag().getX() + " ");
            p.print(t.getPositionTag().getY() + 0.35 + " ");
            p.print("0 ");
            p.println("0");
            p.print("INPARCS ");
            if (t.getArcInputs() != null && t.getArcInputs().size() != 0) {
                p.println(t.getArcInputs().size() + "");
                for (ArcInput arcInput : t.getArcInputs()) {
                    p.print(arcInput.getMultiplicity() + " ");
                    p.print(arcInput.getPlace().getName() + " ");
                    p.println("0");
                }
            } else {
                p.println("0");
            }
            p.print("OUTPARCS ");
            if (t.getArcOutputs() != null && t.getArcOutputs().size() != 0) {
                p.println(t.getArcOutputs().size() + "");
                for (ArcOutput arcOutput : t.getArcOutputs()) {
                    p.print(arcOutput.getMultiplicity() + " ");
                    p.print(arcOutput.getPlace().getName() + " ");
                    p.println("0");
                }
            } else {
                p.println("0");
            }
            p.print("INHARCS ");
            if (t.getArcInhibitors() != null && t.getArcInhibitors().size() != 0) {
                p.println(t.getArcInhibitors().size() + "");
                for (ArcInhibitor arcInharc : t.getArcInhibitors()) {
                    p.print(arcInharc.getMultiplicity() + " ");
                    p.print(arcInharc.getPlace().getName() + " ");
                    p.println("0");
                }
                continue;
            }
            p.println("0");
        }
        p.print("\n-- ");
        p.println("DEFINITION OF PARAMETERS:");
        p.print("\n-- ");
        p.println("MARKING DEPENDENT FIRING DELAYS FOR EXP. TRANSITIONS:\n");
        for (Transition t : e.getTransitions()) {
            if (!(t instanceof TransitionExponential) || t.getDelayExpression() == null) continue;
            p.print("EXP DELAY ");
            p.print(t.getName() + " ");
            p.print(t.getDelayExpression() + ";" + "\n");
        }
        p.print("\n-- ");
        p.println("MARKING DEPENDENT FIRING DELAYS FOR DET. TRANSITIONS:\n");
        p.print("\n-- ");
        p.println("PROBABILITY MASS FUNCTION DEFINITIONS FOR GEN. TRANSITIONS:\n");
        p.print("\n-- ");
        p.println("MARKING DEPENDENT WEIGHTS FOR IMMEDIATE TRANSITIONS:\n");
        for (Transition t : e.getTransitions()) {
            if (!(t instanceof TransitionImmediate) || t.getDelayExpression() == null) continue;
            p.print("WEIGHT ");
            p.print(t.getName() + " ");
            p.print(t.getDelayExpression() + ";" + "\n");
        }
        p.print("\n-- ");
        p.println("ENABLING FUNCTIONS FOR IMMEDIATE TRANSITIONS:\n");
        ArrayList<Transition> arrayTransition = e.getTransitions();
        for (Transition transition : arrayTransition) {
            TransitionImmediate transitionI;
            if (!(transition instanceof TransitionImmediate) || (transitionI = (TransitionImmediate)transition).getStringLogicCondition() == null) continue;
            p.print("FUNCTION ");
            p.print(transitionI.getName() + "  ");
            p.print(transitionI.getStringLogicCondition() + ";" + "\n");
        }
        p.print("\n-- ");
        p.println("MARKING DEPENDENT ARC CARDINALITIES:\n");
        for (Transition transition : e.getTransitions()) {
            if (transition.getArcInputs() != null && transition.getArcInputs().size() > 0) {
                for (ArcInput arcInput : transition.getArcInputs()) {
                    if (arcInput.getMultiplicityExpression() == null) continue;
                    p.print("CARDINALITY ");
                    p.println("INPARC");
                    p.print("\t");
                    p.print(transition.getName() + " ");
                    p.print(arcInput.getPlace().getName() + " ");
                    p.println(arcInput.getMultiplicityExpression() + ";");
                }
            }
            if (transition.getArcOutputs() != null && transition.getArcOutputs().size() > 0) {
                for (ArcOutput arcOutput : transition.getArcOutputs()) {
                    if (arcOutput.getMultiplicityExpression() == null) continue;
                    p.print("CARDINALITY ");
                    p.println("OUTPARC");
                    p.print("\t");
                    p.print(transition.getName() + " ");
                    p.print(arcOutput.getPlace().getName() + " ");
                    p.println(arcOutput.getMultiplicityExpression() + ";");
                }
            }
            if (transition.getArcInhibitors() == null || transition.getArcInhibitors().size() <= 0) continue;
            for (ArcOutput arcOutput : transition.getArcOutputs()) {
                if (arcOutput.getMultiplicityExpression() == null) continue;
                p.print("CARDINALITY ");
                p.println("INHARC");
                p.print("\t");
                p.print(transition.getName() + " ");
                p.print(arcOutput.getPlace().getName() + " ");
                p.println(arcOutput.getMultiplicityExpression() + ";");
            }
        }
        p.print("\n-- ");
        p.println("REWARD MEASURES:\n");
        for (RewardMeasure r : e.getRewardMeasures()) {
            p.print("MEASURE ");
            p.print(r.getName() + "\n");
            p.println(r.getStringExpression() + ";");
        }
        p.print("\n-- ");
        p.println("END OF SPECIFICATION FILE");
        p.close();
    }
}

