/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.io.File;

public class TransientParameters {
    private double confidenceLevel;
    private double maxRelativeError;
    private int maxTimeMilliseconds;
    private long maxSimulationTime;
    private long samplingPoints;
    private File file;
    private double slotSize;
    private boolean calculateMTTF;

    public TransientParameters(double confidenceLevel, double maxRelativeError, int maxTimeMilliseconds, long simulationTime, long maxSamplingPoints, File file, boolean calculateMTTF) {
        this.confidenceLevel = confidenceLevel;
        this.maxRelativeError = maxRelativeError;
        this.maxTimeMilliseconds = maxTimeMilliseconds;
        this.maxSimulationTime = simulationTime;
        this.samplingPoints = maxSamplingPoints;
        this.file = file;
        this.calculateMTTF = calculateMTTF;
        this.slotSize = (double)this.maxSimulationTime / (double)this.samplingPoints;
    }

    public boolean getCalculateMTTF() {
        return this.calculateMTTF;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public double getMaxRelativeError() {
        return this.maxRelativeError;
    }

    public void setMaxRelativeError(double maxRelativeError) {
        this.maxRelativeError = maxRelativeError;
    }

    public long getSamplingPoints() {
        return this.samplingPoints;
    }

    public void setSamplingPoints(long samplingPoints) {
        this.samplingPoints = samplingPoints;
    }

    public int getMaxTimeMilliseconds() {
        return this.maxTimeMilliseconds;
    }

    public void setMaxTimeMilliseconds(int maxTimeMilliseconds) {
        this.maxTimeMilliseconds = maxTimeMilliseconds;
    }

    public long getMaxSimulationTime() {
        return this.maxSimulationTime;
    }

    public void setMaxSimulationTime(long simulationTime) {
        this.maxSimulationTime = simulationTime;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public double getSlotSize() {
        return this.slotSize;
    }
}

