/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.util.Random;
import org.modcs.tools.spn.simulator.engine.Event;
import org.modcs.tools.spn.simulator.engine.EventList;
import org.modcs.tools.spn.simulator.engine.Queue;

public class SimExample {
    public static double clock;
    public static double meanInterArrivalTime;
    public static double meanServiceTime;
    public static double sigma;
    public static double lastEventTime;
    public static double totalBusy;
    public static double maxQueueLength;
    public static double sumResponseTime;
    public static long numberOfCustomers;
    public static long queueLength;
    public static long numberInService;
    public static long totalCustomers;
    public static long numberOfDepartures;
    public static long longService;
    public static final int arrival = 1;
    public static final int departure = 2;
    public static EventList futureEventList;
    public static Queue customers;
    public static Random stream;

    public static void initialization() {
        clock = 0.0;
        queueLength = 0L;
        numberInService = 0L;
        lastEventTime = 0.0;
        totalBusy = 0.0;
        maxQueueLength = 0.0;
        sumResponseTime = 0.0;
        numberOfDepartures = 0L;
        longService = 0L;
        Event evt = new Event(1, SimExample.exponential(stream, meanInterArrivalTime));
        futureEventList.enqueue(evt);
    }

    public static void processArrival(Event evt) {
        customers.enqueue(evt);
        ++queueLength;
        if (numberInService == 0L) {
            SimExample.scheduleDeparture();
        } else {
            totalBusy += clock - lastEventTime;
        }
        if (maxQueueLength < (double)queueLength) {
            maxQueueLength = queueLength;
        }
        Event nextArrival = new Event(1, clock + SimExample.exponential(stream, meanInterArrivalTime));
        futureEventList.enqueue(nextArrival);
        lastEventTime = clock;
    }

    public static void scheduleDeparture() {
        double ServiceTime = SimExample.exponential(stream, meanServiceTime);
        Event depart = new Event(2, clock + ServiceTime);
        futureEventList.enqueue(depart);
        numberInService = 1L;
        --queueLength;
    }

    public static void processDeparture(Event e) {
        Event finished = (Event)customers.dequeue();
        double response = clock - finished.getTime();
        sumResponseTime += response;
        if (response > 4.0) {
            ++longService;
        }
        totalBusy += clock - lastEventTime;
        ++numberOfDepartures;
        lastEventTime = clock;
        if (queueLength > 0L) {
            SimExample.scheduleDeparture();
        } else {
            numberInService = 0L;
        }
    }

    public static void reportGeneration() {
        double rho = totalBusy / clock;
        double avgr = sumResponseTime / (double)totalCustomers;
        double pc4 = (double)longService / (double)totalCustomers;
        System.out.println("SINGLE SERVER QUEUE SIMULATION - GROCERY STORE CHECKOUT COUNTER ");
        System.out.println("\tMEAN INTERARRIVAL TIME                         " + meanInterArrivalTime);
        System.out.println("\tMEAN SERVICE TIME                              " + meanServiceTime);
        System.out.println("\tSTANDARD DEVIATION OF SERVICE TIMES            " + sigma);
        System.out.println("\tNUMBER OF CUSTOMERS SERVED                     " + totalCustomers);
        System.out.println();
        System.out.println("\tSERVER UTILIZATION                             " + rho);
        System.out.println("\tMAXIMUM LINE LENGTH                            " + maxQueueLength);
        System.out.println("\tAVERAGE RESPONSE TIME                          " + avgr + "  MINUTES");
        System.out.println("\tPROPORTION WHO SPEND FOUR ");
        System.out.println("\t MINUTES OR MORE IN SYSTEM                     " + pc4);
        System.out.println("\tSIMULATION RUNLENGTH                           " + clock + " MINUTES");
        System.out.println("\tNUMBER OF DEPARTURES                           " + totalCustomers);
    }

    public static double exponential(Random rng, double mean) {
        return -mean * Math.log(rng.nextDouble());
    }

    public static void main(String[] argv) {
        meanInterArrivalTime = 4.5;
        meanServiceTime = 3.2;
        sigma = 0.6;
        totalCustomers = 1000L;
        long seed = 123567L;
        stream = new Random(seed);
        futureEventList = new EventList();
        customers = new Queue();
        SimExample.initialization();
        while (numberOfDepartures < totalCustomers) {
            Event evt = (Event)futureEventList.getMin();
            futureEventList.dequeue();
            clock = evt.getTime();
            if (evt.getType() == 1) {
                SimExample.processArrival(evt);
                continue;
            }
            SimExample.processDeparture(evt);
        }
        SimExample.reportGeneration();
    }
}

