/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.TransitionImmediate;
import org.modcs.tools.spn.simulator.entities.SELComponentModel;
import org.modcs.tools.spn.simulator.randomvariates.RandomVariateGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledEventList {
    private long simulationTime = 0L;
    private ArrayList<SELComponentModel> scheduledEventList = new ArrayList();
    private RandomVariateGenerator randomGenerator;

    private boolean isFeasible(Transition transition, ArrayList<Transition> transitions) {
        boolean result = false;
        for (Transition TempTransition : transitions) {
            if (!TempTransition.getName().equals(transition.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void removeNotFeasibles(ArrayList<Transition> transitionsFeasibles, double time) {
        ArrayList<SELComponentModel> temp = new ArrayList<SELComponentModel>();
        for (SELComponentModel scheduledEventElement : this.scheduledEventList) {
            if (!this.isFeasible(scheduledEventElement.getTransition(), transitionsFeasibles)) continue;
            if (scheduledEventElement.getTransition().getFiringPolicy() == FiringPolicy.SINGLE_SERVER) {
                transitionsFeasibles.remove(scheduledEventElement.getTransition());
            } else if (scheduledEventElement.getTransition().getFiringPolicy() == FiringPolicy.INFINITY_SERVER) {
                scheduledEventElement.getTransition().incrementCountRemaingInList();
            }
            if (scheduledEventElement.getTransition() instanceof TransitionExponential) {
                try {
                    scheduledEventElement.setTime(scheduledEventElement.getTime() - time);
                }
                catch (Exception ex) {
                    Logger.getLogger(ScheduledEventList.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
            }
            temp.add(scheduledEventElement);
        }
        this.scheduledEventList = temp;
    }

    public void addSELComponentInList(double rate, TransitionExponential transition, SELComponentModel selTemp) throws Exception {
        double timeGenerated = transition.getRandomNumber();
        selTemp = new SELComponentModel(transition, timeGenerated);
        this.scheduledEventList.add(selTemp);
    }

    public SELComponentModel updateList(ArrayList<Transition> transitionsFeasibles, double time) throws CloneNotSupportedException, Exception {
        this.removeNotFeasibles(transitionsFeasibles, time);
        for (Transition transition : transitionsFeasibles) {
            SELComponentModel selTemp = null;
            if (transition instanceof TransitionExponential) {
                TransitionExponential tranExponential = (TransitionExponential)transition;
                double delay = transition.getDelay();
                double rate = 1.0 / delay;
                if (transition.getFiringPolicy() == FiringPolicy.SINGLE_SERVER) {
                    this.addSELComponentInList(rate, tranExponential, selTemp);
                    continue;
                }
                if (transition.getFiringPolicy() != FiringPolicy.INFINITY_SERVER) continue;
                int enablingDegree = transition.getEnablingDegree();
                int CountRemaingInList = transition.getCountRemaingInList();
                for (int i = 0; i < enablingDegree - CountRemaingInList; ++i) {
                    this.addSELComponentInList(rate, tranExponential, selTemp);
                }
                transition.setCountRemaingInList(0);
                continue;
            }
            if (!(transition instanceof TransitionImmediate)) continue;
            selTemp = new SELComponentModel(transition, 0.0);
            this.scheduledEventList.add(selTemp);
        }
        Collections.sort(this.scheduledEventList);
        if (this.scheduledEventList.size() != 0) {
            Transition transition = this.scheduledEventList.get(0).getTransition();
            if (transition instanceof TransitionExponential) {
                return this.scheduledEventList.remove(0);
            }
            if (transition instanceof TransitionImmediate) {
                return this.getTransitionImmediateByProbability((TransitionImmediate)transition);
            }
        }
        return null;
    }

    public SELComponentModel getTransitionImmediateByProbability(TransitionImmediate transitionImmediate) throws Exception {
        SELComponentModel scheduledEventElement;
        Transition transition;
        ArrayList<Double> doubles = new ArrayList<Double>();
        int priorityFirst = transitionImmediate.getPriority();
        double sum = 0.0;
        Iterator<SELComponentModel> i$ = this.scheduledEventList.iterator();
        while (i$.hasNext() && !((transition = (scheduledEventElement = i$.next()).getTransition()) instanceof TransitionExponential) && ((TransitionImmediate)transition).getPriority() >= priorityFirst) {
            double weight = ((TransitionImmediate)transition).getDelay();
            sum += weight;
            doubles.add(new Double(weight));
        }
        if (doubles.size() == 1) {
            return this.scheduledEventList.remove(0);
        }
        double random = Math.random();
        double lastValue = 0.0;
        int numberInList = 0;
        for (int i = 0; i < doubles.size(); ++i) {
            double doubleTemp = (Double)doubles.get(i);
            doubleTemp = doubleTemp / sum + lastValue;
            if (random >= lastValue && random < doubleTemp) {
                numberInList = i;
                break;
            }
            lastValue = doubleTemp;
        }
        return this.scheduledEventList.remove(numberInList);
    }

    public ArrayList<SELComponentModel> getEventList() {
        return this.scheduledEventList;
    }
}

