/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import org.modcs.tools.spn.simulator.engine.Engine;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;

public class EngineRemoveTransient
extends Engine {
    private double previousVariance = 0.0;
    private double currentVariance = 0.0;

    public EngineRemoveTransient(InterfaceModelGenerator modelGenerator) {
        super(modelGenerator);
    }

    public boolean canStopStationary() throws Exception {
        boolean result = false;
        this.setCounterIntraRun(this.getCounterIntraRun() + 1);
        if (this.getCounterIntraRun() >= this.getRunSize() && this.getFireCounter().isAllTransitionsReachMinFires()) {
            double errorTemp;
            this.setCounterInterRun(this.getCounterInterRun() + 1);
            double metric = this.getMetric();
            this.getDataAnalyzerInterRuns().update(metric);
            this.previousVariance = this.currentVariance;
            this.currentVariance = this.getDataAnalyzerInterRuns().getVariance();
            double diferenceVariances = this.previousVariance - this.currentVariance;
            double maximumVariance = this.previousVariance / 100.0 * (100.0 - this.getConfidenceLevel());
            if (diferenceVariances < 0.0) {
                diferenceVariances *= -1.0;
            }
            if (diferenceVariances > maximumVariance && this.currentVariance != 0.0 && this.previousVariance != 0.0) {
                this.getDataAnalyzerInterRuns().RemovePeriodTransient(metric);
            }
            if (this.getCounterInterRun() == this.getExpectedRuns()) {
                this.setExpectedRuns((int)Math.ceil(this.getDataAnalyzerInterRuns().getReplications(this.getConfidenceLevel(), this.getError())));
            }
            if (this.getCounterInterRun() > 1) {
                this.outputText("Count: " + this.getCounterInterRun() + "\tError: " + this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel()) + "\tMetric: " + metric);
            } else {
                this.outputText("\tMetric: " + metric);
            }
            this.initRunStationary();
            if (this.getCounterInterRun() >= this.getWarmUpPeriod() && (errorTemp = this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel())) < this.getError()) {
                result = true;
            }
        }
        if (this.getMaxTime() > 0L && System.currentTimeMillis() - this.getStartTime() > this.getMaxTime()) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }
}

