/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.modcs.tools.spn.experiment.ExperimentEngine;
import org.modcs.tools.spn.gui.JDialogSimulationOutput;
import org.modcs.tools.spn.gui.graphview.ChartTransient;
import org.modcs.tools.spn.model.EDSPN;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.expressions.LogicCondition;
import org.modcs.tools.spn.simulator.engine.FireCounter;
import org.modcs.tools.spn.simulator.engine.ScheduledEventList;
import org.modcs.tools.spn.simulator.engine.StationaryParameters;
import org.modcs.tools.spn.simulator.engine.TransientConfidenceList;
import org.modcs.tools.spn.simulator.engine.TransientParameters;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;
import org.modcs.tools.spn.simulator.entities.SELComponentModel;
import org.modcs.tools.spn.simulator.outputanalisys.DataAnalyzer;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    private ScheduledEventList scheduledEventList;
    private DataAnalyzer dataAnalyzerInterRuns;
    private EDSPN model;
    private int expectedRuns;
    private InterfaceModelGenerator modelGenerator;
    private int runSize;
    private double confidenceLevel;
    private double error;
    private int counterIntraRun;
    private int counterInterRun = 0;
    private FireCounter fireCounter;
    private int minNumberFiresForEachTransition;
    private int warmUpPeriod;
    private long startTime;
    private long maxTime;
    private JDialogSimulationOutput jDialogSimulationOutput;
    private long maxSimulationTime;
    private long samplingPoints;
    private File fileOutputTransient;
    private TransientConfidenceList transientConfidenceList;
    private double currentSimulationTime;
    private ArrayList<Transition> feasiblesEvents;
    private SELComponentModel selComponentActual;
    private int currentIndexTransientSimulation;
    private boolean calculateMTTF;
    private double meanTimeToFailure;
    private double meanTimeToRepair;
    private boolean experiment;
    private ExperimentEngine.TaskStationaty taskStationaty;
    private ExperimentEngine.TaskTransient taskTransient;
    private String text;
    private double firstError = Double.NEGATIVE_INFINITY;

    public Engine() {
        this.dataAnalyzerInterRuns = new DataAnalyzer();
    }

    public Engine(InterfaceModelGenerator interfaceModelGenerator) {
        this();
        this.modelGenerator = interfaceModelGenerator;
    }

    public int getCounterRuns() {
        return this.getCounterInterRun();
    }

    public int getRunSize() {
        return this.runSize;
    }

    public ExperimentEngine.TaskStationaty getTaskStationaty() {
        return this.taskStationaty;
    }

    public void setTaskStationaty(ExperimentEngine.TaskStationaty taskStationaty) {
        this.taskStationaty = taskStationaty;
    }

    public void initRun() throws Exception {
        this.setModel(this.getModelGenerator().generateModel());
        this.setScheduledEventList(new ScheduledEventList());
        this.setCounterIntraRun(0);
        this.setFeasiblesEvents(this.getModel().getFeasibles());
        this.setSelComponentActual(this.getScheduledEventList().updateList(this.getFeasiblesEvents(), 0.0));
    }

    public void initRunStationary() throws Exception {
        this.initRun();
        this.setFireCounter(new FireCounter(this.getModel().getTransitions().size(), this.getMinNumberFiresForEachTransition()));
        ExponentialRandomVariateGenerator.getInstance().restartSeed();
    }

    public void initRunTransient() throws Exception {
        this.initRun();
        this.setCurrentSimulationTime(0.0);
        this.setCurrentIndexTransientSimulation(0);
        ExponentialRandomVariateGenerator.getInstance().restartSeed();
    }

    public String getText() {
        return this.text;
    }

    public void outputText(String message) {
        if (!this.isExperiment()) {
            this.setText(message + "\n");
            if (this.getDataAnalyzerInterRuns() != null) {
                if (this.getTaskStationaty() != null) {
                    this.getTaskStationaty().setProgresso(this.getCounterInterRun());
                } else if (this.getTaskTransient() != null) {
                    double errorTemp = this.getTransientConfidenceList().getMaximumError();
                    if (this.getFirstError() != Double.NEGATIVE_INFINITY && this.getFirstError() != 0.0 && errorTemp > 0.0) {
                        int prog = 100 - (int)(100.0 * (errorTemp - this.getError()) / (this.getFirstError() - this.getError()));
                        if (prog >= 100) {
                            prog = 99;
                        }
                        this.getTaskTransient().setProgresso(prog);
                    }
                }
            }
        }
    }

    public void initOutputScreen(String message) {
        if (!this.isExperiment()) {
            this.outputText("");
            this.outputText(message);
            this.outputText("");
        }
    }

    public void printTime() {
        long miliseconds = System.currentTimeMillis() - this.getStartTime();
        int seconds = (int)(miliseconds / 1000L % 60L);
        int minutes = (int)(miliseconds / 1000L / 60L % 60L);
        int hours = (int)(miliseconds / 1000L / 60L / 60L);
        this.outputText("Time Spend: " + hours + " hour(s) " + minutes + " minutes(s) " + seconds + " second(s) ");
    }

    public void printFile(TransientParameters transientParameters) throws FileNotFoundException {
        ArrayList<Double> doubles = new ArrayList<Double>();
        FileOutputStream out = new FileOutputStream(this.getFileOutputTransient());
        PrintWriter p = new PrintWriter(out);
        int i = 0;
        while ((long)i < this.getSamplingPoints()) {
            DataAnalyzer dataAnalyzer = this.getTransientConfidenceList().getDataAnalyzerByIndex(i);
            p.print("Time: " + transientParameters.getSlotSize() * (double)(i + 1));
            p.print("\tMean: " + dataAnalyzer.getMean());
            p.print("\tCI: [" + dataAnalyzer.getLowerBoundConfidenceInterval() + "," + dataAnalyzer.getUpperBoundConfidenceInterval() + "]");
            p.println("\tError: " + this.getTransientConfidenceList().getErrorByIndex(i));
            doubles.add(new Double(dataAnalyzer.getMean()));
            ++i;
        }
        ChartTransient chartTransient = new ChartTransient();
        JFrame jFrame = new JFrame("Reliability Values");
        jFrame.add(chartTransient.getChart(doubles, transientParameters.getSlotSize()));
        jFrame.setLocationRelativeTo(this.getjDialogSimulationOutput());
        jFrame.pack();
        jFrame.setVisible(true);
        if (this.isCalculateMTTF()) {
            double MTTFValue = this.generateMTTF(transientParameters);
            p.println();
            p.println("MTTF = " + MTTFValue);
            this.outputText("MTTF = " + MTTFValue);
        }
        p.close();
    }

    public double generateMTTF(TransientParameters transientParameters) {
        double currentValue = 0.0;
        double MTTF = 0.0;
        int i = 0;
        while ((long)i < this.getSamplingPoints()) {
            DataAnalyzer dataAnalyzer = this.getTransientConfidenceList().getDataAnalyzerByIndex(i);
            if (i == 0) {
                currentValue = dataAnalyzer.getMean();
            } else {
                double nextValue = dataAnalyzer.getMean();
                double media = (currentValue + nextValue) / 2.0;
                MTTF += (media *= Double.parseDouble(String.valueOf(transientParameters.getMaxSimulationTime())) / (double)transientParameters.getSamplingPoints());
                currentValue = nextValue;
            }
            ++i;
        }
        this.setMeanTimeToFailure(MTTF + 1.0);
        return MTTF;
    }

    public void runTransient(TransientParameters transientParameters) throws Exception {
        this.setConfidenceLevel(transientParameters.getConfidenceLevel());
        this.setError(transientParameters.getMaxRelativeError());
        this.setMaxTime(transientParameters.getMaxTimeMilliseconds());
        this.setMaxSimulationTime(transientParameters.getMaxSimulationTime());
        this.setSamplingPoints(transientParameters.getSamplingPoints());
        this.setFileOutputTransient(transientParameters.getFile());
        this.setStartTime(System.currentTimeMillis());
        this.setExpectedRuns(50);
        this.setCalculateMTTF(transientParameters.getCalculateMTTF());
        this.setTransientConfidenceList(new TransientConfidenceList((int)this.getSamplingPoints(), this.getConfidenceLevel(), this.getError()));
        this.initOutputScreen("New Transient Simulation ......");
        this.initRunTransient();
        double slotSize = transientParameters.getSlotSize();
        double timeSpend = 0.0;
        do {
            if (this.getSelComponentActual() != null) {
                timeSpend = this.getSelComponentActual().getTime();
            }
            double restActualSlot = this.getCurrentSimulationTime() % slotSize;
            int numberSlotsAdvanced = (int)Math.floor((timeSpend + restActualSlot) / slotSize);
            LogicCondition logicCondition = this.getModel().getRewardMeasures().get(0).getExpression().getRealValue().getRewItem().getProbability().getLogicCondition();
            if (numberSlotsAdvanced > 0) {
                double restSlot = timeSpend;
                restSlot -= slotSize - restActualSlot;
                this.updateMetrics(slotSize - restActualSlot);
                boolean eval = logicCondition.evaluate();
                this.getTransientConfidenceList().update(eval, this.getCurrentIndexTransientSimulation());
                this.setCurrentIndexTransientSimulation(this.getCurrentIndexTransientSimulation() + 1);
                for (int i = 1; i < numberSlotsAdvanced && (double)this.getCurrentIndexTransientSimulation() * slotSize < (double)this.getMaxSimulationTime(); ++i) {
                    restSlot -= slotSize;
                    this.updateMetrics(slotSize);
                    this.getTransientConfidenceList().update(eval, this.getCurrentIndexTransientSimulation());
                    this.setCurrentIndexTransientSimulation(this.getCurrentIndexTransientSimulation() + 1);
                }
                this.updateMetrics(restSlot);
            } else {
                this.updateMetrics(timeSpend);
            }
            this.setCurrentSimulationTime(this.getCurrentSimulationTime() + timeSpend);
            if (this.getSelComponentActual() == null) continue;
            this.getSelComponentActual().getTransition().fire();
            this.setFeasiblesEvents(this.getModel().getFeasibles());
            this.setSelComponentActual(this.getScheduledEventList().updateList(this.getFeasiblesEvents(), timeSpend));
        } while (!this.canStopTransient());
        this.printFile(transientParameters);
        this.printTime();
        this.getTaskTransient().setProgresso(100);
    }

    public void runStationary(StationaryParameters stationaryParameters) throws Exception {
        this.setConfidenceLevel(stationaryParameters.getConfidenceLevel());
        this.setError(stationaryParameters.getMaxRelativeError());
        this.setMinNumberFiresForEachTransition(stationaryParameters.getMinFiringTransitions());
        this.setWarmUpPeriod(stationaryParameters.getWarmUpPeriod());
        this.setRunSize(stationaryParameters.getRunSize());
        this.setMaxTime(stationaryParameters.getMaxTimeMilliseconds());
        this.setStartTime(System.currentTimeMillis());
        this.initOutputScreen("New Stationary Simulation......");
        this.initRunStationary();
        do {
            double timeSpend = this.getSelComponentActual().getTime();
            this.getFireCounter().update(this.getSelComponentActual().getTransition());
            this.updateMetrics(this.getSelComponentActual());
            this.getSelComponentActual().getTransition().fire();
            this.setFeasiblesEvents(this.getModel().getFeasibles());
            this.setSelComponentActual(this.getScheduledEventList().updateList(this.getFeasiblesEvents(), timeSpend));
        } while (!this.canStopStationary());
        this.printTime();
        if (this.getTaskStationaty() != null) {
            this.getTaskStationaty().setMaximum();
        }
    }

    public void updateMetrics(SELComponentModel selComponentActual) throws Exception {
        this.getModel().updateMetrics(selComponentActual.getTime());
    }

    public void updateMetrics(double time) throws Exception {
        this.getModel().updateMetrics(time);
    }

    public double getMetric() throws Exception {
        double metric = this.getModel().getMetrics().get(0);
        return metric;
    }

    public boolean canStopStationary() throws Exception {
        boolean result = false;
        this.setCounterIntraRun(this.getCounterIntraRun() + 1);
        if (this.getCounterIntraRun() >= this.getRunSize() && this.getFireCounter().isAllTransitionsReachMinFires()) {
            double errorTemp;
            this.setCounterInterRun(this.getCounterInterRun() + 1);
            double metric = this.getMetric();
            this.getDataAnalyzerInterRuns().update(metric);
            if (this.getCounterInterRun() == this.getExpectedRuns()) {
                this.setExpectedRuns((int)Math.ceil(this.getDataAnalyzerInterRuns().getReplications(this.getConfidenceLevel(), this.getError())));
            }
            if (this.getCounterInterRun() > 1) {
                this.outputText("Count: " + this.getCounterInterRun() + "\tError: " + this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel()) + "\tMetric: " + metric);
            } else {
                this.outputText("\tMetric: " + metric);
            }
            this.initRunStationary();
            if (this.getCounterInterRun() >= this.getWarmUpPeriod() && (errorTemp = this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel())) < this.getError()) {
                result = true;
            }
        }
        if (this.getMaxTime() > 0L && System.currentTimeMillis() - this.getStartTime() > this.getMaxTime()) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }

    private boolean canStopTransient() throws Exception {
        boolean result = false;
        if (this.getCurrentSimulationTime() >= (double)this.getMaxSimulationTime()) {
            this.setCounterInterRun(this.getCounterInterRun() + 1);
            if (this.getCounterInterRun() > 1) {
                this.outputText("Count: " + this.getCounterInterRun() + "\tError: " + this.getTransientConfidenceList().getMaximumError());
            }
            if (this.getCounterInterRun() >= this.getExpectedRuns()) {
                if (this.getCounterInterRun() == this.getExpectedRuns()) {
                    this.setExpectedRuns((int)Math.ceil(this.getTransientConfidenceList().getMaximumReplications()));
                }
                double errorTemp = this.getTransientConfidenceList().getMaximumError();
                if (this.getFirstError() == Double.NEGATIVE_INFINITY || this.getFirstError() == 0.0) {
                    this.setFirstError(errorTemp);
                }
                if (errorTemp < this.getError()) {
                    result = true;
                }
            }
            this.initRunTransient();
            this.getTransientConfidenceList().resetMaximumError();
            this.getTransientConfidenceList().resetMaximumReplications();
        }
        if (this.getMaxTime() > 0L && System.currentTimeMillis() - this.getStartTime() > this.getMaxTime()) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }

    public double getResult() {
        return this.getDataAnalyzerInterRuns().getMean();
    }

    public String getResults() {
        double nines = 2.0 - Math.log(100.0 - this.getDataAnalyzerInterRuns().getMean() * 100.0) / Math.log(10.0);
        return "Result: " + this.getDataAnalyzerInterRuns().getMean() + "\nNines: " + nines + "\nConfidence Interval: [" + this.getDataAnalyzerInterRuns().getLowerBoundConfidenceInterval() + "," + this.getDataAnalyzerInterRuns().getUpperBoundConfidenceInterval() + "]" + "\nError %: " + 50.0 * ((this.getDataAnalyzerInterRuns().getUpperBoundConfidenceInterval() - this.getDataAnalyzerInterRuns().getLowerBoundConfidenceInterval()) / this.getDataAnalyzerInterRuns().getMean()) + "\nRun size: " + this.getRunSize() + "\nNumber of Runs " + this.getCounterRuns() + "\nTotal Runs " + this.getCounterRuns() * this.getRunSize();
    }

    public void setExperiment(boolean b) {
        this.experiment = b;
    }

    public boolean getExperiment() {
        return this.isExperiment();
    }

    public void setTaskTransient(ExperimentEngine.TaskTransient taskTransient) {
        this.taskTransient = taskTransient;
    }

    public DataAnalyzer getDataAnalyzerInterRuns() {
        return this.dataAnalyzerInterRuns;
    }

    public void setDataAnalyzerInterRuns(DataAnalyzer dataAnalyzerInterRuns) {
        this.dataAnalyzerInterRuns = dataAnalyzerInterRuns;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public int getCounterIntraRun() {
        return this.counterIntraRun;
    }

    public void setCounterIntraRun(int counterIntraRun) {
        this.counterIntraRun = counterIntraRun;
    }

    public int getCounterInterRun() {
        return this.counterInterRun;
    }

    public void setCounterInterRun(int counterInterRun) {
        this.counterInterRun = counterInterRun;
    }

    public FireCounter getFireCounter() {
        return this.fireCounter;
    }

    public void setFireCounter(FireCounter fireCounter) {
        this.fireCounter = fireCounter;
    }

    public int getExpectedRuns() {
        return this.expectedRuns;
    }

    public void setExpectedRuns(int expectedRuns) {
        this.expectedRuns = expectedRuns;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public int getWarmUpPeriod() {
        return this.warmUpPeriod;
    }

    public void setWarmUpPeriod(int warmUpPeriod) {
        this.warmUpPeriod = warmUpPeriod;
    }

    public long getMaxSimulationTime() {
        return this.maxSimulationTime;
    }

    public void setMaxSimulationTime(long maxSimulationTime) {
        this.maxSimulationTime = maxSimulationTime;
    }

    public ScheduledEventList getScheduledEventList() {
        return this.scheduledEventList;
    }

    public void setScheduledEventList(ScheduledEventList scheduledEventList) {
        this.scheduledEventList = scheduledEventList;
    }

    public EDSPN getModel() {
        return this.model;
    }

    public void setModel(EDSPN model) {
        this.model = model;
    }

    public InterfaceModelGenerator getModelGenerator() {
        return this.modelGenerator;
    }

    public void setModelGenerator(InterfaceModelGenerator modelGenerator) {
        this.modelGenerator = modelGenerator;
    }

    public void setRunSize(int runSize) {
        this.runSize = runSize;
    }

    public int getMinNumberFiresForEachTransition() {
        return this.minNumberFiresForEachTransition;
    }

    public void setMinNumberFiresForEachTransition(int minNumberFiresForEachTransition) {
        this.minNumberFiresForEachTransition = minNumberFiresForEachTransition;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public JDialogSimulationOutput getjDialogSimulationOutput() {
        return this.jDialogSimulationOutput;
    }

    public void setjDialogSimulationOutput(JDialogSimulationOutput jDialogSimulationOutput) {
        this.jDialogSimulationOutput = jDialogSimulationOutput;
    }

    public long getSamplingPoints() {
        return this.samplingPoints;
    }

    public void setSamplingPoints(long samplingPoints) {
        this.samplingPoints = samplingPoints;
    }

    public File getFileOutputTransient() {
        return this.fileOutputTransient;
    }

    public void setFileOutputTransient(File fileOutputTransient) {
        this.fileOutputTransient = fileOutputTransient;
    }

    public TransientConfidenceList getTransientConfidenceList() {
        return this.transientConfidenceList;
    }

    public void setTransientConfidenceList(TransientConfidenceList transientConfidenceList) {
        this.transientConfidenceList = transientConfidenceList;
    }

    public double getCurrentSimulationTime() {
        return this.currentSimulationTime;
    }

    public void setCurrentSimulationTime(double currentSimulationTime) {
        this.currentSimulationTime = currentSimulationTime;
    }

    public ArrayList<Transition> getFeasiblesEvents() {
        return this.feasiblesEvents;
    }

    public void setFeasiblesEvents(ArrayList<Transition> feasiblesEvents) {
        this.feasiblesEvents = feasiblesEvents;
    }

    public SELComponentModel getSelComponentActual() {
        return this.selComponentActual;
    }

    public void setSelComponentActual(SELComponentModel selComponentActual) {
        this.selComponentActual = selComponentActual;
    }

    public int getCurrentIndexTransientSimulation() {
        return this.currentIndexTransientSimulation;
    }

    public void setCurrentIndexTransientSimulation(int currentIndexTransientSimulation) {
        this.currentIndexTransientSimulation = currentIndexTransientSimulation;
    }

    public boolean isCalculateMTTF() {
        return this.calculateMTTF;
    }

    public void setCalculateMTTF(boolean calculateMTTF) {
        this.calculateMTTF = calculateMTTF;
    }

    public double getMeanTimeToFailure() {
        return this.meanTimeToFailure;
    }

    public void setMeanTimeToFailure(double meanTimeToFailure) {
        this.meanTimeToFailure = meanTimeToFailure;
    }

    public double getMeanTimeToRepair() {
        return this.meanTimeToRepair;
    }

    public void setMeanTimeToRepair(double meanTimeToRepair) {
        this.meanTimeToRepair = meanTimeToRepair;
    }

    public boolean isExperiment() {
        return this.experiment;
    }

    public ExperimentEngine.TaskTransient getTaskTransient() {
        return this.taskTransient;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getFirstError() {
        return this.firstError;
    }

    public void setFirstError(double firstError) {
        this.firstError = firstError;
    }
}

