/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.Identifier;

public class IntegerParameter
implements Serializable {
    private static final long serialVersionUID = 3259807400183024144L;
    private Identifier identifier;

    public IntegerParameter(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier.toString();
    }

    public static boolean testInteger(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static IntegerParameter parse(String text) {
        IntegerParameter integerParameter = null;
        Identifier id = Identifier.parse(text);
        if (id != null && IntegerParameter.testInteger(id.getValue() + "")) {
            integerParameter = new IntegerParameter(id);
        }
        return integerParameter;
    }

    public int evaluate() {
        return (int)this.identifier.evaluate();
    }
}

