/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.Expression;
import org.modcs.tools.spn.model.expressions.FalseConditionException;
import org.modcs.tools.spn.model.expressions.LogicCondition;

public class IfThenCondition
implements Serializable {
    private static final long serialVersionUID = 9049440558004732414L;
    public static final String IF = "IF";
    public static final String THEN = ":";
    private LogicCondition logicCondition;
    private Expression expression;

    public IfThenCondition(LogicCondition logicCondition, Expression expression) {
        this.logicCondition = logicCondition;
        this.expression = expression;
    }

    public static IfThenCondition parse(String text) {
        IfThenCondition ifCondition = null;
        int posThen = text.indexOf(THEN);
        String temp = null;
        try {
            temp = text.substring(0, 2);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (temp.equals(IF) && posThen != -1) {
            try {
                temp = text.substring(2, posThen);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            LogicCondition logicCondition = LogicCondition.parse(temp);
            if (logicCondition == null) {
                return null;
            }
            try {
                temp = text.substring(posThen + 1, text.length());
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            Expression expression = Expression.parse(temp);
            if (expression == null) {
                return null;
            }
            ifCondition = new IfThenCondition(logicCondition, expression);
        }
        return ifCondition;
    }

    public double evaluate() throws FalseConditionException, Exception {
        if (this.logicCondition != null && this.expression != null) {
            if (this.logicCondition.evaluate()) {
                return this.expression.evaluate();
            }
            throw new FalseConditionException();
        }
        throw new Exception("Error: Evaluate Expressions");
    }
}

