/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.model.expressions.MarkingFunction;
import org.modcs.tools.spn.model.expressions.NumericOperator;
import org.modcs.tools.spn.model.expressions.RealValue;

public class Expression
implements Serializable {
    private static final long serialVersionUID = -7962725348020384236L;
    RealValue realValue;
    Expression negativeExpression;
    Expression leftExpression;
    NumericOperator numericOperator;
    Expression rigthExpression;

    public Expression(RealValue realValue) {
        this.realValue = realValue;
    }

    public Expression(Expression negativeExpression, NumericOperator num) {
        this.negativeExpression = negativeExpression;
        this.numericOperator = num;
    }

    public Expression(Expression leftExpressionOperator, NumericOperator numericOperator, Expression rigthExpressionOperator) {
        this.leftExpression = leftExpressionOperator;
        this.numericOperator = numericOperator;
        this.rigthExpression = rigthExpressionOperator;
    }

    public static Expression parse(String text) {
        RealValue realValue = RealValue.parse(text);
        if (realValue != null) {
            return new Expression(realValue);
        }
        if (!Util.checkParentheses(text)) {
            return null;
        }
        int rootIndex = MarkingFunction.getRootOperatorPosition(text);
        if (rootIndex == Integer.MIN_VALUE && text.charAt(0) == '(' && text.charAt(text.length() - 1) == ')') {
            text = text.substring(1, text.length() - 1);
            return Expression.parse(text);
        }
        if (rootIndex == Integer.MIN_VALUE) {
            return null;
        }
        NumericOperator numericOperator = new NumericOperator(text.charAt(rootIndex));
        if (text.charAt(rootIndex) == '-' && rootIndex == 0) {
            String text1 = text.substring(rootIndex + 1);
            Expression notExpression = Expression.parse(text1);
            return new Expression(notExpression, numericOperator);
        }
        String text1 = text.substring(0, rootIndex);
        Expression leftExpression = Expression.parse(text1);
        if (leftExpression == null) {
            return null;
        }
        String text2 = text.substring(rootIndex + 1);
        Expression rigthExpression = Expression.parse(text2);
        if (rigthExpression == null) {
            return null;
        }
        return new Expression(leftExpression, numericOperator, rigthExpression);
    }

    public RealValue getRealValue() {
        return this.realValue;
    }

    public double evaluate() throws Exception {
        if (this.realValue != null) {
            return this.realValue.evaluate();
        }
        if (this.negativeExpression != null && this.numericOperator != null) {
            return -this.negativeExpression.evaluate();
        }
        if (this.numericOperator != null && this.leftExpression != null && this.rigthExpression != null) {
            if (this.numericOperator.getOperator() == '+') {
                return this.leftExpression.evaluate() + this.rigthExpression.evaluate();
            }
            if (this.numericOperator.getOperator() == '-') {
                return this.leftExpression.evaluate() - this.rigthExpression.evaluate();
            }
            if (this.numericOperator.getOperator() == '*') {
                return this.leftExpression.evaluate() * this.rigthExpression.evaluate();
            }
            if (this.numericOperator.getOperator() == '/') {
                return this.leftExpression.evaluate() / this.rigthExpression.evaluate();
            }
            if (this.numericOperator.getOperator() == '^') {
                return (int)Math.pow(this.leftExpression.evaluate(), this.rigthExpression.evaluate());
            }
        }
        throw new Exception("Error: Evaluate Expressions");
    }

    public void updateMetrics(double time) throws Exception {
        if (this.realValue != null) {
            this.realValue.updateMetrics(time);
        }
        if (this.negativeExpression != null && this.numericOperator != null) {
            this.negativeExpression.updateMetrics(time);
        }
        if (this.numericOperator != null && this.leftExpression != null && this.rigthExpression != null) {
            this.leftExpression.updateMetrics(time);
            this.rigthExpression.updateMetrics(time);
        }
    }
}

