/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import java.util.ArrayList;
import org.modcs.tools.spn.model.expressions.MarkingFunction;
import org.modcs.tools.spn.model.expressions.NumberTokensAndTime;

public class Expectation
implements Serializable {
    private static final long serialVersionUID = 5445090151713325817L;
    private MarkingFunction markingFunction;
    private ArrayList<NumberTokensAndTime> listTokensAndTime;
    private double totalTime;

    public MarkingFunction getMarkingFunction() {
        return this.markingFunction;
    }

    public void setMarkingFunction(MarkingFunction markingFunction) {
        this.markingFunction = markingFunction;
    }

    public Expectation(MarkingFunction markingFunction) {
        this.markingFunction = markingFunction;
        this.listTokensAndTime = new ArrayList();
        this.totalTime = 0.0;
    }

    public static Expectation parse(String text) {
        if (!text.substring(0, 2).equals("E{") || !text.substring(text.length() - 1).equals("}")) {
            return null;
        }
        MarkingFunction markingFunction = MarkingFunction.parse(text.substring(2, text.length() - 1));
        if (markingFunction == null) {
            return null;
        }
        return new Expectation(markingFunction);
    }

    public double evaluate() {
        double result = 0.0;
        if (this.listTokensAndTime.isEmpty()) {
            return 0.0;
        }
        for (NumberTokensAndTime numberTokensAndTime : this.listTokensAndTime) {
            result += (double)numberTokensAndTime.getTokens() * numberTokensAndTime.getTime();
        }
        if (this.totalTime == 0.0) {
            return 0.0;
        }
        return result /= this.totalTime;
    }

    public void updateMetrics(double time) throws Exception {
        this.totalTime += time;
        int tokens = this.markingFunction.evaluate();
        NumberTokensAndTime tokensAndTime = new NumberTokensAndTime(tokens, time);
        int index = this.listTokensAndTime.indexOf(tokensAndTime);
        if (index != -1) {
            this.listTokensAndTime.get(index).addTime(tokensAndTime.getTime());
        } else {
            this.listTokensAndTime.add(tokensAndTime);
        }
    }
}

