/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import org.modcs.tools.spn.model.ArcInhibitor;
import org.modcs.tools.spn.model.ArcInput;
import org.modcs.tools.spn.model.ArcOutput;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.RaceType;
import org.modcs.tools.spn.model.expressions.IfElseExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transition
implements Serializable,
Cloneable {
    private String name;
    private double delay;
    private FiringPolicy firingPolicy;
    private RaceType raceType;
    private ArrayList<ArcInput> arcInputs;
    private ArrayList<ArcOutput> arcOutputs;
    private ArrayList<ArcInhibitor> arcInhibitors;
    private Point2D positionTransition;
    private Point2D positionTag;
    private int countRemaingInList;
    private IfElseExpression delayExpression;

    public Transition(String name, double delay, FiringPolicy firingPolicy, RaceType raceType, ArrayList<ArcInput> arcInputs, ArrayList<ArcOutput> arcOutputs, ArrayList<ArcInhibitor> arcInhibitors) {
        this.name = name;
        this.delay = delay;
        this.firingPolicy = firingPolicy;
        this.raceType = raceType;
        this.arcInputs = arcInputs;
        this.arcOutputs = arcOutputs;
        this.arcInhibitors = arcInhibitors;
    }

    public Transition(String name, double delay, FiringPolicy firingPolicy, RaceType raceType, ArrayList<ArcInput> arcInputs, ArrayList<ArcOutput> arcOutputs, ArrayList<ArcInhibitor> arcInhibitors, Point2D posTrans, Point2D posTag) {
        this(name, delay, firingPolicy, raceType, arcInputs, arcOutputs, arcInhibitors);
        this.positionTag = posTag;
        this.positionTransition = posTrans;
    }

    public int getCountRemaingInList() {
        return this.countRemaingInList;
    }

    public void setCountRemaingInList(int countRemaingInList) {
        this.countRemaingInList = countRemaingInList;
    }

    public void incrementCountRemaingInList() {
        ++this.countRemaingInList;
    }

    public Point2D getPositionTag() {
        return this.positionTag;
    }

    public void setPositionTag(Point2D positionTag) {
        this.positionTag = positionTag;
    }

    public Point2D getPositionTransition() {
        return this.positionTransition;
    }

    public void setPositionTransition(Point2D positionTransition) {
        this.positionTransition = positionTransition;
    }

    public String toString() {
        return this.getName();
    }

    public ArrayList<ArcInput> getArcInputs() {
        return this.arcInputs;
    }

    public ArrayList<ArcOutput> getArcOutputs() {
        return this.arcOutputs;
    }

    public void setArcInputs(ArrayList<ArcInput> arcInputs) {
        this.arcInputs = arcInputs;
    }

    public void setArcOutputs(ArrayList<ArcOutput> arcOutputs) {
        this.arcOutputs = arcOutputs;
    }

    public ArrayList<ArcInhibitor> getArcInhibitors() {
        return this.arcInhibitors;
    }

    public void setArcInhibitors(ArrayList<ArcInhibitor> arcInhibitors) {
        this.arcInhibitors = arcInhibitors;
    }

    public Transition(String name) {
        this.name = name;
    }

    public FiringPolicy getFiringPolicy() {
        return this.firingPolicy;
    }

    public void setFiringPolicy(FiringPolicy firingPolicy) {
        this.firingPolicy = firingPolicy;
    }

    public RaceType getRaceType() {
        return this.raceType;
    }

    public void setRaceType(RaceType raceType) {
        this.raceType = raceType;
    }

    public double getDelay() throws Exception {
        if (this.delayExpression != null) {
            return this.delayExpression.evaluate();
        }
        return this.delay;
    }

    public IfElseExpression getDelayExpression() {
        return this.delayExpression;
    }

    public void setDelayExpression(IfElseExpression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public String getName() {
        return this.name;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canFire() throws Exception {
        int i;
        boolean res = true;
        if (this.arcInputs != null) {
            for (i = 0; i < this.arcInputs.size(); ++i) {
                ArcInput arcInput = this.arcInputs.get(i);
                if (arcInput.getPlace().getMarking() >= arcInput.getMultiplicity()) continue;
                res = false;
                break;
            }
        }
        if (this.arcInhibitors != null) {
            for (i = 0; i < this.arcInhibitors.size(); ++i) {
                ArcInhibitor arcInhibitor = this.arcInhibitors.get(i);
                if (arcInhibitor.getPlace().getMarking() < arcInhibitor.getMultiplicity()) continue;
                res = false;
                break;
            }
        }
        return res;
    }

    public void fire() {
        int newMarking;
        Place placeTemp;
        int i;
        if (this.arcInputs != null) {
            for (i = 0; i < this.arcInputs.size(); ++i) {
                ArcInput arcInput = this.arcInputs.get(i);
                placeTemp = arcInput.getPlace();
                newMarking = placeTemp.getMarking() - arcInput.getMultiplicity();
                placeTemp.setMarking(newMarking);
            }
        }
        if (this.arcOutputs != null) {
            for (i = 0; i < this.arcOutputs.size(); ++i) {
                ArcOutput arcOutput = this.arcOutputs.get(i);
                placeTemp = arcOutput.getPlace();
                newMarking = placeTemp.getMarking() + arcOutput.getMultiplicity();
                placeTemp.setMarking(newMarking);
            }
        }
    }

    public int getEnablingDegree() {
        int enablingDegree = Integer.MAX_VALUE;
        for (int i = 0; i < this.arcInputs.size(); ++i) {
            ArcInput arcInput = this.arcInputs.get(i);
            int temp = (int)Math.floor(arcInput.getPlace().getMarking() / arcInput.getMultiplicity());
            if (temp >= enablingDegree) continue;
            enablingDegree = temp;
        }
        if (enablingDegree == Integer.MAX_VALUE) {
            enablingDegree = 0;
        }
        return enablingDegree;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

