/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import com.local.gui.JFrameDesdacTool;
import com.thoughtworks.xstream.XStream;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.modcs.tools.spn.gui.graphview.GraphEdX;
import org.modcs.tools.spn.model.Arc;
import org.modcs.tools.spn.model.ArcInhibitor;
import org.modcs.tools.spn.model.ArcInput;
import org.modcs.tools.spn.model.ArcOutput;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.model.EDSPN;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.RewardMeasure;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;

public class GraphView
extends JPanel
implements InterfaceModelGenerator {
    public static EDSPN edspn;
    private GraphEdX app;
    public static final double SCALE_FACTOR = 150.0;
    private Object parent;
    private File file;

    public void setFile(File file) {
        this.file = file;
    }

    public GraphView(EDSPN edspn, JToolBar toolBar, Object parent) throws Exception {
        this(toolBar, parent);
        if (edspn != null) {
            this.generateGraph(edspn);
        }
        GraphView.edspn = edspn;
    }

    public GraphView(JToolBar toolBar, Object parent) throws Exception {
        this.initComponents();
        this.parent = parent;
        this.app = new GraphEdX(toolBar, parent, this);
        this.app.setCanVerifyGraphChaged(true);
        this.app.clearHistory();
    }

    public DefaultGraphCell getVertexPlaceByName(String placeName) {
        DefaultGraphCell result = null;
        DefaultGraphModel model = (DefaultGraphModel)this.app.getGraph().getModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            Place place;
            DefaultGraphCell defaultGraphCell;
            Object object = model.getRootAt(i);
            if (!(object instanceof DefaultGraphCell) || !((defaultGraphCell = (DefaultGraphCell)object).getUserObject() instanceof Place) || !(place = (Place)defaultGraphCell.getUserObject()).getName().equals(placeName)) continue;
            result = defaultGraphCell;
            break;
        }
        return result;
    }

    public static EDSPN getEdspn() {
        return edspn;
    }

    public void setEdspn(EDSPN edspn) {
        GraphView.edspn = edspn;
    }

    public GraphEdX getApp() {
        return this.app;
    }

    private void generateGraph(EDSPN localEdspn) throws Exception {
        int i;
        for (int i2 = 0; i2 < localEdspn.getPlaces().size(); ++i2) {
            Place place = localEdspn.getPlaces().get(i2);
            Point2D.Double point = new Point2D.Double(place.getPositionPlace().getX() * 150.0, place.getPositionPlace().getY() * 150.0);
            this.app.insertWithoutUpdateGraph(point, "Place", place);
        }
        Object size = null;
        for (int i3 = 0; i3 < localEdspn.getTransitions().size(); ++i3) {
            GraphLayoutCache cache;
            DefaultEdge edge;
            DefaultGraphCell vertexPlace;
            String name;
            int j;
            Transition transition = localEdspn.getTransitions().get(i3);
            DefaultGraphCell vertexTrans = null;
            Point2D.Double pointTrans = null;
            if (transition instanceof TransitionExponential) {
                pointTrans = new Point2D.Double(transition.getPositionTransition().getX() * 150.0 + 20.0, transition.getPositionTransition().getY() * 150.0 + 40.0);
                vertexTrans = this.app.insertWithoutUpdateGraph(pointTrans, "TransitionExponential", transition);
            } else {
                pointTrans = new Point2D.Double(transition.getPositionTransition().getX() * 150.0 + 20.0, transition.getPositionTransition().getY() * 150.0 + 40.0);
                vertexTrans = this.app.insertWithoutUpdateGraph(pointTrans, "TransitionImmediate", transition);
            }
            if (transition.getArcInputs() != null) {
                for (j = 0; j < transition.getArcInputs().size(); ++j) {
                    ArcInput arcInput = transition.getArcInputs().get(j);
                    arcInput.setTransition(transition);
                    name = arcInput.getPlace().getName();
                    vertexPlace = this.getVertexPlaceByName(name);
                    if (vertexPlace == null) continue;
                    edge = new DefaultEdge((Object)arcInput);
                    edge.getAttributes().applyMap(this.app.createEdgeAttributes());
                    cache = this.app.getGraph().getGraphLayoutCache();
                    cache.insertEdge((Object)edge, (Object)vertexPlace.getChildAt(0), (Object)vertexTrans.getChildAt(0));
                }
            }
            if (transition.getArcOutputs() != null) {
                for (j = 0; j < transition.getArcOutputs().size(); ++j) {
                    ArcOutput arcOutput = transition.getArcOutputs().get(j);
                    arcOutput.setTransition(transition);
                    name = arcOutput.getPlace().getName();
                    vertexPlace = this.getVertexPlaceByName(name);
                    if (vertexPlace == null) continue;
                    edge = new DefaultEdge((Object)arcOutput);
                    edge.getAttributes().applyMap(this.app.createEdgeAttributes());
                    cache = this.app.getGraph().getGraphLayoutCache();
                    cache.insertEdge((Object)edge, (Object)vertexTrans.getChildAt(0), (Object)vertexPlace.getChildAt(0));
                }
            }
            if (transition.getArcInhibitors() == null) continue;
            for (j = 0; j < transition.getArcInhibitors().size(); ++j) {
                ArcInhibitor arcInhibitor = transition.getArcInhibitors().get(j);
                arcInhibitor.setTransition(transition);
                name = arcInhibitor.getPlace().getName();
                vertexPlace = this.getVertexPlaceByName(name);
                if (vertexPlace == null) continue;
                edge = new DefaultEdge((Object)arcInhibitor);
                this.app.setArcType(true);
                edge.getAttributes().applyMap(this.app.createEdgeAttributes());
                this.app.setArcType(false);
                cache = this.app.getGraph().getGraphLayoutCache();
                cache.insertEdge((Object)edge, (Object)vertexPlace.getChildAt(0), (Object)vertexTrans.getChildAt(0));
            }
        }
        int positionVertical = this.app.getPositionRewardMeasureVertical();
        for (i = 0; i < localEdspn.getRewardMeasures().size(); ++i) {
            RewardMeasure rewardMeasure = localEdspn.getRewardMeasures().get(i);
            Point2D.Double point = new Point2D.Double(20.0, 20 * positionVertical++);
            this.app.insertWithoutUpdateGraph(point, "RewardMeasure", rewardMeasure);
        }
        for (i = 0; i < localEdspn.getDelayParameters().size(); ++i) {
            DelayParameter delayParameter = localEdspn.getDelayParameters().get(i);
            this.app.insertWithoutUpdateGraph(delayParameter.getPosition(), "Label", delayParameter);
        }
        this.app.setPositionRewardMeasureVertical(positionVertical);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 446, Short.MAX_VALUE));
    }

    public DelayParameter getDelayParameterFromGraph(String delayParameterName) {
        DefaultGraphCell defaultGraphCell = this.getDelayGraphCellFromGraph(delayParameterName);
        if (defaultGraphCell != null) {
            return (DelayParameter)defaultGraphCell.getUserObject();
        }
        return null;
    }

    public DefaultGraphCell getDelayGraphCellFromGraph(String delayParameterName) {
        GraphModel graphModel = this.app.getGraph().getModel();
        for (int i = 0; i < graphModel.getRootCount(); ++i) {
            DelayParameter delayParameter;
            Object object = graphModel.getRootAt(i);
            if (!(object instanceof DefaultGraphCell)) continue;
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
            Rectangle2D rectangle = this.app.getGraph().getCellBounds((Object)defaultGraphCell);
            object = defaultGraphCell.getUserObject();
            if (!(object instanceof DelayParameter) || !(delayParameter = (DelayParameter)object).getName().equals(delayParameterName)) continue;
            return defaultGraphCell;
        }
        return null;
    }

    public EDSPN makeEDSPN() {
        Transition transition;
        Object object;
        int i;
        GraphModel graphModel = this.app.getGraph().getModel();
        ArrayList<Place> places = new ArrayList<Place>();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        ArrayList<RewardMeasure> rewardMeasures = new ArrayList<RewardMeasure>();
        ArrayList<DelayParameter> delayParameters = new ArrayList<DelayParameter>();
        for (i = 0; i < graphModel.getRootCount(); ++i) {
            Point2D.Double point;
            object = graphModel.getRootAt(i);
            if (!(object instanceof DefaultGraphCell)) continue;
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
            Rectangle2D rectangle = this.app.getGraph().getCellBounds((Object)defaultGraphCell);
            object = defaultGraphCell.getUserObject();
            if (object instanceof Place) {
                Place place = (Place)object;
                point = new Point2D.Double(rectangle.getX() / 150.0, rectangle.getY() / 150.0);
                place.setPositionPlace(point);
                places.add(place);
            }
            if (object instanceof DelayParameter) {
                DelayParameter delayParameter = (DelayParameter)object;
                delayParameters.add(delayParameter);
            }
            if (object instanceof RewardMeasure) {
                RewardMeasure rewardMeasure = (RewardMeasure)object;
                rewardMeasures.add(rewardMeasure);
            }
            if (!(object instanceof Transition)) continue;
            transition = (Transition)object;
            point = new Point2D.Double((rectangle.getX() - 20.0) / 150.0, (rectangle.getY() - 40.0) / 150.0);
            transition.setPositionTransition(point);
            transition.setArcInputs(null);
            transition.setArcOutputs(null);
            transitions.add(transition);
        }
        for (i = 0; i < graphModel.getRootCount(); ++i) {
            Arc arc;
            object = graphModel.getRootAt(i);
            if (!(object instanceof DefaultEdge)) continue;
            DefaultEdge defaultEdge = (DefaultEdge)object;
            if ((object = defaultEdge.getUserObject()) instanceof ArcInput) {
                arc = (ArcInput)object;
                transition = arc.getTransition();
                ArrayList<ArcInput> arcInputs = transition.getArcInputs();
                if (arcInputs == null) {
                    arcInputs = new ArrayList();
                    transition.setArcInputs(arcInputs);
                }
                transition.getArcInputs().add((ArcInput)arc);
            }
            if (object instanceof ArcOutput) {
                arc = (ArcOutput)object;
                transition = arc.getTransition();
                ArrayList<ArcOutput> arcOutputs = transition.getArcOutputs();
                if (arcOutputs == null) {
                    arcOutputs = new ArrayList();
                    transition.setArcOutputs(arcOutputs);
                }
                transition.getArcOutputs().add((ArcOutput)arc);
            }
            if (!(object instanceof ArcInhibitor)) continue;
            arc = (ArcInhibitor)object;
            transition = arc.getTransition();
            ArrayList<ArcInhibitor> arcInhibitors = transition.getArcInhibitors();
            if (arcInhibitors == null) {
                arcInhibitors = new ArrayList();
                transition.setArcInhibitors(arcInhibitors);
            }
            transition.getArcInhibitors().add((ArcInhibitor)arc);
        }
        edspn = new EDSPN(places, transitions, rewardMeasures, delayParameters);
        JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.parent;
        jFrameDesdacTool.updateJtree(edspn);
        return edspn;
    }

    public EDSPN generateModel() throws FileNotFoundException, Exception {
        EDSPN myEdspn = null;
        File fileTemp = new File("GSPN_Temp.xml");
        if (fileTemp != null) {
            XStream xs = new XStream();
            try {
                FileInputStream fis = new FileInputStream(fileTemp);
                myEdspn = (EDSPN)xs.fromXML((InputStream)fis);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return myEdspn;
    }
}

