/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui;

import com.local.gui.JFrameDesdacTool;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.modcs.tools.spn.simulator.engine.TransientParameters;

public class JDialogGetTransientParametersSimulation
extends JDialog {
    File file;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonFileOutput;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JTextField jTextFieldConfidenceLevel;
    private JTextField jTextFieldMaxRelativeError;
    private JTextField jTextFieldMaxSimulationRealTime;
    private JTextField jTextFieldMaxSimulationTime;
    private JTextField jTextFieldNumberSamplingPoints;

    public JDialogGetTransientParametersSimulation(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage("/org/modcs/tools/gui/icons/gear-arrow.png");
        this.setIconImage(img);
        if (this.getParent() instanceof JFrameDesdacTool) {
            JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
            jFrameDesdacTool.setStationaryParameters(null);
        }
    }

    protected JFileChooser initFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName() == null) {
                    return false;
                }
                if (f.getName().endsWith(".txt")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "TXT FILES(.txt)";
            }
        };
        fileChooser.setFileFilter(fileFilter);
        return fileChooser;
    }

    private void initFile() {
        JFileChooser fileChooser = this.initFileChooser();
        fileChooser.setSelectedFile(new File("Output.txt"));
        int returnValue = 1;
        this.initFileChooser();
        returnValue = fileChooser.showDialog(this, "Select the output file");
        if (returnValue == 0) {
            try {
                this.file = fileChooser.getSelectedFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error Open the File", 0);
            }
        }
    }

    private void initComponents() {
        this.jTextFieldMaxSimulationRealTime = new JTextField();
        this.jSeparator6 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.jTextFieldNumberSamplingPoints = new JTextField();
        this.jSeparator4 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldMaxSimulationTime = new JTextField();
        this.jButton1 = new JButton();
        this.jTextFieldMaxRelativeError = new JTextField();
        this.jTextFieldConfidenceLevel = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jButtonFileOutput = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transient Parameters");
        this.jTextFieldMaxSimulationRealTime.setText("0");
        this.jLabel5.setText("Max simulation real time (sec)");
        this.jTextFieldNumberSamplingPoints.setText("30");
        this.jLabel4.setText("# Sampling Points");
        this.jLabel1.setText("Confidence Level %");
        this.jLabel6.setText("File Containing Results");
        this.jTextFieldMaxSimulationTime.setText("50000");
        this.jButton1.setText("Run");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogGetTransientParametersSimulation.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextFieldMaxRelativeError.setText("10");
        this.jTextFieldMaxRelativeError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogGetTransientParametersSimulation.this.jTextFieldMaxRelativeErrorActionPerformed(evt);
            }
        });
        this.jTextFieldConfidenceLevel.setText("95");
        this.jLabel2.setText("Max. Relative Error %");
        this.jLabel3.setText("Simulation Time");
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogGetTransientParametersSimulation.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButtonFileOutput.setText("...");
        this.jButtonFileOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogGetTransientParametersSimulation.this.jButtonFileOutputActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator6, -1, 285, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 285, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 285, Short.MAX_VALUE).addComponent(this.jSeparator3, -1, 285, Short.MAX_VALUE).addComponent(this.jSeparator4, -1, 285, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.jTextFieldMaxRelativeError, -2, 75, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 113, Short.MAX_VALUE).addComponent(this.jTextFieldConfidenceLevel, -2, 76, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 137, Short.MAX_VALUE).addComponent(this.jTextFieldMaxSimulationTime, -2, 75, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel4, -1, 200, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.jTextFieldNumberSamplingPoints, -2, 75, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel5, -1, 200, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.jTextFieldMaxSimulationRealTime, -2, 75, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSeparator5, -1, 283, Short.MAX_VALUE).addGap(2, 2, 2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -1, 188, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonFileOutput, -2, 79, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton1, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2, -2, 81, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldConfidenceLevel, -2, -1, -2).addComponent(this.jLabel1, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 20, -2).addComponent(this.jTextFieldMaxRelativeError, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 20, -2).addComponent(this.jTextFieldMaxSimulationTime, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 20, -2).addComponent(this.jTextFieldNumberSamplingPoints, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator4, -2, 2, -2).addComponent(this.jSeparator4, -2, 2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldMaxSimulationRealTime, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jButtonFileOutput)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator6, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        double confidenceLevel = Double.parseDouble(this.jTextFieldConfidenceLevel.getText());
        double maxRelativeError = Double.parseDouble(this.jTextFieldMaxRelativeError.getText());
        long maxSimulationTime = Long.parseLong(this.jTextFieldMaxSimulationTime.getText());
        long samplingPoints = Long.parseLong(this.jTextFieldNumberSamplingPoints.getText());
        int maxSimulationRealTime = Integer.parseInt(this.jTextFieldMaxSimulationRealTime.getText()) * 1000;
        confidenceLevel /= 100.0;
        maxRelativeError /= 100.0;
        if (this.file == null) {
            this.initFile();
            if (this.file == null) {
                this.dispose();
                return;
            }
        }
        TransientParameters parameters = new TransientParameters(confidenceLevel, maxRelativeError, maxSimulationRealTime, maxSimulationTime, samplingPoints, this.file, true);
        JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
        jFrameDesdacTool.setTransientParameters(parameters);
        this.dispose();
    }

    private void jTextFieldMaxRelativeErrorActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonFileOutputActionPerformed(ActionEvent evt) {
        this.initFile();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogGetTransientParametersSimulation dialog = new JDialogGetTransientParametersSimulation((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

