/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.experiment;

import com.local.gui.JFrameDesdacTool;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.modcs.tools.spn.experiment.ExperimentParameters;
import org.modcs.tools.spn.experiment.ExperimentResult;
import org.modcs.tools.spn.gui.JDialogExperimentOutput;
import org.modcs.tools.spn.gui.JDialogExperimentProgress;
import org.modcs.tools.spn.gui.graphview.GraphView;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.simulator.engine.Engine;
import org.modcs.tools.spn.simulator.engine.EngineRemoveTransient;
import org.modcs.tools.spn.simulator.engine.StationaryParameters;
import org.modcs.tools.spn.simulator.engine.TransientParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentEngine
implements PropertyChangeListener {
    private Engine engine;
    private StationaryParameters stationaryParameters;
    private ExperimentParameters experimentParameters;
    private TransientParameters transientParameters;
    private GraphView graphView;
    private JFrameDesdacTool jFrameDesdacTool;
    private JDialogExperimentProgress jDialogExperimentProgress;
    private JProgressBar jProgressBar;
    private TaskStationaty taskStationaty;
    private TaskExperiment taskExperiment;
    private TaskTransient taskTransient;

    public ExperimentEngine(JFrameDesdacTool jFrameDesdacTool, Engine engine, StationaryParameters stationaryParameters, ExperimentParameters experimentParameters, GraphView graphView) {
        this.engine = engine;
        this.stationaryParameters = stationaryParameters;
        this.experimentParameters = experimentParameters;
        this.graphView = graphView;
        this.jFrameDesdacTool = jFrameDesdacTool;
    }

    public ExperimentEngine(JFrameDesdacTool jFrameDesdacTool, Engine engine, TransientParameters transientParameters, GraphView graphView) {
        this.jFrameDesdacTool = jFrameDesdacTool;
        this.engine = engine;
        this.transientParameters = transientParameters;
        this.graphView = graphView;
    }

    public ExperimentEngine(JFrameDesdacTool jFrameDesdacTool, Engine engine, StationaryParameters stationaryParameters, GraphView graphView) {
        this.jFrameDesdacTool = jFrameDesdacTool;
        this.engine = engine;
        this.stationaryParameters = stationaryParameters;
        this.graphView = graphView;
    }

    public void saveGraph() {
        this.graphView.makeEDSPN();
        this.jFrameDesdacTool.saveEdspn(GraphView.edspn);
    }

    public static double[][] createSeries(ArrayList<ExperimentResult> values) {
        double[][] series = new double[2][values.size()];
        for (int i = 0; i < values.size(); ++i) {
            series[0][i] = values.get(i).getDelayParameterValue();
            series[1][i] = values.get(i).getResult();
        }
        return series;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.jProgressBar.setValue(progress);
            if (this.taskExperiment != null) {
                this.jDialogExperimentProgress.getjTextAreaOutputTask().append(String.format("Completed experiment %d.\n", this.taskExperiment.getProgress()));
            } else if ((this.taskStationaty != null || this.taskTransient != null) && this.engine.getText() != null) {
                this.jDialogExperimentProgress.getjTextAreaOutputTask().append(this.engine.getText());
            }
        }
    }

    public void executeExperiment() {
        this.jDialogExperimentProgress = new JDialogExperimentProgress((Frame)this.jFrameDesdacTool, true);
        this.jDialogExperimentProgress.setLocationRelativeTo(null);
        this.jProgressBar = this.jDialogExperimentProgress.getjProgressBar();
        this.jDialogExperimentProgress.getjPanel().setOpaque(true);
        if (this.stationaryParameters != null) {
            try {
                int numberPoints = this.getNumberPoints();
                this.jProgressBar.setMinimum(0);
                this.jProgressBar.setMaximum(numberPoints);
                this.jProgressBar.setValue(0);
                this.jProgressBar.setStringPainted(true);
                this.jDialogExperimentProgress.getjButton().setEnabled(false);
                this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(3));
                this.taskExperiment = new TaskExperiment();
                this.taskExperiment.addPropertyChangeListener(this);
                this.taskExperiment.execute();
                this.jDialogExperimentProgress.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void executeStationary() {
        this.jDialogExperimentProgress = new JDialogExperimentProgress((Frame)this.jFrameDesdacTool, true);
        this.jDialogExperimentProgress.setLocationRelativeTo(null);
        this.jProgressBar = this.jDialogExperimentProgress.getjProgressBar();
        this.jDialogExperimentProgress.getjPanel().setOpaque(true);
        if (this.stationaryParameters != null) {
            try {
                this.jProgressBar.setMinimum(1);
                this.jProgressBar.setMaximum(this.stationaryParameters.getWarmUpPeriod());
                this.jProgressBar.setValue(0);
                this.jProgressBar.setStringPainted(true);
                this.jDialogExperimentProgress.getjButton().setEnabled(false);
                this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(3));
                this.taskStationaty = new TaskStationaty();
                this.taskStationaty.addPropertyChangeListener(this);
                this.engine.setTaskStationaty(this.taskStationaty);
                this.taskStationaty.execute();
                this.jDialogExperimentProgress.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void executeTransient() {
        this.jDialogExperimentProgress = new JDialogExperimentProgress((Frame)this.jFrameDesdacTool, true);
        this.jDialogExperimentProgress.setLocationRelativeTo(null);
        this.jProgressBar = this.jDialogExperimentProgress.getjProgressBar();
        this.jDialogExperimentProgress.getjPanel().setOpaque(true);
        if (this.transientParameters != null) {
            try {
                this.jProgressBar.setMinimum(0);
                this.jProgressBar.setMaximum(100);
                this.jProgressBar.setValue(0);
                this.jProgressBar.setStringPainted(true);
                this.jDialogExperimentProgress.getjButton().setEnabled(false);
                this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(3));
                this.taskTransient = new TaskTransient();
                this.taskTransient.addPropertyChangeListener(this);
                this.engine.setTaskTransient(this.taskTransient);
                this.taskTransient.execute();
                this.jDialogExperimentProgress.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumberPoints() {
        double finalValue = this.experimentParameters.getMaxValue();
        double initialValue = this.experimentParameters.getMinValue();
        double interval = this.experimentParameters.getInterVal();
        int numberPoints = (int)((finalValue - initialValue) / interval);
        return numberPoints;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskTransient
    extends SwingWorker<Void, Void> {
        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ExperimentEngine.this.jDialogExperimentProgress.getjTextAreaOutputTask().append("Done!\n");
            ExperimentEngine.this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(0));
            ExperimentEngine.this.jDialogExperimentProgress.getjButton().setEnabled(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (ExperimentEngine.this.transientParameters != null) {
                try {
                    ExperimentEngine.this.engine.runTransient(ExperimentEngine.this.transientParameters);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                    ex.printStackTrace();
                }
            }
            return null;
        }

        public void setProgresso(int progress) {
            this.setProgress(Math.max(0, Math.min(progress, 100)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskStationaty
    extends SwingWorker<Void, Void> {
        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ExperimentEngine.this.jDialogExperimentProgress.getjTextAreaOutputTask().append("Done!\n");
            ExperimentEngine.this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(0));
            ExperimentEngine.this.jDialogExperimentProgress.getjButton().setEnabled(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (ExperimentEngine.this.stationaryParameters != null) {
                try {
                    ExperimentEngine.this.engine.runStationary(ExperimentEngine.this.stationaryParameters);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                    ex.printStackTrace();
                }
            }
            return null;
        }

        public void setProgresso(int progress) {
            this.setProgress(Math.min(progress, ExperimentEngine.this.jProgressBar.getMaximum() - 1));
        }

        public void setMaximum() {
            this.setProgress(ExperimentEngine.this.jProgressBar.getMaximum());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskExperiment
    extends SwingWorker<Void, Void> {
        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ExperimentEngine.this.jDialogExperimentProgress.getjTextAreaOutputTask().append("Done!\n");
            ExperimentEngine.this.jFrameDesdacTool.setCursor(Cursor.getPredefinedCursor(0));
            ExperimentEngine.this.jDialogExperimentProgress.getjButton().setEnabled(true);
        }

        public void setProgresso(int progress) {
            this.setProgress(progress);
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (ExperimentEngine.this.stationaryParameters != null) {
                try {
                    ExperimentEngine.this.engine.setExperiment(true);
                    DelayParameter delayParameterTemp = ExperimentEngine.this.experimentParameters.getDelayParameterHoldValue().clone();
                    String nameDelayParameter = delayParameterTemp.getName();
                    DelayParameter delayParameterFound = ExperimentEngine.this.graphView.getDelayParameterFromGraph(nameDelayParameter);
                    if (delayParameterFound == null) {
                        return null;
                    }
                    double initialValue = ExperimentEngine.this.experimentParameters.getMinValue();
                    double interval = ExperimentEngine.this.experimentParameters.getInterVal();
                    ArrayList<ExperimentResult> experimentResults = new ArrayList<ExperimentResult>();
                    for (int i = 0; i < ExperimentEngine.this.getNumberPoints() + 1; ++i) {
                        double delayParameterValue = initialValue + (double)i * interval;
                        delayParameterFound.setValue(delayParameterValue);
                        ExperimentEngine.this.saveGraph();
                        ExperimentEngine.this.engine.runStationary(ExperimentEngine.this.stationaryParameters);
                        double result = ExperimentEngine.this.engine.getResult();
                        if (ExperimentEngine.this.stationaryParameters.isRemoveTransient()) {
                            ExperimentEngine.this.engine = new EngineRemoveTransient(ExperimentEngine.this.graphView);
                        } else {
                            ExperimentEngine.this.engine = new Engine(ExperimentEngine.this.graphView);
                        }
                        ExperimentEngine.this.engine.setExperiment(true);
                        experimentResults.add(new ExperimentResult(delayParameterValue, result));
                        this.setProgress(i);
                    }
                    double[][] series = ExperimentEngine.createSeries(experimentResults);
                    JDialogExperimentOutput jDialogExperimentOutput = new JDialogExperimentOutput((Frame)ExperimentEngine.this.jFrameDesdacTool, true, series, experimentResults);
                    jDialogExperimentOutput.setLocationRelativeTo(ExperimentEngine.this.jFrameDesdacTool);
                    jDialogExperimentOutput.setVisible(true);
                    delayParameterFound.setValue(delayParameterTemp.getValue());
                    ExperimentEngine.this.saveGraph();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }
}

