/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.ApplicationRBD;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.ReliabilityAnalisysScreen;

public class MainScreen
extends JFrame {
    private ApplicationRBD app;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTree jTree1;

    public MainScreen(ApplicationRBD app) {
        this.initComponents();
        this.app = app;
        this.setExtendedState(this.getExtendedState() | 6);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("WellCome!");
        this.jTree1 = new JTree(top);
        this.jTree1.updateUI();
        this.jScrollPane1.setViewportView(this.jTree1);
        GraphViewRBD.GraphViewInit(app, this, this.jScrollPane2, null);
        GraphViewRBD.blockIconEdited = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/blockIconEdited.png"));
        GraphViewRBD.blockIconNotEdited = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/blockIconNotEdited.png"));
        this.jMenu2.setEnabled(false);
    }

    public ApplicationRBD getApp() {
        return this.app;
    }

    public void setApp(ApplicationRBD app) {
        if (app != null) {
            this.app = app;
        } else {
            System.err.println("Invalid Application");
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Evaluator RBD Tool");
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 148, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 649, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jMenu1.setText("File");
        this.jMenu1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jMenu1ActionPerformed(evt);
            }
        });
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(78, 1));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/icon/folder--plus.png")));
        this.jMenuItem2.setText("New");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(79, 1));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/icon/folder-horizontal-open.png")));
        this.jMenuItem1.setText("Open");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenuItem1.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyPressed(MenuKeyEvent evt) {
                MainScreen.this.jMenuItem1MenuKeyPressed(evt);
            }

            public void menuKeyReleased(MenuKeyEvent evt) {
            }

            public void menuKeyTyped(MenuKeyEvent evt) {
            }
        });
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jMenuItem1MouseClicked(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Analisys");
        this.jMenu2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jMenu2ActionPerformed(evt);
            }
        });
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(82, 1));
        this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/icon/folder--plus.png")));
        this.jMenuItem3.setText("Reliability");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 985, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 651, Short.MAX_VALUE));
        this.pack();
    }

    private void jMenuItem1MouseClicked(MouseEvent evt) {
    }

    private void jMenuItem1MenuKeyPressed(MenuKeyEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        GraphViewRBD.paint();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        ReliabilityAnalisysScreen reliabilityAnalisysScreen = new ReliabilityAnalisysScreen((Frame)this, true);
        reliabilityAnalisysScreen.setLocationRelativeTo(this);
        reliabilityAnalisysScreen.setVisible(true);
    }

    private void jMenu2ActionPerformed(ActionEvent evt) {
    }

    private void jMenu1ActionPerformed(ActionEvent evt) {
    }

    public void updateJTree(RBDModel rbdModel) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(rbdModel.getName());
        this.jTree1 = new JTree(top);
        ImageIcon seriesIcon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/teste.png"));
        ImageIcon bridgeIcon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/bridgeIcon.png"));
        if (seriesIcon != null && bridgeIcon != null) {
            NetRenderer renderer = new NetRenderer((Icon)seriesIcon, bridgeIcon);
            this.jTree1.setCellRenderer(renderer);
        } else {
            System.err.println("Icon missing; using default.");
        }
        rbdModel.getModel().updateJTree(top);
        this.jPanel1.updateUI();
        this.jScrollPane1.setViewportView(this.jTree1);
    }

    public void openFile() throws HeadlessException {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(0);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName() == null) {
                    return false;
                }
                if (f.getName().endsWith(".RBD")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "TN files (.TN)";
            }
        };
        fc.showOpenDialog(this);
        try {
            File fileTemp = fc.getSelectedFile();
            if (fileTemp == null) {
                return;
            }
            this.app.setRBDModel(this.app.getFileHandler().openModel(fileTemp.getAbsolutePath()));
            this.updateJTree(this.app.getRBDModel());
            this.setTitle("Evaluator RBD " + this.app.getRBDModel().getName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getStackTrace(), ex.getMessage(), 0);
        }
    }

    private class NetRenderer
    extends DefaultTreeCellRenderer {
        Icon seriesIcon;
        Icon bridgeIcon;

        public NetRenderer(Icon seriesIcon, Icon bridgeIcon) {
            this.seriesIcon = seriesIcon;
            this.bridgeIcon = bridgeIcon;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.isSeries(value)) {
                this.setIcon(this.seriesIcon);
            }
            if (this.isBridge(value)) {
                this.setIcon(this.bridgeIcon);
            }
            return this;
        }

        protected boolean isSeries(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            return node.getUserObject() instanceof BlockSeries;
        }

        protected boolean isBridge(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            return node.getUserObject() instanceof BlockBridge;
        }
    }
}

